/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.DownloadCRLConfig;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DownLoadCRLConfigParser {
    private static String ConfigNM = "";
    private HashMap pool;
    private static String sp = System.getProperty("line.separator");
    private static String fp = System.getProperty("file.separator");

    public DownLoadCRLConfigParser() {
    }

    public DownLoadCRLConfigParser(String configpath, String configname) throws Exception {
        ConfigNM = !configpath.endsWith(fp) ? String.valueOf(configpath) + fp + configname : String.valueOf(configpath) + configname;
        this.pool = new HashMap();
        this.getConfig();
    }

    public HashMap getConfigEntryValues(String ConfigElementKeyNM) {
        return (HashMap)this.pool.get(ConfigElementKeyNM);
    }

    public void setConfigEntryItemValue(String EntryName, String ItemName, String ItemValue) throws Exception {
        if (!this.pool.containsKey(EntryName)) {
            throw new Exception("The DownLoadCrl Config File has not Contains Entry " + EntryName);
        }
        HashMap temp = (HashMap)this.pool.get(EntryName);
        temp.put(ItemName, ItemValue);
    }

    public String getConfigEntryItemValue(String EntryName, String ItemName) {
        return (String)((HashMap)this.pool.get(EntryName)).get(ItemName);
    }

    private synchronized void getConfig() throws Exception {
        this.pool.clear();
        HashMap<String, String> map = new HashMap<String, String>();
        this.pool.put("INFO", map);
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(ConfigNM);
            Element root = doc.getDocumentElement();
            Element node = (Element)root.getElementsByTagName("connection").item(0);
            String type = node.getAttribute("type");
            map.put("downtype", type);
            String timeout = ((Element)root.getElementsByTagName("timeout").item(0)).getTextContent();
            map.put("timeout", timeout);
            String isreal = ((Element)((Element)root.getElementsByTagName("store-rule").item(0)).getElementsByTagName("store-path").item(0)).getAttribute("isreal");
            map.put("isreal", isreal);
            String store_path = ((Element)root.getElementsByTagName("store-path").item(0)).getTextContent();
            map.put("store-path", store_path);
            Text text = (Text)node.getElementsByTagName("url").item(0).getFirstChild();
            String value = text.getNodeValue();
            if (type.equals("ldap")) {
                map.put("ldaphost", value);
            } else if (type.equals("http")) {
                map.put("httpurl", value);
            }
            value = ((Text)root.getElementsByTagName("download-interval").item(0).getFirstChild()).getNodeValue();
            map.put("timerspan", String.valueOf(Integer.parseInt(value) / 1000));
            node = (Element)root.getElementsByTagName("download-rule").item(0);
            if (type.equals("ldap")) {
                this.parseLdap(map, node);
            } else if (type.equals("http")) {
                this.parseHttp(map, node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseLdap(HashMap map, Element node) {
        try {
            String value = ((Text)node.getElementsByTagName("base-dn").item(0).getFirstChild()).getNodeValue();
            map.put("searchbasedn", value);
            Element cr = (Element)node.getElementsByTagName("common-rule").item(0);
            Element tmp = (Element)cr.getElementsByTagName("prefix-content").item(0);
            value = "";
            NodeList list = tmp.getElementsByTagName("value");
            int i = 0;
            int length = list.getLength();
            while (i < length) {
                value = String.valueOf(value) + ((Text)list.item(i).getFirstChild()).getNodeValue();
                if (i != length - 1) {
                    value = String.valueOf(value) + " | ";
                }
                ++i;
            }
            map.put("searchfilter", value);
            tmp = (Element)cr.getElementsByTagName("mid-content").item(0);
            value = ((Text)tmp.getElementsByTagName("range").item(0).getFirstChild()).getNodeValue();
            map.put("maxcrls", value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseHttp(HashMap map, Element node) {
        try {
            Element tmp = (Element)node.getElementsByTagName("special-rule").item(0);
            String value = "";
            NodeList list = tmp.getElementsByTagName("value");
            int i = 0;
            int length = list.getLength();
            while (i < length) {
                value = String.valueOf(value) + ((Text)list.item(i).getFirstChild()).getNodeValue();
                if (i != length - 1) {
                    value = String.valueOf(value) + " | ";
                }
                ++i;
            }
            map.put("crlfilename", value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void putConfig() throws Exception {
        DownloadCRLConfig config = new DownloadCRLConfig(ConfigNM);
        config.pool = this.pool;
        config.putConfig();
    }

    public synchronized void putConfigbak() throws Exception {
        DataOutputStream dout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(ConfigNM)));
        if (this.pool != null) {
            Iterator keyiter = this.pool.keySet().iterator();
            while (keyiter.hasNext()) {
                String keyname = (String)keyiter.next();
                dout.writeBytes("[" + keyname + "]" + sp);
                HashMap elementHash = (HashMap)this.pool.get(keyname);
                Iterator elementkeyiter = elementHash.keySet().iterator();
                while (elementkeyiter.hasNext()) {
                    String keyelement = (String)elementkeyiter.next();
                    dout.writeBytes(String.valueOf(keyelement) + "=" + (String)elementHash.get(keyelement) + sp);
                }
                dout.writeBytes(sp);
            }
        }
        dout.close();
    }

    public static void main(String[] args) throws Exception {
        DownLoadCRLConfigParser netsafe = new DownLoadCRLConfigParser("c:", "CFCA_cfg.ini");
        netsafe.getConfig();
        System.out.println(netsafe.getConfigEntryItemValue("SEARCH", "searchbasedn"));
        netsafe.putConfig();
    }
}

