/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.util.PKCS10Utils;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DomUtil {
    private static DocumentBuilder documentBuilder;
    private String filepath;
    private static Document doc;

    public DomUtil(String filepath) {
        this.filepath = filepath;
        DocumentBuilder builder = DomUtil.getDocumentBuilder();
        try {
            doc = builder.parse(new File(filepath));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Element getElementByDN(String subject) {
        subject = CryptoUtil.turnDN((String)subject);
        Element root = doc.getDocumentElement();
        NodeList keyTags = root.getElementsByTagName("subject");
        Element parent = null;
        int i = 0;
        while (i < keyTags.getLength()) {
            Node key = keyTags.item(i);
            String dn = key.getTextContent();
            if (dn != null && (dn = CryptoUtil.turnDN((String)dn)).equals(subject)) {
                parent = (Element)key.getParentNode();
                break;
            }
            ++i;
        }
        return parent;
    }

    public boolean save(SM2Certificate cert, String usage) {
        if (cert.getSubjectDN() != null && this.getCertByDN(cert.getSubjectDN().toString()) != null) {
            return true;
        }
        Element keyTag = doc.createElement("key");
        keyTag.setAttribute("mode", "hard.sm2");
        Element keytype = doc.createElement("keytype");
        keytype.setTextContent("SM2");
        keyTag.appendChild(keytype);
        String alias = PKCS10Utils.genAlias(cert.getSubjectDN().getName(), cert.getPublicKey());
        Element aliasTag = doc.createElement("alias");
        aliasTag.setTextContent(alias);
        keyTag.appendChild(aliasTag);
        Element pubkey = doc.createElement("pubkey");
        pubkey.setTextContent(Base64.encode((byte[])cert.getPublicKeyEncoded()));
        keyTag.appendChild(pubkey);
        Element certTag = doc.createElement("cert");
        try {
            certTag.setTextContent(Base64.encode((byte[])cert.getEncoded()));
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
        }
        catch (DOMException e) {
            e.printStackTrace();
        }
        keyTag.appendChild(certTag);
        Element subjectTag = doc.createElement("subject");
        subjectTag.setTextContent(cert.getSubjectDN().toString());
        keyTag.appendChild(subjectTag);
        Element issuerTag = doc.createElement("issuer");
        issuerTag.setTextContent(cert.getIssuerDNStr());
        keyTag.appendChild(issuerTag);
        Element notBeforeTag = doc.createElement("not-before");
        notBeforeTag.setTextContent("" + cert.getNotBefore().getTime());
        keyTag.appendChild(notBeforeTag);
        Element notAfterTag = doc.createElement("not-after");
        notAfterTag.setTextContent("" + cert.getNotAfter().getTime());
        keyTag.appendChild(notAfterTag);
        Element usageTag = doc.createElement("usage");
        usageTag.setTextContent(usage);
        keyTag.appendChild(usageTag);
        Element root = doc.getDocumentElement();
        root.appendChild(keyTag);
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(this.filepath));
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public SM2Certificate getCertByDN(String subject) {
        Element parent = this.getElementByDN(subject);
        if (parent == null) {
            return null;
        }
        NodeList certlist = parent.getElementsByTagName("cert");
        if (certlist != null && certlist.getLength() > 0) {
            String certstr = certlist.item(0).getTextContent();
            ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decode((String)certstr));
            SM2Certificate smcert = null;
            try {
                smcert = new SM2Certificate((InputStream)bis);
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return smcert;
        }
        return null;
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (documentBuilder == null) {
            try {
                documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
        }
        return documentBuilder;
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new InfosecProvider());
        DomUtil du = new DomUtil("d:\\keystore.xml");
        FileInputStream fis = new FileInputStream("D:\\sm2cert\\sign_der.cer");
        SM2Certificate sm = new SM2Certificate((InputStream)fis);
        du.save(sm, "sign");
    }
}

