/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.AdminConfig;
import cn.com.infosec.netsign.frame.config.DownloadCRLConfig;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.KeyStoreConfig;
import cn.com.infosec.netsign.frame.config.ProcessorPolicyConfig;
import cn.com.infosec.netsign.frame.config.ResourcesConfig;
import cn.com.infosec.netsign.frame.config.ServiceConfig;
import cn.com.infosec.netsign.frame.config.TrustConfig;
import cn.com.infosec.netsign.frame.config.WeekAlgConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.synfwimpl.config.SynConfigLoader;
import java.io.File;
import java.util.HashMap;

public class ConfigManager {
    private static AdminConfig admin;
    private static ServiceConfig service;
    private static HashMap services;
    private static DownloadCRLConfig dcConfig;
    private static HashMap dcServices;
    private static KeyStoreConfig keyStore;
    private static HashMap keys;
    private static TrustConfig trustConfig;
    private static HashMap trustFields;
    private static boolean parsed;
    private static ResourcesConfig rsConfig;
    private static ProcessorPolicyConfig ppConfig;
    private static String configPath;

    public static ProcessorPolicyConfig getPpConfig() {
        return ppConfig;
    }

    public static void setPpConfig(ProcessorPolicyConfig ppConfig) {
        ConfigManager.ppConfig = ppConfig;
    }

    public static ResourcesConfig getResourcesConfig() {
        return rsConfig;
    }

    public static AdminConfig getAdmin() {
        return admin;
    }

    public static void setAdmin(AdminConfig admin) {
        ConfigManager.admin = admin;
    }

    public static DownloadCRLConfig getDcConfig() {
        return dcConfig;
    }

    public static void setDcConfig(DownloadCRLConfig dcConfig) {
        ConfigManager.dcConfig = dcConfig;
    }

    public static HashMap getDcServices() {
        return dcServices;
    }

    public static void setDcServices(HashMap dcServices) {
        ConfigManager.dcServices = dcServices;
    }

    public static HashMap getKeys() {
        return keys;
    }

    public static void setKeys(HashMap keys) {
        ConfigManager.keys = keys;
    }

    public static KeyStoreConfig getKeyStore() {
        return keyStore;
    }

    public static void setKeyStore(KeyStoreConfig keyStore) {
        ConfigManager.keyStore = keyStore;
    }

    public static boolean isParsed() {
        return parsed;
    }

    public static void setParsed(boolean parsed) {
        ConfigManager.parsed = parsed;
    }

    public static ServiceConfig getService() {
        return service;
    }

    public static void setService(ServiceConfig service) {
        ConfigManager.service = service;
    }

    public static HashMap getServices() {
        return services;
    }

    public static void setServices(HashMap services) {
        ConfigManager.services = services;
    }

    public static TrustConfig getTrustConfig() {
        return trustConfig;
    }

    public static void setTrustConfig(TrustConfig trustConfig) {
        ConfigManager.trustConfig = trustConfig;
    }

    public static HashMap getTrustFields() {
        return trustFields;
    }

    public static void setTrustFields(HashMap trustFields) {
        ConfigManager.trustFields = trustFields;
    }

    public static synchronized void reload(String configDir) {
        ConsoleLogger.logString("reload configs");
        parsed = false;
        ConfigManager.load(configDir);
    }

    public static synchronized void load(String configDir) {
        if (!parsed) {
            configPath = configDir;
            System.out.println("Load extension config...");
            ExtendedConfig.load(ConfigManager.getConfigFile(configDir, "extension.properties"));
            System.out.println("Load admin config...");
            admin = AdminConfig.parse(ConfigManager.getConfigFile(configDir, "nsadmin.xml"));
            System.out.println("Load downloadcrl config...");
            dcConfig = DownloadCRLConfig.parse(ConfigManager.getConfigFile(configDir, "downloadcrl.xml"));
            dcServices = dcConfig.getServices();
            System.out.println("Load trustfield config...");
            trustConfig = TrustConfig.parse(ConfigManager.getConfigFile(configDir, "trustfield.xml"));
            trustFields = trustConfig.getTrustFields();
            System.out.println("Load keystore config...");
            keyStore = KeyStoreConfig.parse(ConfigManager.getConfigFile(configDir, "keystore.xml"));
            keys = keyStore.getKeyList();
            System.out.println("Load service config...");
            service = ServiceConfig.parse(ConfigManager.getConfigFile(configDir, "service.xml"));
            services = service.getServices();
            System.out.println("Load Resources config...");
            rsConfig = ResourcesConfig.parse(ConfigManager.getConfigFile(configDir, "resources.xml"));
            System.out.println("Load ProcessorPolicy config...");
            ppConfig = ProcessorPolicyConfig.parse(ConfigManager.getConfigFile(configDir, "/processorpolicy.conf"));
            System.out.println("Load syn config...");
            SynConfigLoader.load((String)ConfigManager.getConfigFile(configDir, "nssyn.xml"));
            System.out.println("Load week algorithm config...");
            WeekAlgConfig.parse(ConfigManager.getConfigFile(configDir, "weekalg.xml"));
            parsed = true;
        }
    }

    private static String getConfigFile(String filePath, String fileName) {
        String cf = String.valueOf(filePath) + "/" + fileName;
        File f = new File(cf);
        if (f.exists()) {
            return cf;
        }
        return "config/" + fileName;
    }

    public static void main(String[] args) {
    }
}

