/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.AdminConfig;
import cn.com.infosec.netsign.frame.config.DownloadCRLConfig;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.KeyStoreConfig;
import cn.com.infosec.netsign.frame.config.ServiceConfig;
import cn.com.infosec.netsign.frame.config.TrustConfig;
import java.util.HashMap;

public class ConfigFactory {
    private static AdminConfig admin;
    private static ServiceConfig service;
    private static HashMap services;
    private static DownloadCRLConfig dcConfig;
    private static HashMap dcServices;
    private static KeyStoreConfig keyStore;
    private static HashMap keys;
    private static TrustConfig trustConfig;
    private static HashMap trustFields;
    private static boolean parsed;

    public static AdminConfig getAdmin() {
        return admin;
    }

    public static void setAdmin(AdminConfig admin) {
        ConfigFactory.admin = admin;
    }

    public static DownloadCRLConfig getDcConfig() {
        return dcConfig;
    }

    public static void setDcConfig(DownloadCRLConfig dcConfig) {
        ConfigFactory.dcConfig = dcConfig;
    }

    public static HashMap getDcServices() {
        return dcServices;
    }

    public static void setDcServices(HashMap dcServices) {
        ConfigFactory.dcServices = dcServices;
    }

    public static HashMap getKeys() {
        return keys;
    }

    public static void setKeys(HashMap keys) {
        ConfigFactory.keys = keys;
    }

    public static KeyStoreConfig getKeyStore() {
        return keyStore;
    }

    public static void setKeyStore(KeyStoreConfig keyStore) {
        ConfigFactory.keyStore = keyStore;
    }

    public static boolean isParsed() {
        return parsed;
    }

    public static void setParsed(boolean parsed) {
        ConfigFactory.parsed = parsed;
    }

    public static ServiceConfig getService() {
        return service;
    }

    public static void setService(ServiceConfig service) {
        ConfigFactory.service = service;
    }

    public static HashMap getServices() {
        return services;
    }

    public static void setServices(HashMap services) {
        ConfigFactory.services = services;
    }

    public static TrustConfig getTrustConfig() {
        return trustConfig;
    }

    public static void setTrustConfig(TrustConfig trustConfig) {
        ConfigFactory.trustConfig = trustConfig;
    }

    public static HashMap getTrustFields() {
        return trustFields;
    }

    public static void setTrustFields(HashMap trustFields) {
        ConfigFactory.trustFields = trustFields;
    }

    public static synchronized void load(String configDir) {
        if (!parsed) {
            System.out.println("Load extension config...");
            ExtendedConfig.load(String.valueOf(configDir) + "/extension.properties");
            System.out.println("Load admin config...");
            admin = AdminConfig.parse(String.valueOf(configDir) + "/nsadmin.xml");
            System.out.println("Load downloadcrl config...");
            dcConfig = DownloadCRLConfig.parse(String.valueOf(configDir) + "/downloadcrl.xml");
            dcServices = dcConfig.getServices();
            System.out.println("Load trustfield config...");
            trustConfig = TrustConfig.parse(String.valueOf(configDir) + "/trustfield.xml");
            trustFields = trustConfig.getTrustFields();
            System.out.println("Load keystore config...");
            keyStore = KeyStoreConfig.parse(String.valueOf(configDir) + "/keystore.xml");
            keys = keyStore.getKeyList();
            System.out.println("Load service config...");
            service = ServiceConfig.parse(String.valueOf(configDir) + "/service.xml");
            services = service.getServices();
            parsed = true;
        }
    }

    public static void main(String[] args) {
    }
}

