/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.frame.config;

import cn.com.infosec.netsign.frame.config.Config;
import cn.com.infosec.netsign.frame.util.ConfigUtil;
import java.io.Serializable;
import org.w3c.dom.Element;

public class CRLConfig
implements Config,
Serializable,
Cloneable {
    private String crlDir = "crl";
    private int crlDownloadInterval = 0x6DDD00;
    private boolean useCrldp = false;
    public static final String PASS = "pass";
    public static final String NO_PASS = "no-pass";
    private String onNoCrldp = "pass";
    private boolean checkValidity = false;

    public static CRLConfig parse(Element e) {
        if (e == null) {
            return null;
        }
        CRLConfig c = new CRLConfig();
        c.crlDir = ConfigUtil.getNodeText(e, "crl-dir", "crl");
        if (c.crlDir == null) {
            return null;
        }
        c.crlDownloadInterval = ConfigUtil.getNodeInt(e, "crl-download-interval", 7200) * 1000;
        c.useCrldp = ConfigUtil.getNodeBoolean(e, "use-crldp", true);
        c.onNoCrldp = ConfigUtil.getNodeText(e, "on-no-crldp", PASS);
        c.checkValidity = ConfigUtil.getNodeBoolean(e, "check-validity", false);
        return c;
    }

    public String toXML() {
        StringBuffer buf = new StringBuffer();
        buf.append("\t\t<crl-config>\n");
        buf.append("\t\t\t\t<crl-dir>").append(this.crlDir).append("</crl-dir>\n");
        buf.append("\t\t\t\t<!--\u66f4\u65b0crl\u65f6\u95f4\uff0c\u79d2\u4e3a\u5355\u4f4d-->\n");
        buf.append("\t\t\t\t<crl-download-interval>").append(this.crlDownloadInterval / 1000).append("</crl-download-interval>\n");
        buf.append("\t\t\t\t<!--\u662f\u5426\u6309\u53d1\u5e03\u70b9\u8ba4\u8bc1-->\n");
        buf.append("\t\t\t\t<use-crldp>").append(String.valueOf(this.useCrldp)).append("</use-crldp>\n");
        buf.append("\t\t\t\t<!--\u5728\u53d1\u5e03\u70b9\u4e0a\u6ca1\u6709CRL\u6587\u4ef6\u65f6\u662f\u5426\u901a\u8fc7\u9a8c\u8bc1\uff0cno-pass\u3001pass-->\n");
        buf.append("\t\t\t\t<on-no-crldp>").append(this.onNoCrldp).append("</on-no-crldp>\n");
        buf.append("\t\t\t\t<!--\u662f\u5426\u68c0\u67e5crl\u7684\u8fc7\u671f\u65f6\u95f4-->\n");
        buf.append("\t\t\t\t<check-validity>").append(String.valueOf(this.checkValidity)).append("</check-validity>\n");
        buf.append("\t\t</crl-config>\n");
        return buf.toString();
    }

    public boolean getCheckValidity() {
        return this.checkValidity;
    }

    public void setCheckValidity(boolean checkValidity) {
        this.checkValidity = checkValidity;
    }

    public String getCrlDir() {
        return this.crlDir;
    }

    public void setCrlDir(String crlDir) {
        this.crlDir = crlDir;
    }

    public int getCrlDownloadInterval() {
        return this.crlDownloadInterval;
    }

    public void setCrlDownloadInterval(int crlDownloadInterval) {
        this.crlDownloadInterval = crlDownloadInterval;
    }

    public String getOnNoCrldp() {
        return this.onNoCrldp;
    }

    public void setOnNoCrldp(String onNoCrldp) {
        this.onNoCrldp = onNoCrldp;
    }

    public boolean isUseCrldp() {
        return this.useCrldp;
    }

    public void setUseCrldp(boolean useCrldp) {
        this.useCrldp = useCrldp;
    }

    public Object clone() throws CloneNotSupportedException {
        CRLConfig crl = new CRLConfig();
        crl.setCheckValidity(this.checkValidity);
        crl.setCrlDir(this.crlDir);
        crl.setCrlDownloadInterval(this.crlDownloadInterval);
        crl.setOnNoCrldp(this.onNoCrldp);
        crl.setUseCrldp(this.useCrldp);
        return crl;
    }
}

