/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.frame.util.PackageUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class ProcessManager {
    private static final String PROCESSOR_PRE = "cn.com.infosec.netsign.base.processors";
    private static HashMap adminProcs = new HashMap();
    private static HashMap serviceProcs = new HashMap();

    public static void initProcessores() throws ProcessorException {
        List processorNames = PackageUtil.getClassInPackage((String)PROCESSOR_PRE);
        int i = 0;
        int size = processorNames.size();
        while (i < size) {
            try {
                String className = (String)processorNames.get(i);
                Class<?> c = Class.forName(className);
                Type[] ts = c.getGenericInterfaces();
                if (ts != null && ts.length > 0) {
                    if (ts[0].toString().indexOf("cn.com.infosec.netsign.base.Processor") > -1) {
                        adminProcs.put(c.getSimpleName(), c.newInstance());
                        System.out.println("AdminProcessor:" + c.getSimpleName());
                    } else if (ts[0].toString().indexOf(" cn.com.infosec.netsign.isfwimpl.NetSignProcessor") > -1) {
                        serviceProcs.put(c.getSimpleName(), c.newInstance());
                        System.out.println("ServiceProcessor:" + c.getSimpleName());
                    }
                }
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
            ++i;
        }
    }

    public static Processor getAdminProcessor(String processor) throws ProcessorException {
        try {
            return (Processor)adminProcs.get(processor);
        }
        catch (Exception ex) {
            throw new ProcessorException(ex);
        }
    }

    public static NetSignProcessor getServerProcessor(String processor) throws ProcessorException {
        try {
            return (NetSignProcessor)serviceProcs.get(processor);
        }
        catch (Exception ex) {
            throw new ProcessorException(ex);
        }
    }

    public static Set getServerProcessorNames() {
        return serviceProcs.keySet();
    }
}

