/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.NetSignServer;
import cn.com.infosec.netsign.frame.config.AdminConfig;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.frame.config.ServiceConfig;
import cn.com.infosec.netsign.logger.AbstractLogger;
import cn.com.infosec.netsign.logger.AccessLogger;
import cn.com.infosec.netsign.logger.DebugLogger;
import cn.com.infosec.netsign.logger.LoggerException;
import cn.com.infosec.netsign.logger.LoggerRes;
import cn.com.infosec.netsign.logger.SystemLogger;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class LogManager {
    private static Map loggers = new HashMap();
    private static String path = null;

    private static void configRemoteLogger(String name, String ip, String device, LoggerRes logRes) {
        if (ip != null && device != null) {
            logRes.setUseRemoteLogger();
            logRes.setRemoteLoggerIP(ip);
            logRes.setAccessLogFacility(device);
            logRes.setDebugLogFacility(device);
        }
    }

    private static void configLocalLogger(String file, String fileSize, int bakIndex, String name, LoggerRes logRes) throws LoggerException {
        logRes.setLogFile(file);
        logRes.setMaxFileSize(fileSize);
        logRes.setMaxBackupIndex(bakIndex);
        logRes.setLoggerName(name);
    }

    private static void configHeaderWithIP(LoggerRes logRes) {
        String linesp = System.getProperty("line.separator");
        StringBuffer header = new StringBuffer();
        header.append("#Version:" + NetSignServer.getVersion() + linesp);
        header.append("#Fields:Date Time ServerID ClientIP cs-method Result" + linesp);
        logRes.setHeader(header.toString());
    }

    private static AbstractLogger createLoggerWithIP(String name, LoggerRes logRes) throws LoggerException {
        AccessLogger logger = null;
        if (name.equalsIgnoreCase("access")) {
            LogManager.configHeaderWithIP(logRes);
            logger = new AccessLogger(logRes);
        } else if (name.equalsIgnoreCase("error")) {
            logger = new DebugLogger(logRes);
        } else if (name.equalsIgnoreCase("system")) {
            logger = new SystemLogger(logRes);
        }
        return logger;
    }

    private static String initLogPath(String name) throws LoggerException {
        String logPath = name;
        File f = new File(logPath);
        if (!f.exists()) {
            f.mkdirs();
        } else if (f.isFile()) {
            throw new LoggerException("Invalid Log Path: " + logPath);
        }
        return logPath;
    }

    public static void register(AdminConfig config) throws LoggerException {
        LoggerRes logRes = new LoggerRes();
        String logPath = LogManager.initLogPath("log/Admin");
        LogManager.configLocalLogger(String.valueOf(logPath) + "/" + config.getLogFile(), config.getSize(), config.getMaxFiles(), "system", logRes);
        AbstractLogger logger = LogManager.createLoggerWithIP("system", logRes);
        loggers.put("access", logger);
        loggers.put("error", logger);
        loggers.put("system", logger);
        LogManager.getSystemLogger().Log("System Logger initialized");
    }

    public static void register(ServiceConfig config, String serviceName) throws LoggerException {
        String logPath = LogManager.initLogPath("log/" + serviceName);
        LoggerRes logRes = new LoggerRes();
        Service service = config.getService(serviceName);
        LogManager.configRemoteLogger("access", service.getRemoteLogIP(), service.getRemoteLogDevice(), logRes);
        LogManager.configLocalLogger(String.valueOf(logPath) + "/" + config.getAccessLogFile(), config.getAccessLogFileSize(), config.getAccessLogRollback(), String.valueOf(serviceName) + "-" + "access", logRes);
        AbstractLogger logger = LogManager.createLoggerWithIP("access", logRes);
        loggers.put(String.valueOf(serviceName) + ":" + "access", logger);
        logRes = new LoggerRes();
        LogManager.configRemoteLogger("error", service.getRemoteLogIP(), service.getRemoteLogDevice(), logRes);
        LogManager.configLocalLogger(String.valueOf(logPath) + "/" + config.getErrorLogFile(), config.getErrorLogFileSize(), config.getErrorLogRollback(), String.valueOf(serviceName) + "-" + "error", logRes);
        logger = LogManager.createLoggerWithIP("error", logRes);
        loggers.put(String.valueOf(serviceName) + ":" + "error", logger);
    }

    public static AbstractLogger getSystemLogger() {
        return (AbstractLogger)loggers.get("system");
    }

    public static AbstractLogger getAccessLogger() {
        return (AbstractLogger)loggers.get("access");
    }

    public static AbstractLogger getDebugLogger() {
        return (AbstractLogger)loggers.get("error");
    }

    public static AbstractLogger getAccessLogger(String name) {
        return (AbstractLogger)loggers.get(String.valueOf(name) + ":" + "access");
    }

    public static AbstractLogger getErrorLogger(String name) {
        return (AbstractLogger)loggers.get(String.valueOf(name) + ":" + "error");
    }

    public static void removeLoggers(String name) {
        loggers.remove(String.valueOf(name) + ":" + "access");
        loggers.remove(String.valueOf(name) + ":" + "error");
    }
}

