/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.base.ExternServer;
import cn.com.infosec.netsign.base.ExternServerException;
import cn.com.infosec.netsign.base.channels.DownloadCrlServerException;
import cn.com.infosec.netsign.base.processors.util.ShellUtil;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.DownloadCRLConfig;
import cn.com.infosec.netsign.frame.config.DownloadCRLService;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.IdentifyException;
import cn.com.infosec.netsign.manager.IdentifyManager;
import cn.com.infosec.netsign.manager.LogManager;
import java.util.HashMap;
import java.util.Map;

public class DCServerManager {
    private static Map crlServers = new HashMap();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServer(DownloadCRLService config) throws DownloadCrlServerException {
        try {
            IdentifyManager.registerDCName(config.getName());
        }
        catch (IdentifyException idEx) {
            throw new DownloadCrlServerException(idEx);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            DownloadCRLConfig dcConfig = ConfigManager.getDcConfig();
            dcConfig.addService(config);
            try {
                DCServerManager.startExternServer(config);
            }
            catch (DownloadCrlServerException dcex) {
                crlServers.put(config.getName(), "stopped");
                throw dcex;
            }
            crlServers.put(config.getName(), "running");
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    private static void startExternServer(DownloadCRLService config) throws DownloadCrlServerException {
        int checktime = 60000;
        String checkfile = "RunFlag";
        String servername = "DownloadCRL";
        String servepath = ConfigManager.getDcConfig().getDchome();
        int interval = 100;
        try {
            ExternServer exserver = new ExternServer(servername, servepath, checktime, checkfile, interval);
            exserver.StartService(config.getConfigFile());
        }
        catch (ExternServerException ex) {
            throw new DownloadCrlServerException(ex);
        }
    }

    private static void stopExternServer(DownloadCRLService config) throws DownloadCrlServerException {
        int checktime = 60000;
        String checkfile = "RunFlag";
        String servername = "DownloadCRL";
        String servepath = ConfigManager.getDcConfig().getDchome();
        int interval = 100;
        try {
            ExternServer exserver = new ExternServer(servername, servepath, checktime, checkfile, interval);
            exserver.StopService(config.getConfigFile());
        }
        catch (ExternServerException ex) {
            throw new DownloadCrlServerException(ex);
        }
    }

    public static Map getAllServer() {
        return crlServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyServer(DownloadCRLService config) throws DownloadCrlServerException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            String status = (String)crlServers.get(config.getName());
            if (status == null) {
                throw new DownloadCrlServerException("Server " + config.getName() + "not exist");
            }
            HashMap dcServices = ConfigManager.getDcServices();
            dcServices.remove(config.getName());
            dcServices.put(config.getName(), config);
            if (status.equals("running")) {
                DCServerManager.stopExternServer(config);
                try {
                    DCServerManager.startExternServer(config);
                }
                catch (DownloadCrlServerException dcex) {
                    crlServers.put(config.getName(), "stopped");
                    throw dcex;
                }
            }
            try {
                DCServerManager.startExternServer(config);
            }
            catch (DownloadCrlServerException dcex) {
                crlServers.put(config.getName(), "stopped");
                throw dcex;
            }
            crlServers.put(config.getName(), "running");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServers() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            DownloadCRLConfig config = ConfigManager.getDcConfig();
            if (config.getServices() == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            DownloadCRLService[] services = config.getAllService();
            int i = 0;
            int length = services.length;
            while (i < length) {
                DownloadCRLService service = services[i];
                try {
                    DCServerManager.startExternServer(service);
                    crlServers.put(service.getName(), "running");
                }
                catch (Throwable ex) {
                    crlServers.put(service.getName(), "stopped");
                    LogManager.getSystemLogger().Log("Start DCServer Failed " + ex.getMessage());
                }
                ++i;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterServers() throws DownloadCrlServerException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Process proc = null;
            try {
                DownloadCRLConfig config = ConfigManager.getDcConfig();
                if (config.getServices() == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                String cmd = String.valueOf(config.getDchome()) + "/Shutdown.sh";
                ShellUtil.execAndRead(cmd, null, config.getDchome());
                cmd = String.valueOf(config.getDchome()) + "/StartDownloadCRL.sh";
                proc = ShellUtil.exec(cmd, null, config.getDchome());
            }
            finally {
                if (proc != null) {
                    proc.destroy();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterServersBak() throws DownloadCrlServerException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            DownloadCRLConfig config = ConfigManager.getDcConfig();
            if (config.getServices() == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            DownloadCRLService[] services = config.getAllService();
            int i = 0;
            int length = services.length;
            while (i < length) {
                DownloadCRLService service = services[i];
                String status = (String)crlServers.get(service.getName());
                if (status.equals("running")) {
                    DCServerManager.stopExternServer(service);
                }
                ++i;
            }
            crlServers.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void startupServer(String name) throws DownloadCrlServerException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            String status = (String)crlServers.get(name);
            if (status == null) {
                throw new DownloadCrlServerException("Server " + name + " not exist");
            }
            if (status == "running") {
                throw new DownloadCrlServerException("Server is running");
            }
            DownloadCRLService config = ConfigManager.getDcConfig().getService(name);
            DCServerManager.startExternServer(config);
            crlServers.put(name, "running");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stopServer(String name) throws DownloadCrlServerException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            String status = (String)crlServers.get(name);
            if (status == null) {
                throw new DownloadCrlServerException("Server not exist");
            }
            if (status == "stopped") {
                throw new DownloadCrlServerException("Server not running");
            }
            DownloadCRLService config = ConfigManager.getDcConfig().getService(name);
            DCServerManager.stopExternServer(config);
            crlServers.put(name, "stopped");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServer(String name) throws DownloadCrlServerException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.com.infosec.netsign.manager.DCServerManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            ConsoleLogger.logString((String)("remove downloadcrl " + name));
            String status = (String)crlServers.get(name);
            if (status == null) {
                throw new DownloadCrlServerException("Server " + name + " not exist");
            }
            DownloadCRLService config = ConfigManager.getDcConfig().getService(name);
            if (status.equals("running")) {
                DCServerManager.stopExternServer(config);
            }
            crlServers.remove(name);
            try {
                IdentifyManager.removeDCName(name);
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
            ConfigManager.getDcConfig().remove(name);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isServerStart(String name) throws DownloadCrlServerException {
        String status = (String)crlServers.get(name);
        if (status == null) {
            throw new DownloadCrlServerException("Server not exist");
        }
        return status.equals("running");
    }
}

