/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.manager;

import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.HardCryptoImpl;
import cn.com.infosec.netsign.frame.config.AdminConfig;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class CryptoManager {
    private static HardCryptoImpl hardCryptoImpl = null;
    private static List keyLabels = new ArrayList();

    private static void initLabels() throws CryptoException {
        String[] labels = null;
        if (labels != null) {
            // empty if block
        }
    }

    public static void initialize() throws CryptoException {
        AdminConfig config = ConfigManager.getAdmin();
        if (ExtendedConfig.getAlgMode().equals("hard")) {
            Properties p = new Properties();
            p.setProperty("libname", config.getLib());
            p.setProperty("tokenname", config.getToken());
            p.setProperty("tokenpassowrd", config.getPwd());
            hardCryptoImpl = new HardCryptoImpl(p);
            NetSignImpl.setHardCryptoHandler(hardCryptoImpl);
            CryptoManager.initLabels();
            AlgorithmUtil.initialize((String)"config/algorithm.xml", (String)"hard");
        } else {
            AlgorithmUtil.initialize((String)"config/algorithm.xml", (String)"soft");
        }
    }

    public static void descroy() throws CryptoException {
        if (hardCryptoImpl != null) {
            hardCryptoImpl.DestoryICK();
        }
        hardCryptoImpl = null;
    }

    public static HardCryptoImpl getHardCryptoImpl() {
        return hardCryptoImpl;
    }

    public static synchronized String generatePKCS10CSR(String subject, int keySize, String label) throws CryptoException {
        String result = hardCryptoImpl.generatePKCS10CSR(subject, keySize, label.getBytes());
        keyLabels.add(label);
        return result;
    }

    public static String[] getKeyLabels() {
        return keyLabels.toArray(new String[keyLabels.size()]);
    }
}

