/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.listeners;

import cn.com.infosec.isfw2.impl.ProcessorManager;
import cn.com.infosec.isfw2.logger.Logger;
import cn.com.infosec.isfw2.sfw.IOFilter;
import cn.com.infosec.isfw2.sfw.IOFilterChain;
import cn.com.infosec.isfw2.sfw.IOService;
import cn.com.infosec.isfw2.sfw.ProtocolHandler;
import cn.com.infosec.isfw2.sfw.ServiceManager;
import cn.com.infosec.netsign.base.channels.BasicChannel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.isfwimpl.IAFWLogger;
import cn.com.infosec.netsign.isfwimpl.NetSignIOFilter;
import cn.com.infosec.netsign.isfwimpl.NetSignProtocolHandler;
import cn.com.infosec.netsign.jmx.MBeanManager;
import cn.com.infosec.netsign.listeners.AbstractListener;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.ChannelManager;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.manager.ProcessManager;
import cn.com.infosec.netsign.pools.HandlerThreadPool;
import java.net.ServerSocket;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public class ServerListener
extends AbstractListener {
    private BasicChannel channel;
    private String id;
    private HandlerThreadPool pool = null;
    private ServerSocket serverSocket = null;
    private IOService server = null;
    private ProtocolHandler handler;
    private ProcessorManager pm;
    private static Object startLock = new Object();

    private String getIP() {
        String ip = ((Service)ConfigManager.getServices().get(this.id)).getIp();
        return ip;
    }

    private int getPort() {
        return ((Service)ConfigManager.getServices().get(this.id)).getPort();
    }

    private int getTimeout() {
        return ((Service)ConfigManager.getServices().get(this.id)).getTimeout();
    }

    private int getBacklog() {
        return ExtendedConfig.getBackLog();
    }

    public int countCurrentThreads() {
        if (this.server != null) {
            if (this.server.getExecutor() != null) {
                return this.server.getExecutor().getPoolSize();
            }
            return 0;
        }
        return 0;
    }

    public int countCurrentThreadsbak() {
        return this.pool.getActiveCount();
    }

    public ServerListener(String name, BasicChannel channel) throws ChannelException {
        this.id = name;
        this.channel = channel;
        try {
            ConsoleLogger.logString((String)(String.valueOf(this.getIP()) + ":" + this.getPort()));
            this.server = new IOService(this.getIP(), this.getPort(), this.getBacklog(), ExtendedConfig.getMaxReadThread());
            this.handler = new NetSignProtocolHandler(this.id);
            this.server.setProtocolHandler(this.handler);
            this.server.selectorTimeout = this.getTimeout();
            this.server.setSessionMonitorOpen(ExtendedConfig.isSessionMonitorOpen());
            this.server.setMaxSessionSize(ExtendedConfig.getMaxSessionPoolSize());
            if (!ExtendedConfig.getJmxMonitorLevel().equals("none")) {
                this.server.setWithJMX(true);
            }
            Set processors = ProcessManager.getServerProcessorNames();
            this.pm = new ProcessorManager();
            String[] pNames = new String[]{};
            pNames = processors.toArray(pNames);
            int i = 0;
            int length = pNames.length;
            while (i < length) {
                this.pm.regist(pNames[i], "cn.com.infosec.netsign.base.processors." + pNames[i]);
                ++i;
            }
            Thread.sleep(100L);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            LogManager.getSystemLogger().Log(String.valueOf(this.id) + " Create Listener: " + e.getMessage());
            throw new ChannelException(e);
        }
    }

    public void reload(String name, BasicChannel channel) throws ChannelException {
        this.channel = channel;
        try {
            ServiceManager.servs.remove(this.server);
            this.server.stop();
            this.server.setBacklog(this.getBacklog());
            this.server.setIp(this.getIP());
            this.server.setPort(this.getPort());
            this.server.selectorTimeout = this.getTimeout();
            this.server.setSessionMonitorOpen(ExtendedConfig.isSessionMonitorOpen());
            this.server.setMaxSessionSize(ExtendedConfig.getMaxSessionPoolSize());
            Thread.sleep(100L);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            LogManager.getSystemLogger().Log(String.valueOf(this.id) + " Create Listener: " + e.getMessage());
            throw new ChannelException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ServerChannel schannel = ChannelManager.getServerChannel(this.id);
            IOFilterChain chain = new IOFilterChain();
            NetSignIOFilter lf = new NetSignIOFilter(this.handler, this.pm, schannel);
            chain.addFilter((IOFilter)lf);
            this.server.setChain(chain);
            if (this.pool == null) {
                this.pool = new HandlerThreadPool();
                this.server.setExecutor((ThreadPoolExecutor)this.pool);
            }
            IAFWLogger logger = new IAFWLogger(schannel.getAccessLogger());
            this.server.setLogger((Logger)logger);
            Object object = startLock;
            synchronized (object) {
                ServiceManager.servs.add(this.server);
                ServiceManager.start();
                while (!this.server.isRunning()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            MBeanManager.registThreadPoolStatus(this.server.getExecutor(), this.id);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            try {
                this.channel.stopChannel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new RuntimeException(e);
        }
    }

    public void shutdown() throws ChannelException {
        try {
            if (this.server != null) {
                ServiceManager.servs.remove(this.server);
                this.server.stop();
                MBeanManager.unregistThreadPoolStatusMBean(this.id);
                if (this.pool != null) {
                    this.pool.shutdownNow();
                }
                this.pool = null;
            }
        }
        catch (Exception ex) {
            LogManager.getSystemLogger().Log(String.valueOf(this.id) + " Shutdown Listener: " + ex.getMessage());
            throw new ChannelException(ex);
        }
    }

    public void shutdownbak() throws ChannelException {
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
                System.out.println("Server " + this.id + " socket closed");
            }
            if (this.pool != null) {
                this.pool.shutdownNow();
                System.out.println("Server " + this.id + " thread pool closed");
            }
            Thread.sleep(2000L);
        }
        catch (Exception ex) {
            LogManager.getSystemLogger().Log(String.valueOf(this.id) + " Shutdown Listener: " + ex.getMessage());
            throw new ChannelException(ex);
        }
    }
}

