/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.listeners;

import cn.com.infosec.netsign.base.BarCodeParameters;
import cn.com.infosec.netsign.base.channels.BasicChannel;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.config.SystemInfoImpl;
import cn.com.infosec.netsign.communication.ObjectCommunicator;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.listeners.AbstractListener;
import cn.com.infosec.netsign.listeners.AdminConnectionHandler;
import cn.com.infosec.netsign.manager.LogManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class AdminServerListener
extends AbstractListener {
    private static AdminConnectionHandler acHandler = new AdminConnectionHandler();
    private static ObjectCommunicator oc = new ObjectCommunicator();
    private static SystemInfoImpl sii = new SystemInfoImpl(0);
    private static BarCodeParameters bcp = new BarCodeParameters();
    private ServerSocket serverSocket = null;

    private String getIP() {
        return ConfigManager.getAdmin().getIp();
    }

    private int getPort() {
        return ConfigManager.getAdmin().getPort();
    }

    public int countCurrentThreads() {
        return 0;
    }

    private int getTimeout() {
        return ConfigManager.getAdmin().getTimeout();
    }

    public AdminServerListener() throws ChannelException {
        try {
            if (this.getIP().equals("*") || this.getIP() == null) {
                this.serverSocket = new ServerSocket(this.getPort());
            } else {
                this.serverSocket = new ServerSocket();
                InetSocketAddress socketAddress = new InetSocketAddress(this.getPort());
                this.serverSocket.bind(socketAddress);
            }
        }
        catch (Exception e) {
            throw new ChannelException(e);
        }
    }

    public void run() {
        while (!Thread.interrupted()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ioEx) {
                if (ioEx.getMessage().equalsIgnoreCase("socket closed")) break;
                LogManager.getDebugLogger().Log("Admin AcceptConnection: " + ioEx.getMessage());
                LogManager.getAccessLogger().Log("Admin AcceptConnection error");
                continue;
            }
            try {
                socket.setSoTimeout(this.getTimeout());
            }
            catch (SocketException socketEx) {
                LogManager.getDebugLogger().Log("Admin ConfigSocket: " + socketEx.getMessage());
                LogManager.getAccessLogger().Log("Admin ConfigSocket error");
            }
            new Thread(new AdminConnectionHandler(socket)).start();
        }
    }

    public void shutdown() throws ChannelException {
        try {
            this.serverSocket.close();
        }
        catch (IOException ex) {
            throw new ChannelException(ex);
        }
    }

    public void reload(String name, BasicChannel channel) throws ChannelException {
    }
}

