/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.listeners;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.communication.ObjectCommunicator;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.manager.ProcessManager;
import java.io.IOException;
import java.net.Socket;

public class AdminConnectionHandler
implements Runnable {
    private Communicator comm;
    private String inetAddress;
    private String localAddress;

    public AdminConnectionHandler() {
    }

    private AdminMessage checkPolicy(AbstractMessage req) {
        return null;
    }

    private void send(AbstractMessage message) {
        try {
            this.comm.send(message);
        }
        catch (Throwable ioEx) {
            LogManager.getDebugLogger().Log("Admin SendMessage: " + ioEx.getMessage());
            LogManager.getAccessLogger().Log("Admin SendMessage failed");
        }
    }

    public AdminConnectionHandler(Socket socket) {
        this.comm = new ObjectCommunicator(socket);
        this.inetAddress = socket.getInetAddress().getHostAddress();
        this.localAddress = socket.getLocalAddress().getHostAddress();
    }

    public void run() {
        AbstractMessage message = null;
        int count = 0;
        while (count < 2) {
            AdminMessage errMsg;
            AdminMessage res;
            try {
                message = this.comm.recv();
                ++count;
            }
            catch (IOException ioEx) {
                if (count >= 1) break;
                LogManager.getDebugLogger().Log("Admin RecieveMessage: " + ioEx.getMessage());
                LogManager.getAccessLogger().Log("Admin RecieveMessage failed");
                break;
            }
            catch (ClassNotFoundException clsEx) {
                ConsoleLogger.logException((Throwable)clsEx);
                ++count;
                res = new AdminMessage();
                res.setType("response");
                res.setResult(-100000);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100000));
                LogManager.getDebugLogger().Log("Admin RecieveMessage: " + clsEx.getMessage());
                LogManager.getAccessLogger().Log("Admin RecieveMessage failed");
                this.send(res);
                continue;
            }
            catch (Throwable e) {
                ConsoleLogger.logException((Throwable)e);
                ++count;
                res = new AdminMessage();
                res.setType("response");
                res.setResult(-100004);
                res.setErrMsg(e.getMessage());
                LogManager.getDebugLogger().Log("Admin RecieveMessage: " + e.getMessage());
                LogManager.getAccessLogger().Log("Admin RecieveMessage failed");
                this.send(res);
                continue;
            }
            AdminMessage errorMsg = this.checkPolicy(message);
            if (errorMsg != null) {
                LogManager.getDebugLogger().Log("Admin CheckPolicy: " + errorMsg.getResult() + ", " + errorMsg.getErrMsg());
                LogManager.getAccessLogger().Log("Admin CheckPolicy failed");
                this.send(errorMsg);
                continue;
            }
            Processor processor = null;
            try {
                processor = ProcessManager.getAdminProcessor(message.getProcessor());
            }
            catch (Throwable procEx) {
                ConsoleLogger.logException((Throwable)procEx);
                errMsg = new AdminMessage();
                errMsg.setProcessor(message.getProcessor());
                errMsg.setType("response");
                errMsg.setResult(-100002);
                errMsg.setErrMsg(ErrorInfoRes.getErrorInfo(-100002));
                LogManager.getDebugLogger().Log("Admin GetProcessor: " + errMsg.getResult() + ", " + procEx.getMessage());
                LogManager.getAccessLogger().Log("Admin GetProcessor failed");
                this.send(errMsg);
                continue;
            }
            try {
                AbstractMessage absMsg = processor.process(message);
                this.send(absMsg);
            }
            catch (Throwable e) {
                ConsoleLogger.logException((Throwable)e);
                errMsg = new AdminMessage();
                errMsg.setProcessor(message.getProcessor());
                errMsg.setType("response");
                errMsg.setResult(-100004);
                errMsg.setErrMsg(e.getMessage());
                LogManager.getDebugLogger().Log("Admin Process: " + errMsg.getResult() + ", " + e.getMessage());
                LogManager.getAccessLogger().Log("Admin Process failed");
                this.send(errMsg);
            }
        }
        try {
            if (this.comm != null) {
                this.comm.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (message.getProcessor().equals("ShutdownSystemProcessor")) {
            LogManager.getAccessLogger().Log("Admin ShutdownSystem success");
            LogManager.getSystemLogger().Log("Admin ShutdownSystem success");
            System.out.println("System shutdown.");
            System.exit(0);
        }
    }
}

