/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.jmx;

import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.jmx.ServiceInfoCollector;
import cn.com.infosec.netsign.jmx.Task;
import cn.com.infosec.netsign.jmx.TaskCount;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;

public class TaskQueue
extends Observable {
    private ArrayList tasksOnLine = new ArrayList(this.queueMax);
    private ArrayList tasksOffLine = new ArrayList(this.queueMax);
    private int queueMax = 1000;
    private QueueWatcher watcher;
    private ServiceInfoCollector coll;
    private HashMap taskCounts = new HashMap();

    TaskQueue() {
        this.coll = new ServiceInfoCollector();
        this.coll.start();
        this.addObserver(this.coll);
        this.watcher = new QueueWatcher();
        this.watcher.start();
    }

    public HashMap getTaskCount() {
        return this.taskCounts;
    }

    public void renewCollector() {
        this.watcher.stop();
        this.coll.stop();
        this.coll = new ServiceInfoCollector();
        this.coll.start();
        this.deleteObservers();
        this.addObserver(this.coll);
        this.watcher.start();
    }

    public synchronized void addTask(Task t) {
        TaskCount tc = (TaskCount)this.taskCounts.get(t.getChannelID());
        if (tc == null) {
            tc = new TaskCount();
            this.taskCounts.put(t.getChannelID(), tc);
        }
        if (t.getErrorNum() > -1) {
            tc.addSuccess();
        } else {
            tc.addFailed();
            this.tasksOnLine.add(t);
        }
    }

    public ArrayList getTasks() {
        ArrayList tmp = this.tasksOnLine;
        this.tasksOnLine = this.tasksOffLine;
        this.tasksOffLine = new ArrayList(this.queueMax);
        return tmp;
    }

    public int size() {
        return this.tasksOnLine.size();
    }

    public static void main(String[] args) {
        TaskQueue tq = new TaskQueue();
        Task t = Task.getInstance("1", 1);
        tq.addTask(t);
        tq.addTask(t);
        System.out.println(tq.size());
        ArrayList list = tq.getTasks();
        System.out.println(list.size());
        System.out.println(tq.size());
        tq.addTask(t);
        tq.addTask(t);
        System.out.println(tq.size());
    }

    class QueueWatcher
    implements Runnable {
        private Thread t = null;
        private boolean isStop = false;

        QueueWatcher() {
        }

        public void run() {
            ConsoleLogger.logString((String)"QueueWatcher started");
            long last = 0L;
            while (!this.isStop) {
                long now = System.currentTimeMillis();
                if (TaskQueue.this.size() > TaskQueue.this.queueMax * 8 / 10) {
                    TaskQueue.this.setChanged();
                    TaskQueue.this.notifyObservers();
                    TaskQueue.this.clearChanged();
                } else if (now - last >= ExtendedConfig.getTaskQueueWatchInterval()) {
                    TaskQueue.this.setChanged();
                    TaskQueue.this.notifyObservers();
                    last = now;
                    TaskQueue.this.clearChanged();
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                }
            }
        }

        public void stop() {
            this.isStop = true;
            this.t = null;
        }

        public void start() {
            this.t = new Thread(this);
            this.t.setName("TaskQueue Watcher Thread");
            this.t.start();
        }
    }
}

