/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.jmx;

import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.communication.multiple.Byte2StringRotator;
import cn.com.infosec.netsign.communication.multiple.MultiCommunicator;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.jmx.MBeanManager;
import cn.com.infosec.netsign.jmx.MonitorUtil;
import cn.com.infosec.netsign.jmx.Task;
import cn.com.infosec.netsign.jmx.TaskCount;
import cn.com.infosec.netsign.jmx.TaskQueue;
import cn.com.infosec.netsign.jmx.mbeans.ServiceInfo;
import cn.com.infosec.netsign.jmx.mbeans.ServiceStat;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.ChannelManager;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class ServiceInfoCollector
implements Observer,
Runnable {
    private long lastCollect;
    private HashMap totalInfos;
    private HashMap minInfos;
    private HashMap totalInfosTmp;
    private HashMap lastInfos;
    private HashMap scg = ConfigManager.getServices();
    private Thread t;
    private boolean isStop = false;
    private Service[] scs;
    private static final int SERVICE_DOWN = -1;
    private static final int SERVICE_ERROR = -2;
    private static final int SERVICE_OK = 0;
    private Byte2StringRotator rotator;

    public void run() {
        try {
            Thread.sleep(10000L);
        }
        catch (Exception exception) {}
        while (!this.isStop) {
            this.scg = ConfigManager.getServices();
            if (this.scg == null) continue;
            this.scs = this.scg.values().toArray(new Service[0]);
            if (this.scs == null) continue;
            try {
                long beginTime = System.currentTimeMillis();
                int i = 0;
                int length = this.scs.length;
                while (i < length) {
                    ServiceInfo si;
                    ServerChannel channel = ChannelManager.getServerChannel(this.scs[i].getName());
                    if (channel != null && channel.IsStarted() && (si = MBeanManager.getServiceInfoMBean(this.scs[i].getName())) != null) {
                        si.setStatus(this.serviceStatus(this.scs[i]));
                        si.setReqCount(this.tcpCountStat(this.scs[i]));
                    }
                    ++i;
                }
                long interval = ExtendedConfig.getServiceInfoCollectInterval();
                long endTime = System.currentTimeMillis();
                interval = (interval -= endTime - beginTime) > 0L ? interval : 0L;
                try {
                    Thread.sleep(interval);
                }
                catch (Exception exception) {}
            }
            catch (Throwable t) {
                ConsoleLogger.logException((Throwable)t);
            }
        }
    }

    private String tcpCountStat(Service conf) {
        String shell = ExtendedConfig.getShellFile((String)"tcpcc");
        if (shell != null && !shell.equals("")) {
            String cmd = String.valueOf(shell) + " " + conf.getPort();
            String result = MonitorUtil.execute(cmd);
            return result;
        }
        return "0";
    }

    private String serviceStatus(Service conf) {
        int status = this.testServicePort(conf.getIp(), conf.getPort());
        switch (status) {
            case 0: {
                return "running";
            }
            case -1: {
                return "stop";
            }
            case -2: {
                return "error";
            }
        }
        return "";
    }

    private Socket createConnection(String ip, int port) {
        Socket s = null;
        try {
            if (ip == null || ip.equals("*")) {
                s = new Socket();
                s.connect(new InetSocketAddress("127.0.0.1", port), 10000);
            } else {
                s = new Socket();
                s.connect(new InetSocketAddress(ip, port), 10000);
            }
            s.setSoLinger(true, 0);
            s.setTcpNoDelay(true);
            s.setSoTimeout(60000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return s;
    }

    private int testServicePort(String ip, int port) {
        Socket s;
        NSMessage am = new NSMessage();
        am.setType("REQUEST");
        am.setProcessor("HeartbeatProcessor");
        am.setCommunicateMode(1);
        am.setZipMode(false);
        if (ip == null || ip.equals("*")) {
            ip = "127.0.0.1";
        }
        if ((s = this.createConnection(ip, port)) != null) {
            try {
                MultiCommunicator comm = new MultiCommunicator(s);
                comm.send(am);
                comm.recv();
                return 0;
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
                String msg = e.getMessage();
                if (msg != null && msg.toLowerCase().indexOf("timeout") > -1) {
                    return -2;
                }
                return -1;
            }
            finally {
                try {
                    s.close();
                }
                catch (Exception exception) {}
            }
        }
        return -1;
    }

    public void start() {
        this.t = new Thread(this);
        this.t.start();
    }

    public void stop() {
        this.isStop = true;
        this.t = null;
    }

    public ServiceInfoCollector() {
        this.totalInfos = new HashMap();
        this.minInfos = new HashMap();
        this.totalInfosTmp = new HashMap();
        this.lastInfos = new HashMap();
        if (this.scg != null && this.scg.size() > 0) {
            this.scs = this.scg.values().toArray(new Service[0]);
            if (this.scs != null) {
                int i = 0;
                int length = this.scs.length;
                while (i < length) {
                    Service sc = this.scs[i];
                    this.totalInfos.put(sc.getName(), MBeanManager.createServiceStat(sc.getName()));
                    this.minInfos.put(sc.getName(), MBeanManager.createServiceStat(sc.getName()));
                    this.totalInfosTmp.put(sc.getName(), new ServiceStatTmp(sc.getName()));
                    this.lastInfos.put(sc.getName(), new ServiceStatTmp(sc.getName()));
                    this.rotator = new Byte2StringRotator();
                    ++i;
                }
            }
        }
    }

    public synchronized void update(Observable obser, Object obj) {
        TaskQueue queue = (TaskQueue)obser;
        ArrayList ts = queue.getTasks();
        this.statTask(ts, queue.getTaskCount());
        this.updateServiceInfo();
    }

    private void updateServiceInfo() {
        if (this.scs != null) {
            int i = 0;
            int length = this.scs.length;
            while (i < length) {
                ServiceStat stat = (ServiceStat)this.totalInfos.get(this.scs[i].getName());
                ServiceInfo si = MBeanManager.getServiceInfoMBean(stat.getChannelName());
                if (si != null) {
                    si.setTotalTaskCount(stat.getTotalTrans());
                    si.setTotalSuccessTaskCount(stat.getTotalSuccessTrans());
                    si.setTotalSuccessTaskPercent(stat.getSuccessPercent());
                    si.setTotalFailedTaskCount(stat.getTotalFailedTrans());
                    si.setTotalFailedDescribe(stat.getFailedDesc().toString());
                    stat = (ServiceStat)this.minInfos.get(this.scs[i].getName());
                    si.setMinTaskCount(stat.getTotalTrans());
                    si.setMinSuccessTaskCount(stat.getTotalSuccessTrans());
                    si.setMinSuccessTaskPercent(stat.getSuccessPercent());
                    si.setMinFailedTaskCount(stat.getTotalFailedTrans());
                    si.setMinFailedDescribe(stat.getFailedDesc().toString());
                }
                ++i;
            }
        }
    }

    private void statTask(ArrayList ts, HashMap taskCounts) {
        ServiceStatTmp tmp;
        long now = System.currentTimeMillis();
        String[] serviceNames = taskCounts.keySet().toArray(new String[taskCounts.keySet().size()]);
        int i = 0;
        int length = serviceNames.length;
        while (i < length) {
            TaskCount tc = (TaskCount)taskCounts.get(serviceNames[i]);
            tmp = (ServiceStatTmp)this.totalInfosTmp.get(serviceNames[i]);
            if (tmp == null) {
                tmp = new ServiceStatTmp(serviceNames[i]);
                this.totalInfosTmp.put(serviceNames[i], tmp);
            }
            tmp.total = tc.getTotal();
            tmp.totalSuccess = tc.getSuccess();
            tmp.totalFailed = tc.getFailed();
            ++i;
        }
        i = 0;
        int size = ts.size();
        while (i < size) {
            String errorCount;
            Task t = (Task)ts.remove(0);
            tmp = (ServiceStatTmp)this.totalInfosTmp.get(String.valueOf(t.getChannelID()));
            if (tmp == null) {
                tmp = new ServiceStatTmp(t.getChannelID());
                this.totalInfosTmp.put(t.getChannelID(), tmp);
            }
            if ((errorCount = (String)tmp.failedDesc.get(String.valueOf(t.getErrorNum()))) != null) {
                int errorCountInt = Integer.parseInt(errorCount) + 1;
                tmp.failedDesc.put(String.valueOf(t.getErrorNum()), String.valueOf(errorCountInt));
            } else {
                tmp.failedDesc.put(String.valueOf(t.getErrorNum()), "1");
            }
            ++i;
        }
        ts.clear();
        ts = null;
        if (this.scs != null) {
            ServiceStat stat;
            i = 0;
            length = this.scs.length;
            while (i < length) {
                ServiceStatTmp statTmp;
                stat = (ServiceStat)this.totalInfos.get(this.scs[i].getName());
                if (stat == null) {
                    stat = MBeanManager.createServiceStat(this.scs[i].getName());
                    this.totalInfos.put(this.scs[i].getName(), stat);
                }
                if ((statTmp = (ServiceStatTmp)this.totalInfosTmp.get(this.scs[i].getName())) == null) {
                    statTmp = new ServiceStatTmp(this.scs[i].getName());
                    this.totalInfosTmp.put(this.scs[i].getName(), statTmp);
                }
                this.updateServiceStatTotal(stat, statTmp);
                ++i;
            }
            i = 0;
            length = this.scs.length;
            while (i < length) {
                ServiceStatTmp last;
                stat = (ServiceStat)this.minInfos.get(this.scs[i].getName());
                if (stat == null) {
                    stat = MBeanManager.createServiceStat(this.scs[i].getName());
                    this.minInfos.put(this.scs[i].getName(), MBeanManager.createServiceStat(this.scs[i].getName()));
                }
                if ((last = (ServiceStatTmp)this.lastInfos.get(this.scs[i].getName())) == null) {
                    last = new ServiceStatTmp(this.scs[i].getName());
                    this.lastInfos.put(this.scs[i].getName(), last);
                }
                ServiceStatTmp statTmp = (ServiceStatTmp)this.totalInfosTmp.get(this.scs[i].getName());
                if (now / 60000L != this.lastCollect / 60000L) {
                    stat.clear();
                    last.total = statTmp.total;
                    last.totalSuccess = statTmp.totalSuccess;
                    last.totalFailed = statTmp.totalFailed;
                }
                this.updateServiceStatMin(stat, last, statTmp);
                statTmp.clear();
                ++i;
            }
        }
        this.lastCollect = now;
    }

    private void updateServiceStatMin(ServiceStat stat, ServiceStatTmp last, ServiceStatTmp tmp) {
        stat.setTotalTrans(tmp.total - last.total);
        stat.setTotalFailedTrans(tmp.totalFailed - last.totalFailed);
        stat.setTotalSuccessTrans(tmp.totalSuccess - last.totalSuccess);
        long totalTrans = Long.parseLong(stat.getTotalTrans());
        long totalSuccess = Long.parseLong(stat.getTotalSuccessTrans());
        String successPercent = totalTrans != 0L ? String.valueOf(totalSuccess * 100L / totalTrans) + "%" : "0%";
        stat.setSuccessPercent(successPercent);
        Set keys = tmp.failedDesc.keySet();
        if (keys != null && keys.size() > 0) {
            String[] keysStr = keys.toArray(new String[0]);
            HashMap desc = stat.getFailedDesc();
            int i = 0;
            int length = keysStr.length;
            while (i < length) {
                String value = (String)desc.get(keysStr[i]);
                if (value != null && !value.equals("")) {
                    value = String.valueOf(Long.parseLong(value) + Long.parseLong((String)tmp.failedDesc.get(keysStr[i])));
                    desc.put(keysStr[i], value);
                } else {
                    desc.put(keysStr[i], tmp.failedDesc.get(keysStr[i]));
                }
                ++i;
            }
        }
    }

    private void updateServiceStatTotal(ServiceStat stat, ServiceStatTmp tmp) {
        stat.setTotalTrans(tmp.total);
        stat.setTotalFailedTrans(tmp.totalFailed);
        stat.setTotalSuccessTrans(tmp.totalSuccess);
        long totalTrans = Long.parseLong(stat.getTotalTrans());
        long totalSuccess = Long.parseLong(stat.getTotalSuccessTrans());
        String successPercent = totalTrans != 0L ? String.valueOf(totalSuccess * 100L / totalTrans) + "%" : "0%";
        stat.setSuccessPercent(successPercent);
        Set keys = tmp.failedDesc.keySet();
        if (keys != null && keys.size() > 0) {
            String[] keysStr = keys.toArray(new String[0]);
            HashMap desc = stat.getFailedDesc();
            int i = 0;
            int length = keysStr.length;
            while (i < length) {
                String value = (String)desc.get(keysStr[i]);
                if (value != null && !value.equals("")) {
                    value = String.valueOf(Long.parseLong(value) + Long.parseLong((String)tmp.failedDesc.get(keysStr[i])));
                    desc.put(keysStr[i], value);
                } else {
                    desc.put(keysStr[i], tmp.failedDesc.get(keysStr[i]));
                }
                ++i;
            }
        }
    }

    class ServiceStatTmp {
        public String channelID = "0";
        public long total = 0L;
        public long totalSuccess = 0L;
        public long totalFailed = 0L;
        public HashMap failedDesc = new HashMap();

        public ServiceStatTmp(String id) {
            this.channelID = id;
        }

        public void clear() {
            this.total = 0L;
            this.totalSuccess = 0L;
            this.totalFailed = 0L;
            this.failedDesc = new HashMap();
        }
    }
}

