/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.isfwimpl;

import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.communication.multiple.Byte2StringRotator;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;

public class NetSignRotator
extends Byte2StringRotator {
    public AbstractMessage read(byte[] bs, int length) throws IOException, ClassNotFoundException {
        return this.generateMessage(bs, length);
    }

    public NSMessageOpt generateMessage(byte[] bytes, int length) throws IOException, ClassNotFoundException {
        NSMessageOpt msg = new NSMessageOpt();
        msg.setSize(length + 13);
        int i = 13;
        int max = length + 13;
        block64: while (i < max) {
            byte tag = bytes[i];
            int len = this._readLen(i, bytes);
            if (len < 0 || len > bytes.length) {
                throw new IOException("Error message length:" + len);
            }
            byte[] value = this._readValue(i, len, bytes);
            i += len + 14;
            switch (tag) {
                case 5: {
                    String errMsg = new String(value);
                    msg.setErrMsg(errMsg);
                    break;
                }
                case 4: {
                    String result = new String(value);
                    if (result == null || result.equals("")) continue block64;
                    msg.setResult(Integer.parseInt(result));
                    break;
                }
                case 1: {
                    String processor = new String(value);
                    msg.setProcessor(processor);
                    break;
                }
                case 2: {
                    String type = new String(value);
                    msg.setType(type);
                    break;
                }
                case 3: {
                    String clientId = new String(value);
                    msg.setClientId(clientId);
                    break;
                }
                case 6: {
                    byte commMode = value[0];
                    msg.setCommunicateMode(commMode);
                    break;
                }
                case 7: {
                    msg.setZipMode(value[0] != 0);
                    break;
                }
                case 8: {
                    msg.setEncKey(value);
                    break;
                }
                case 9: {
                    msg.setKeyHash(value);
                    break;
                }
                case 10: {
                    msg.setPlainText(value);
                    break;
                }
                case 11: {
                    msg.setCryptoText(value);
                    break;
                }
                case 16: {
                    msg.setEncCertDN(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 17: {
                    msg.setSignCertDN(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 31: {
                    msg.setHashValue(value);
                    break;
                }
                case 20: {
                    msg.setSignSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 25: {
                    msg.setEncSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 15: {
                    if (value[0] == 49) {
                        msg.setTransCert(true);
                        break;
                    }
                    msg.setTransCert(false);
                    break;
                }
                case 14: {
                    if (value.length == 0) break;
                    ByteArrayInputStream bain = new ByteArrayInputStream(value);
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bain);
                        msg.setCert(cert);
                    }
                    catch (Exception e) {
                        throw new IOException(e.toString());
                    }
                    bain.close();
                    break;
                }
                case 32: {
                    if (value.length == 0) break;
                    if (Utils.getPublicKeyType(value) == 99) {
                        try {
                            X509EncodedKeySpec kspe = new X509EncodedKeySpec(value);
                            KeyFactory kf = KeyFactory.getInstance("RSA", "INFOSEC");
                            msg.setPublicKey(kf.generatePublic(kspe));
                            break;
                        }
                        catch (Exception e) {
                            throw new IOException(e.toString());
                        }
                    }
                    msg.setPublicKey((PublicKey)new JCESM2PublicKey(value));
                    break;
                }
                case 41: {
                    msg.setAPIPasswd(value);
                    break;
                }
                case 42: {
                    msg.setBankName(this.newString(value, "GBK"));
                    break;
                }
                case 43: {
                    msg.setBankID(new String(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 62: {
                    msg.setResourceName(new String(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 18: {
                    String digestAlg = new String(value);
                    msg.setDigestAlg(digestAlg);
                    break;
                }
                case 19: {
                    String symmAlg = new String(value);
                    msg.setSymmetricalAlg(symmAlg);
                    break;
                }
                case 21: {
                    msg.setSignSerNumber(new String(value));
                    break;
                }
                case 22: {
                    msg.setSignIssuerSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 23: {
                    msg.setSignStartTime(new String(value));
                    break;
                }
                case 24: {
                    msg.setSignEndTime(new String(value));
                    break;
                }
                case 26: {
                    msg.setEncSerNumber(new String(value));
                    break;
                }
                case 27: {
                    msg.setEncIssuerSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 28: {
                    msg.setEncStartTime(new String(value));
                    break;
                }
                case 29: {
                    msg.setEncEndTime(new String(value));
                    break;
                }
                case 38: {
                    msg.setPDFSignatureRectangles(this.parsePDFSignParameters(value));
                    break;
                }
                case 39: {
                    msg.setPDFVerifyResults(this.parsePDFVerifyResults(value));
                    break;
                }
                case 61: {
                    msg.setXmlVerifyResults(this.parseXMLVerifyResults(value));
                    break;
                }
                case 37: {
                    msg.setPdfpasswd(value);
                    break;
                }
                case 40: {
                    msg.setPdfImages(this.parsePDFImages(value));
                    break;
                }
                case 44: {
                    msg.setBcHeight(Double.parseDouble(new String(value)));
                    break;
                }
                case 45: {
                    msg.setBcElementWidth(Double.parseDouble(new String(value)));
                    break;
                }
                case 46: {
                    msg.setBcDoQuietZone(value[0] != 0);
                    break;
                }
                case 47: {
                    msg.setBcQuietZoneWidth(Double.parseDouble(new String(value)));
                    break;
                }
                case 48: {
                    msg.setBcDisplayHumanReadable(value[0] != 0);
                    break;
                }
                case 49: {
                    msg.setBcDisplayHumanReadableStartStop(value[0] != 0);
                    break;
                }
                case 50: {
                    msg.setBcReturnFormat(Integer.parseInt(new String(value)));
                    break;
                }
                case 51: {
                    msg.setBcAddCheckSUM(value[0] != 0);
                    break;
                }
                case 52: {
                    msg.setBcWideFactor(Float.parseFloat(new String(value)));
                    break;
                }
                case 53: {
                    msg.setBcEncodingMode(Integer.parseInt(new String(value)));
                    break;
                }
                case 54: {
                    msg.setBcErrorCorrectingLevel(Integer.parseInt(new String(value)));
                    break;
                }
                case 55: {
                    msg.setBcAspectRatio(Float.parseFloat(new String(value)));
                    break;
                }
                case 56: {
                    msg.setBcYHeight(Float.parseFloat(new String(value)));
                    break;
                }
                case 57: {
                    msg.setBcBarSize(Integer.parseInt(new String(value)));
                    break;
                }
                case 58: {
                    msg.setBcSymbology(value);
                    break;
                }
                case 59: {
                    msg.setXmlSigID(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 60: {
                    msg.setXmlReferenceURI(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 12: {
                    msg.setTSAText(value);
                    break;
                }
                case 13: {
                    msg.setUsedTSA(value[0] != 0);
                    break;
                }
                case 30: {
                    msg.setTSAGenerateTime(new String(value));
                }
            }
        }
        return msg;
    }
}

