/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.isfwimpl;

import cn.com.infosec.isfw2.sfw.ProtocolHandler;
import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.isfwimpl.NetSignRotator;
import cn.com.infosec.netsign.jmx.Task;
import cn.com.infosec.netsign.jmx.TaskFactory;
import cn.com.infosec.netsign.jmx.TaskQueue;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class NetSignProtocolHandler
implements ProtocolHandler {
    private static final byte DEFAULT_COMM_FLAG = 0;
    private static final byte C1 = 1;
    private static final byte C2 = 2;
    private static final int MAX_LENGTH = 524288000;
    private String channleID = "0";

    public NetSignProtocolHandler(String channelID) {
        this.channleID = channelID;
    }

    public ByteBuffer encodeRequest(Request req) throws Exception {
        return null;
    }

    public byte[] encodeRequestToBytes(Request req) throws Exception {
        return null;
    }

    public Response parseResponse(byte[] data) throws Exception {
        return null;
    }

    public Response parseResponse(ByteBuffer buff) throws Exception {
        return null;
    }

    public ByteBuffer encodeResponseBak(Response res) throws Exception {
        byte[] bs = new byte[2375];
        ByteBuffer buf = ByteBuffer.allocate(bs.length);
        buf.put(bs);
        buf.flip();
        return buf;
    }

    public ByteBuffer encodeResponse(Response res) throws Exception {
        NetSignResponse nsRes = (NetSignResponse)res;
        NetSignRotator ro = this.getRotator((byte)nsRes.getProtocol());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        ro.write(nsRes.getNSMessage(), out);
        byte[] bs = bout.toByteArray();
        ByteBuffer buf = ByteBuffer.allocate(bs.length);
        buf.put(bs);
        buf.flip();
        return buf;
    }

    public Request parseRequest(ByteBuffer buf) throws Exception {
        return this.parseRequest(buf, 0L);
    }

    public Request parseRequest(ByteBuffer buf, long ioCost) throws Exception {
        buf.flip();
        byte[] bs = buf.array();
        ConsoleLogger.saveBinary((String)"/tmp/readed", (byte[])bs);
        byte flag = bs[0];
        NetSignRotator ro = this.getRotator(flag);
        int len = this.getMsgDataLength(bs, flag);
        try {
            NSMessage msg = (NSMessage)ro.read(bs, len);
            NetSignRequest netSignRequest = NetSignRequest.createNetSignRequest(msg, flag, System.nanoTime(), ioCost);
            return netSignRequest;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
        finally {
            buf.clear();
        }
    }

    private int getMsgDataLength(byte[] bs, int flag) throws IOException {
        byte[] bsLen = new byte[12];
        System.arraycopy(bs, 1, bsLen, 0, 12);
        int len = 0;
        try {
            len = Integer.parseInt(new String(bsLen));
        }
        catch (Exception e) {
            throw new IOException("read length failed,len=" + new String(bsLen));
        }
        if (len < 0 || len > 0x32000000) {
            throw new IOException("Illegal length received :" + len);
        }
        return len;
    }

    private NetSignRotator getRotator(byte flag) throws IOException {
        if (flag == 2 || flag == 50) {
            return new NetSignRotator();
        }
        throw new IOException("Unsuport protocol identifier:" + flag);
    }

    private static int bytes2Int(byte[] bs) {
        return ((bs[0] & 0xFF) << 24) + ((bs[1] & 0xFF) << 16) + ((bs[2] & 0xFF) << 8) + ((bs[3] & 0xFF) << 0);
    }

    private static byte[] int2Bytes(int len) {
        byte[] bs = new byte[]{(byte)(len >>> 24 & 0xFF), (byte)(len >>> 16 & 0xFF), (byte)(len >>> 8 & 0xFF), (byte)(len >>> 0 & 0xFF)};
        return bs;
    }

    public boolean isAllDataRecved(ByteBuffer buffer) throws IOException {
        try {
            boolean b = this.isAllDataRecvedHandler(buffer);
            ConsoleLogger.logString((String)("isAllDataReceived:" + b), (int)0);
            return b;
        }
        catch (IOException e) {
            ConsoleLogger.logException((Throwable)e);
            if (ExtendedConfig.getJmxMonitorLevel().equals("full")) {
                TaskQueue queue = TaskFactory.getTaskQueue();
                Task t = Task.getInstance(this.channleID, 10004);
                queue.addTask(t);
            }
            throw e;
        }
    }

    private boolean isAllDataRecvedHandler(ByteBuffer buffer) throws IOException {
        ByteBuffer dup = buffer.duplicate();
        if (dup.position() == 0) {
            return false;
        }
        dup.flip();
        if (dup.limit() < 1) {
            return false;
        }
        byte flag = dup.get();
        int length = 0;
        if (flag != 0 && flag != 1 && flag != 2 && flag != 48 && flag != 49 && flag != 50) {
            throw new IOException("Unsupport protocol :" + flag);
        }
        if (flag == 0 || flag == 1 || flag == 48 || flag == 49) {
            if (dup.remaining() < 4) {
                return false;
            }
            length = dup.getInt();
        } else {
            if (dup.remaining() < 12) {
                return false;
            }
            byte[] bs = new byte[12];
            dup.get(bs);
            try {
                length = Integer.parseInt(new String(bs));
            }
            catch (Exception e) {
                IOException ioe = new IOException("Unsupport protocol :" + e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
        if (length < 0 || length > 524288000) {
            throw new IOException("Illegal message data length :" + length);
        }
        return dup.remaining() >= length;
    }
}

