/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.communication.multiple;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.NetSignInputStream;
import cn.com.infosec.netsign.base.PDFRequest;
import cn.com.infosec.netsign.base.PDFVerifyResult;
import cn.com.infosec.netsign.base.XMLVerifyResult;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.communication.multiple.Rotator;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;

public class ByteRotator
implements Rotator {
    protected static final byte TYPE_STRING = 1;
    protected static final byte TYPE_INT = 2;
    protected static final byte TYPE_BOOLEAN = 3;
    protected static final byte TYPE_BYTE_ARRAY = 4;
    protected static final byte TYPE_FILE = 5;
    protected static final byte TYPE_OTHER = 127;
    protected static final byte TAG_PROCESSOR = 1;
    protected static final byte CLS_PROCESSOR = 1;
    protected static final byte TAG_TYPE = 2;
    protected static final byte CLS_TYPE = 1;
    protected static final byte TAG_CLIENT_ID = 3;
    protected static final byte CLS_CLIENT_ID = 1;
    protected static final byte TAG_RESULT = 4;
    protected static final byte CLS_RESULT = 2;
    protected static final byte TAG_ERROR_MSG = 5;
    protected static final byte CLS_ERROR_MSG = 1;
    protected static final byte TAG_COMM_MODE = 6;
    protected static final byte CLS_COMM_MODE = 2;
    protected static final byte TAG_ZIP_MODE = 7;
    protected static final byte CLS_ZIP_MODE = 2;
    protected static final byte TAG_ENC_KEY = 8;
    protected static final byte CLS_ENC_KEY = 4;
    protected static final byte TAG_KEY_KASH = 9;
    protected static final byte CLS_KEY_HASH = 4;
    protected static final byte TAG_PLAIN_TEXT = 10;
    protected static final byte CLS_PLAIN_TEXT = 4;
    protected static final byte TAG_CRYPTO_TEXT = 11;
    protected static final byte CLS_CRYPTO_TEXT = 4;
    protected static final byte TAG_TSA_TEXT = 12;
    protected static final byte CLS_TSA_TEXT = 4;
    protected static final byte TAG_USE_TSA = 13;
    protected static final byte CLS_USE_TSA = 2;
    protected static final byte TAG_CERT = 14;
    protected static final byte CLS_CERT = 4;
    protected static final byte TAG_TRANS_CERT = 15;
    protected static final byte CLS_TRANS_CERT = 2;
    protected static final byte TAG_ENC_CERT_DN = 16;
    protected static final byte CLS_ENC_CERT_DN = 1;
    protected static final byte TAG_SIGN_CERT_DN = 17;
    protected static final byte CLS_SIGN_CERT_DN = 1;
    protected static final byte TAG_DIGEST_ALG = 18;
    protected static final byte CLS_DIGEST_ALG = 1;
    protected static final byte TAG_SYMMETRICAL_ALG = 19;
    protected static final byte CLS_SYMMETRICAL_ALG = 1;
    protected static final byte TAG_SIGN_CERT_SUBJECT = 20;
    protected static final byte CLS_SIGN_CERT_SUBJECT = 1;
    protected static final byte TAG_SIGN_CERT_SERNUMBER = 21;
    protected static final byte CLS_SIGN_CERT_SERNUMBER = 1;
    protected static final byte TAG_SIGN_CERT_ISSUER_SUBJECT = 22;
    protected static final byte CLS_SIGN_CERT_ISSUER_SUBJECT = 1;
    protected static final byte TAG_SIGN_CERT_START_TIME = 23;
    protected static final byte CLS_SIGN_CERT_START_TIME = 1;
    protected static final byte TAG_SIGN_CERT_END_TIME = 24;
    protected static final byte CLS_SIGN_CERT_END_TIME = 1;
    protected static final byte TAG_ENC_CERT_SUBJECT = 25;
    protected static final byte CLS_ENC_CERT_SUBJECT = 1;
    protected static final byte TAG_ENC_CERT_SERNUMBER = 26;
    protected static final byte CLS_ENC_CERT_SERNUMBER = 1;
    protected static final byte TAG_ENC_CERT_ISSUER_SUBJECT = 27;
    protected static final byte CLS_ENC_CERT_ISSUER_SUBJECT = 1;
    protected static final byte TAG_ENC_CERT_START_TIME = 28;
    protected static final byte CLS_ENC_CERT_START_TIME = 1;
    protected static final byte TAG_ENC_CERT_END_TIME = 29;
    protected static final byte CLS_ENC_CERT_END_TIME = 1;
    protected static final byte TAG_TSA_GEN_TIME = 30;
    protected static final byte CLS_TSA_GEN_TIME = 1;
    protected static final byte TAG_HASH_VALUE = 31;
    protected static final byte CLS_HASH_VALUE = 4;
    protected static final byte TAG_PUBLICKEY = 32;
    protected static final byte CLS_PUBLICKEY = 4;
    protected static final byte TAG_TRANID = 33;
    protected static final byte CLS_TRANID = 4;
    protected static final byte TAG_PLAIN_TEXT_FILE = 35;
    protected static final byte CLS_PLAIN_TEXT_FILE = 5;
    protected static final byte TAG_CRYPTO_TEXT_FILE = 36;
    protected static final byte CLS_CRYPTO_TEXT_FILE = 5;
    protected static final byte TAG_PDF_PASSWORD = 37;
    protected static final byte CLS_PDF_PASSWORD = 4;
    protected static final byte TAG_PDF_SIGN_PARAMETERS = 38;
    protected static final byte CLS_PDF_SIGN_PARAMETERS = 1;
    protected static final byte TAG_PDF_VERIFY_RESULTS = 39;
    protected static final byte CLS_PDF_VERIFY_RESULTS = 1;
    protected static final byte TAG_PDF_IMAGES = 40;
    protected static final byte TAG_API_PASSWD = 41;
    protected static final byte TAG_BANK_NAME = 42;
    protected static final byte TAG_BANK_ID = 43;
    protected static final byte TAG_BC_HEIGHT = 44;
    protected static final byte TAG_BC_ELEMENT_WIDTH = 45;
    protected static final byte TAG_BC_DO_QUIET_ZONE = 46;
    protected static final byte TAG_BC_QUIET_ZONE_WIDTH = 47;
    protected static final byte TAG_BC_DISPLAY_HUMAN_READABLE = 48;
    protected static final byte TAG_BC_DISPLAY_HUMAN_READABLE_START_STOP = 49;
    protected static final byte TAG_BC_RETURN_FORMAT = 50;
    protected static final byte TAG_BC_ADD_CHECK_SUM = 51;
    protected static final byte TAG_BC_WIDE_FACTOR = 52;
    protected static final byte TAG_BC_ENCODING_MODE = 53;
    protected static final byte TAG_BC_ERROR_CORRECTING_LEVEL = 54;
    protected static final byte TAG_BC_ASPECT_RATIO = 55;
    protected static final byte TAG_BC_Y_HEIGHT = 56;
    protected static final byte TAG_BC_BAR_SIZE = 57;
    protected static final byte TAG_BC_SYMBOLOGY = 58;
    protected static final byte TAG_XML_SIGNATURE_ID = 59;
    protected static final byte TAG_XML_SIGNATURE_REFERENCE_URI = 60;
    protected static final byte TAG_XML_VERIFY_RESULTS = 61;
    protected static final byte CLS_XML_VERIFY_RESULTS = 1;
    protected static final byte TAG_RESOURCELIST_NAME = 62;
    protected static final int LEN_INT = 4;
    protected static final int LEN_BOOL = 1;
    protected static final int LEN_BYTE = 1;
    protected static final int BUFFER_SIZE = 0x100000;

    protected void _writeResourceListName(String value, DataOutputStream out) throws IOException {
        out.writeByte(62);
        out.writeByte(1);
        byte[] tmp = this.getBytes(value, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeXmlSignatureID(String value, DataOutputStream out) throws IOException {
        out.writeByte(59);
        out.writeByte(1);
        byte[] tmp = this.getBytes(value, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeXmlSignatureReferenceID(String value, DataOutputStream out) throws IOException {
        out.writeByte(60);
        out.writeByte(1);
        byte[] tmp = this.getBytes(value, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeLength(int length, OutputStream out) throws IOException {
        out.write(Utils.generateBytes(length));
    }

    protected void _writeStream(NetSignInputStream[] in, OutputStream out) throws IOException {
        out.write(in.length);
        int i = 0;
        while (i < in.length) {
            String fileName = in[i].getFileName();
            InputStream s = in[i].getInputStream();
            this._writeLength(fileName.length(), out);
            out.write(fileName.getBytes());
            this._writeLength(s.available(), out);
            out.flush();
            this._writeStream(in[i].getInputStream(), out);
            ++i;
        }
    }

    protected void _writeStream(InputStream in, OutputStream out) throws IOException {
        int length = in.available();
        byte[] bs = new byte[0x100000];
        while (length > 0) {
            int len = length < 0x100000 ? length : 0x100000;
            int off = 0;
            while (len > 0) {
                int readed = in.read(bs, off, len);
                off += readed;
                len -= readed;
            }
            out.write(bs, 0, length < 0x100000 ? length : 0x100000);
            out.flush();
            length -= 0x100000;
        }
        in.close();
    }

    protected void _writeBCHeight(String value, DataOutputStream out) throws IOException {
        out.writeByte(44);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCElementWidth(String value, DataOutputStream out) throws IOException {
        out.writeByte(45);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCDoQuietZone(boolean value, DataOutputStream out) throws IOException {
        out.writeByte(46);
        out.writeByte(1);
        this._writeLength(1, out);
        out.writeBoolean(value);
    }

    protected void _writeBCQuietZoneWidth(String value, DataOutputStream out) throws IOException {
        out.writeByte(47);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCDisplayHumanReadable(boolean value, DataOutputStream out) throws IOException {
        out.writeByte(48);
        out.writeByte(1);
        this._writeLength(1, out);
        out.writeBoolean(value);
    }

    protected void _writeBCDisplayHumanReadableStartStop(boolean value, DataOutputStream out) throws IOException {
        out.writeByte(49);
        out.writeByte(1);
        this._writeLength(1, out);
        out.writeBoolean(value);
    }

    protected void _writeBCReturnFormat(String value, DataOutputStream out) throws IOException {
        out.writeByte(50);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCAddCheckSUM(boolean value, DataOutputStream out) throws IOException {
        out.writeByte(51);
        out.writeByte(1);
        this._writeLength(1, out);
        out.writeBoolean(value);
    }

    protected void _writeBCWideFactor(String value, DataOutputStream out) throws IOException {
        out.writeByte(52);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCEncodingMode(String value, DataOutputStream out) throws IOException {
        out.writeByte(53);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCErrorCorrectingLevel(String value, DataOutputStream out) throws IOException {
        out.writeByte(54);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCAspectRatio(String value, DataOutputStream out) throws IOException {
        out.writeByte(55);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCYHeight(String value, DataOutputStream out) throws IOException {
        out.writeByte(56);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCBarSize(String value, DataOutputStream out) throws IOException {
        out.writeByte(57);
        out.writeByte(1);
        this._writeLength(value.length(), out);
        out.write(value.getBytes());
    }

    protected void _writeBCSymbology(byte[] value, DataOutputStream out) throws IOException {
        out.writeByte(58);
        out.writeByte(1);
        this._writeLength(value.length, out);
        out.write(value);
    }

    protected void _writePDFImages(byte[] images, DataOutputStream out) throws IOException {
        out.writeByte(40);
        out.writeByte(4);
        this._writeLength(images.length, out);
        out.write(images);
    }

    protected void _writePDFPasswd(byte[] passwd, DataOutputStream out) throws IOException {
        out.writeByte(37);
        out.writeByte(4);
        this._writeLength(passwd.length, out);
        out.write(passwd);
    }

    protected void _writePDFSignParameters(byte[] parameters, DataOutputStream out) throws IOException {
        out.writeByte(38);
        out.writeByte(1);
        this._writeLength(parameters.length, out);
        out.write(parameters);
    }

    protected void _writePDFVerifyResults(byte[] results, DataOutputStream out) throws IOException {
        out.writeByte(39);
        out.writeByte(1);
        this._writeLength(results.length, out);
        out.write(results);
    }

    protected void _writeXMLVerifyResults(byte[] results, DataOutputStream out) throws IOException {
        out.writeByte(61);
        out.writeByte(1);
        this._writeLength(results.length, out);
        out.write(results);
    }

    protected void _writePlainTextFile(String fileName, DataOutputStream out) throws IOException {
        out.writeByte(35);
        out.writeByte(5);
        byte[] tmp = fileName.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeCryptoTextFile(String fileName, DataOutputStream out) throws IOException {
        out.writeByte(36);
        out.writeByte(5);
        byte[] tmp = fileName.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeProcessor(String processor, DataOutputStream out) throws IOException {
        out.writeByte(1);
        out.writeByte(1);
        byte[] tmp = processor.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeType(String type, DataOutputStream out) throws IOException {
        out.writeByte(2);
        out.writeByte(1);
        byte[] tmp = type.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeClientId(String clientId, DataOutputStream out) throws IOException {
        out.writeByte(3);
        out.writeByte(1);
        byte[] tmp = clientId.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeResult(int result, DataOutputStream out) throws IOException {
        out.writeByte(4);
        out.writeByte(2);
        out.writeInt(4);
        out.writeInt(result);
    }

    protected void _writeErrorMessage(String errMsg, DataOutputStream out) throws IOException {
        out.writeByte(5);
        out.writeByte(1);
        byte[] tmp = errMsg.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeCommMode(int commMode, DataOutputStream out) throws IOException {
        out.writeByte(6);
        out.writeByte(2);
        this._writeLength(1, out);
        out.writeByte(commMode);
    }

    protected void _writeZipMode(boolean zipMode, DataOutputStream out) throws IOException {
        out.writeByte(7);
        out.writeByte(2);
        this._writeLength(1, out);
        out.writeBoolean(zipMode);
    }

    protected void _writeEncKey(byte[] encKey, DataOutputStream out) throws IOException {
        out.writeByte(8);
        out.writeByte(4);
        this._writeLength(encKey.length, out);
        out.write(encKey);
    }

    protected void _writeKeyHash(byte[] keyHash, DataOutputStream out) throws IOException {
        out.writeByte(9);
        out.writeByte(4);
        this._writeLength(keyHash.length, out);
        out.write(keyHash);
    }

    protected void _writePlainText(byte[] plainText, DataOutputStream out) throws IOException {
        out.writeByte(10);
        out.writeByte(4);
        this._writeLength(plainText.length, out);
        out.write(plainText);
    }

    protected void _writeCryptoText(byte[] cryptoText, DataOutputStream out) throws IOException {
        out.writeByte(11);
        out.writeByte(4);
        this._writeLength(cryptoText.length, out);
        out.write(cryptoText);
    }

    protected void _writeTSAText(byte[] tsaText, DataOutputStream out) throws IOException {
        out.writeByte(12);
        out.writeByte(4);
        this._writeLength(tsaText.length, out);
        out.write(tsaText);
    }

    protected void _writeUsedTSA(boolean usedTSA, DataOutputStream out) throws IOException {
        out.writeByte(13);
        out.writeByte(2);
        this._writeLength(1, out);
        out.writeBoolean(usedTSA);
    }

    protected void _writeTransCert(boolean transCert, DataOutputStream out) throws IOException {
        out.writeByte(15);
        out.writeByte(2);
        this._writeLength(1, out);
        if (transCert) {
            out.writeByte(49);
        } else {
            out.writeByte(48);
        }
    }

    protected byte[] getBytes(String str, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            return str.getBytes();
        }
        return str.getBytes(encoding);
    }

    protected void _writeEncCertDN(String encCertDN, DataOutputStream out) throws IOException {
        out.writeByte(16);
        out.writeByte(1);
        byte[] tmp = this.getBytes(encCertDN, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSignCertDN(String signCertDN, DataOutputStream out) throws IOException {
        out.writeByte(17);
        out.writeByte(1);
        byte[] tmp = this.getBytes(signCertDN, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeDigestAlg(String digestAlg, DataOutputStream out) throws IOException {
        out.writeByte(18);
        out.writeByte(1);
        byte[] tmp = digestAlg.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSymmetricalAlg(String symmAlg, DataOutputStream out) throws IOException {
        out.writeByte(19);
        out.writeByte(1);
        byte[] tmp = symmAlg.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSignSubject(String subject, DataOutputStream out) throws IOException {
        CryptoUtil.debug((String)("2:" + subject));
        out.writeByte(20);
        out.writeByte(1);
        byte[] tmp = this.getBytes(subject, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSignSerNumber(String serNumber, DataOutputStream out) throws IOException {
        out.writeByte(21);
        out.writeByte(1);
        byte[] tmp = serNumber.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSignIssuerSubject(String issuerSubject, DataOutputStream out) throws IOException {
        out.writeByte(22);
        out.writeByte(1);
        byte[] tmp = this.getBytes(issuerSubject, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSignStartTime(String startTime, DataOutputStream out) throws IOException {
        out.writeByte(23);
        out.writeByte(1);
        byte[] tmp = startTime.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeSignEndTime(String endTime, DataOutputStream out) throws IOException {
        out.writeByte(24);
        out.writeByte(1);
        byte[] tmp = endTime.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeEncSubject(String subject, DataOutputStream out) throws IOException {
        out.writeByte(25);
        out.writeByte(1);
        byte[] tmp = this.getBytes(subject, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeEncSerNumber(String serNumber, DataOutputStream out) throws IOException {
        out.writeByte(26);
        out.writeByte(1);
        byte[] tmp = serNumber.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeEncIssuerSubject(String issuerSubject, DataOutputStream out) throws IOException {
        out.writeByte(27);
        out.writeByte(1);
        byte[] tmp = this.getBytes(issuerSubject, ExtendedConfig.getEncoding());
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeEncStartTime(String startTime, DataOutputStream out) throws IOException {
        out.writeByte(28);
        out.writeByte(1);
        byte[] tmp = startTime.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeEncEndTime(String endTime, DataOutputStream out) throws IOException {
        out.writeByte(29);
        out.writeByte(1);
        byte[] tmp = endTime.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeTSAGenTime(String genTime, DataOutputStream out) throws IOException {
        out.writeByte(30);
        out.writeByte(1);
        byte[] tmp = genTime.getBytes();
        this._writeLength(tmp.length, out);
        out.write(tmp);
    }

    protected void _writeCert(X509Certificate cert, DataOutputStream out) throws IOException {
        out.writeByte(14);
        out.writeByte(4);
        byte[] bs = null;
        try {
            bs = cert.getEncoded();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        this._writeLength(bs.length, out);
        out.write(bs);
    }

    protected void _writePublicKey(PublicKey pk, DataOutputStream out) throws IOException {
        out.writeByte(32);
        out.writeByte(4);
        byte[] bs = pk.getEncoded();
        this._writeLength(bs.length, out);
        out.write(bs);
    }

    protected void _writeHashValue(byte[] value, DataOutputStream out) throws IOException {
        out.writeByte(31);
        out.writeByte(4);
        this._writeLength(value.length, out);
        out.write(value);
    }

    protected void _writeBankID(String id, DataOutputStream out) throws IOException {
        out.writeByte(43);
        out.writeByte(1);
        byte[] bs = id.getBytes(ExtendedConfig.getEncoding());
        this._writeLength(bs.length, out);
        out.write(bs);
        out.flush();
    }

    protected void _writeBankName(String name, DataOutputStream out) throws IOException {
        out.writeByte(42);
        out.writeByte(1);
        byte[] bs = name.getBytes("GBK");
        this._writeLength(bs.length, out);
        out.write(bs);
        out.flush();
    }

    protected void _writeAPIPasswd(byte[] bs, DataOutputStream out) throws IOException {
        out.writeByte(41);
        out.writeByte(1);
        this._writeLength(bs.length, out);
        out.write(bs);
        out.flush();
    }

    protected byte[] generateBytes(int p, byte[] length, AbstractMessage msg) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(new BufferedOutputStream(bout));
        byte[] result = null;
        try {
            String str;
            out.writeByte(p);
            out.write(length);
            if (msg.getProcessor() != null) {
                this._writeProcessor(msg.getProcessor(), out);
            }
            this._writeType(msg.getType(), out);
            if (msg.getClientId() != null) {
                this._writeClientId(msg.getClientId(), out);
            }
            if (msg.getType().equals("response")) {
                this._writeResult(msg.getResult(), out);
                if (msg.getErrMsg() != null) {
                    this._writeErrorMessage(msg.getErrMsg(), out);
                }
            }
            if (msg instanceof NSMessage) {
                byte[] bs;
                NSMessage nsMsg = (NSMessage)msg;
                this._writeCommMode(nsMsg.getCommunicateMode(), out);
                if (nsMsg.isZipMode()) {
                    this._writeZipMode(nsMsg.isZipMode(), out);
                }
                if (nsMsg.getEncKey() != null) {
                    this._writeEncKey(nsMsg.getEncKey(), out);
                }
                if (nsMsg.getKeyHash() != null) {
                    this._writeKeyHash(nsMsg.getKeyHash(), out);
                }
                if (nsMsg.getPlainText() != null) {
                    this._writePlainText(nsMsg.getPlainText(), out);
                }
                if (nsMsg.getCryptoText() != null) {
                    this._writeCryptoText(nsMsg.getCryptoText(), out);
                }
                if (nsMsg.getTSAText() != null && nsMsg.getTSAText().length > 0) {
                    this._writeTSAText(nsMsg.getTSAText(), out);
                }
                if (nsMsg.getUsedTSA()) {
                    this._writeUsedTSA(nsMsg.getUsedTSA(), out);
                }
                if (nsMsg.getEncCertDN() != null) {
                    this._writeEncCertDN(nsMsg.getEncCertDN(), out);
                }
                if (nsMsg.getSignCertDN() != null) {
                    this._writeSignCertDN(nsMsg.getSignCertDN(), out);
                }
                if (nsMsg.getDigestAlg() != null) {
                    this._writeDigestAlg(nsMsg.getDigestAlg(), out);
                }
                if (nsMsg.getSymmetricalAlg() != null) {
                    this._writeSymmetricalAlg(nsMsg.getSymmetricalAlg(), out);
                }
                if (nsMsg.getCert() != null) {
                    this._writeCert(nsMsg.getCert(), out);
                }
                if (nsMsg.getPublicKey() != null) {
                    this._writePublicKey(nsMsg.getPublicKey(), out);
                }
                if (nsMsg.isTransCert()) {
                    this._writeTransCert(nsMsg.isTransCert(), out);
                }
                if (nsMsg.getPdfpasswd() != null) {
                    this._writePDFPasswd(nsMsg.getPdfpasswd(), out);
                }
                if ((str = nsMsg.getPDFSignatureRectangles2Trans()) != null) {
                    this._writePDFSignParameters(str.getBytes(ExtendedConfig.getEncoding()), out);
                }
                if (nsMsg.getHashValue() != null) {
                    this._writeHashValue(nsMsg.getHashValue(), out);
                }
                if ((bs = nsMsg.getPDFImages2Trans()) != null) {
                    this._writePDFImages(bs, out);
                }
                if (nsMsg.getBcHeight() > 0.0) {
                    this._writeBCHeight(String.valueOf(nsMsg.getBcHeight()), out);
                }
                if (nsMsg.getBcElementWidth() > 0.0) {
                    this._writeBCElementWidth(String.valueOf(nsMsg.getBcElementWidth()), out);
                }
                if (nsMsg.isBcDoQuietZone()) {
                    this._writeBCDoQuietZone(true, out);
                }
                if (nsMsg.getBcQuietZoneWidth() > 0.0) {
                    this._writeBCQuietZoneWidth(String.valueOf(nsMsg.getBcQuietZoneWidth()), out);
                }
                if (nsMsg.isBcDisplayHumanReadable()) {
                    this._writeBCDisplayHumanReadable(true, out);
                }
                if (nsMsg.isBcDisplayHumanReadableStartStop()) {
                    this._writeBCDisplayHumanReadableStartStop(true, out);
                }
                if (nsMsg.getBcReturnFormat() > -1) {
                    this._writeBCReturnFormat(String.valueOf(nsMsg.getBcReturnFormat()), out);
                }
                if (nsMsg.isBcAddCheckSUM()) {
                    this._writeBCAddCheckSUM(true, out);
                }
                if (nsMsg.getBcWideFactor() >= 1.0f) {
                    this._writeBCWideFactor(String.valueOf(nsMsg.getBcWideFactor()), out);
                }
                if (nsMsg.getBcEncodingMode() > -1) {
                    this._writeBCEncodingMode(String.valueOf(nsMsg.getBcEncodingMode()), out);
                }
                if (nsMsg.getBcErrorCorrectingLevel() > -1) {
                    this._writeBCErrorCorrectingLevel(String.valueOf(nsMsg.getBcErrorCorrectingLevel()), out);
                }
                if (nsMsg.getBcAspectRatio() > 0.0f) {
                    this._writeBCAspectRatio(String.valueOf(nsMsg.getBcAspectRatio()), out);
                }
                if (nsMsg.getBcYHeight() > 1.0f) {
                    this._writeBCYHeight(String.valueOf(nsMsg.getBcYHeight()), out);
                }
                if (nsMsg.getBcBarSize() > 0) {
                    this._writeBCBarSize(String.valueOf(nsMsg.getBcBarSize()), out);
                }
                if (nsMsg.getXmlSigID() != null) {
                    this._writeXmlSignatureID(nsMsg.getXmlSigID(), out);
                }
                if (nsMsg.getXmlReferenceURI() != null) {
                    this._writeXmlSignatureReferenceID(nsMsg.getXmlReferenceURI(), out);
                }
                if (nsMsg.getAPIPasswd() != null) {
                    this._writeAPIPasswd(nsMsg.getAPIPasswd(), out);
                }
                if (nsMsg.getBankName() != null) {
                    this._writeBankName(nsMsg.getBankName(), out);
                }
                if (nsMsg.getBankID() != null) {
                    this._writeBankID(nsMsg.getBankID(), out);
                }
                if (nsMsg.getResourceName() != null) {
                    this._writeResourceListName(str, out);
                }
            }
            if (msg instanceof NSMessageOpt) {
                String xmlstr;
                NSMessageOpt msgOpt = (NSMessageOpt)msg;
                if (msgOpt.getSignSubject() != null) {
                    this._writeSignSubject(msgOpt.getSignSubject(), out);
                }
                if (msgOpt.getSignSerNumber() != null) {
                    this._writeSignSerNumber(msgOpt.getSignSerNumber(), out);
                }
                if (msgOpt.getSignIssuerSubject() != null) {
                    this._writeSignIssuerSubject(msgOpt.getSignIssuerSubject(), out);
                }
                if (msgOpt.getSignStartTime() != null) {
                    this._writeSignStartTime(msgOpt.getSignStartTime(), out);
                }
                if (msgOpt.getSignEndtime() != null) {
                    this._writeSignEndTime(msgOpt.getSignEndtime(), out);
                }
                if (msgOpt.getEncSubject() != null) {
                    this._writeEncSubject(msgOpt.getEncSubject(), out);
                }
                if (msgOpt.getEncSerNumber() != null) {
                    this._writeEncSerNumber(msgOpt.getEncSerNumber(), out);
                }
                if (msgOpt.getEncIssuerSubject() != null) {
                    this._writeEncIssuerSubject(msgOpt.getEncIssuerSubject(), out);
                }
                if (msgOpt.getEncStartTime() != null) {
                    this._writeEncStartTime(msgOpt.getEncStartTime(), out);
                }
                if (msgOpt.getEncEndtime() != null) {
                    this._writeEncEndTime(msgOpt.getEncEndtime(), out);
                }
                if (msgOpt.getTSAGenerateTime() != null) {
                    this._writeTSAGenTime(msgOpt.getTSAGenerateTime(), out);
                }
                if ((str = msgOpt.getPDFVerifyResults2Trans()) != null) {
                    this._writePDFVerifyResults(str.getBytes(ExtendedConfig.getEncoding()), out);
                }
                if ((xmlstr = msgOpt.getXMLVerifyResults2Trans()) != null) {
                    this._writeXMLVerifyResults(xmlstr.getBytes(), out);
                }
                if (msgOpt.getBcSymbology() != null) {
                    this._writeBCSymbology(msgOpt.getBcSymbology(), out);
                }
            }
            out.flush();
            result = bout.toByteArray();
        }
        finally {
            try {
                bout.close();
                out.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    protected int _readLen(int i, byte[] bytes) throws IOException {
        byte[] blen = new byte[]{bytes[i + 2], bytes[i + 3], bytes[i + 4], bytes[i + 5]};
        int len = Utils.generateInt(blen);
        if (len > bytes.length || len < 0) {
            throw new IOException("Illegal length received: " + len);
        }
        return len;
    }

    protected byte[] _readValue(int i, int len, byte[] bytes) {
        byte[] value = new byte[len];
        System.arraycopy(bytes, i + 6, value, 0, len);
        return value;
    }

    protected NetSignInputStream[] _readStream(InputStream in) throws IOException {
        int count = in.read();
        if (count > 0) {
            NetSignInputStream[] streams = new NetSignInputStream[count];
            int i = 0;
            while (i < count) {
                byte[] bs = this.readData(in, 4);
                int length = Utils.generateInt(bs);
                bs = this.readData(in, length);
                String name = new String(bs);
                bs = this.readData(in, 4);
                length = Utils.generateInt(bs);
                File f = new File("/temp/ns/" + name);
                FileOutputStream out = new FileOutputStream(f);
                while (length > 0) {
                    int len = length < 0x100000 ? length : 0x100000;
                    bs = this.readData(in, len);
                    out.write(bs);
                    out.flush();
                    length -= len;
                }
                out.close();
                streams[i] = NetSignInputStream.createNetSignInputStream(f);
                ++i;
            }
            return streams;
        }
        return null;
    }

    protected String newString(byte[] bs, String encoding) throws UnsupportedEncodingException {
        if (encoding == null || encoding.equals("")) {
            return new String(bs);
        }
        return new String(bs, encoding);
    }

    protected NSMessage generateMessage(byte[] bytes) throws IOException, ClassNotFoundException {
        NSMessageOpt msg = new NSMessageOpt();
        msg.setSize(bytes.length + 5);
        int i = 0;
        while (i < bytes.length) {
            byte tag = bytes[i];
            int len = this._readLen(i, bytes);
            if (len < 0 || len > bytes.length) {
                throw new IOException("Error message length:" + len);
            }
            byte[] value = this._readValue(i, len, bytes);
            i += len + 6;
            switch (tag) {
                case 5: {
                    String errMsg = new String(value);
                    msg.setErrMsg(errMsg);
                    break;
                }
                case 4: {
                    int result = Utils.generateInt(value);
                    msg.setResult(result);
                    break;
                }
                case 1: {
                    String processor = new String(value);
                    msg.setProcessor(processor);
                    break;
                }
                case 2: {
                    String type = new String(value);
                    msg.setType(type);
                    break;
                }
                case 3: {
                    String clientId = new String(value);
                    msg.setClientId(clientId);
                    break;
                }
                case 6: {
                    byte commMode = value[0];
                    msg.setCommunicateMode(commMode);
                    break;
                }
                case 7: {
                    msg.setZipMode(value[0] != 0);
                    break;
                }
                case 8: {
                    msg.setEncKey(value);
                    break;
                }
                case 9: {
                    msg.setKeyHash(value);
                    break;
                }
                case 10: {
                    msg.setPlainText(value);
                    break;
                }
                case 11: {
                    msg.setCryptoText(value);
                    break;
                }
                case 12: {
                    msg.setTSAText(value);
                    break;
                }
                case 13: {
                    msg.setUsedTSA(value[0] != 0);
                    break;
                }
                case 16: {
                    String encDN = new String(value);
                    msg.setEncCertDN(encDN);
                    break;
                }
                case 17: {
                    String signDN = new String(value);
                    msg.setSignCertDN(signDN);
                    break;
                }
                case 18: {
                    String digestAlg = new String(value);
                    msg.setDigestAlg(digestAlg);
                    break;
                }
                case 19: {
                    String symmAlg = new String(value);
                    msg.setSymmetricalAlg(symmAlg);
                    break;
                }
                case 20: {
                    msg.setSignSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 21: {
                    msg.setSignSerNumber(new String(value));
                    break;
                }
                case 22: {
                    msg.setSignIssuerSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 23: {
                    msg.setSignStartTime(new String(value));
                    break;
                }
                case 24: {
                    msg.setSignEndTime(new String(value));
                    break;
                }
                case 25: {
                    msg.setEncSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 26: {
                    msg.setEncSerNumber(new String(value));
                    break;
                }
                case 27: {
                    msg.setEncIssuerSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 28: {
                    msg.setEncStartTime(new String(value));
                    break;
                }
                case 29: {
                    msg.setEncEndTime(new String(value));
                    break;
                }
                case 30: {
                    msg.setTSAGenerateTime(new String(value));
                    break;
                }
                case 31: {
                    msg.setHashValue(value);
                    break;
                }
                case 15: {
                    if (value[0] == 49) {
                        msg.setTransCert(true);
                        break;
                    }
                    msg.setTransCert(false);
                    break;
                }
                case 14: {
                    if (value.length == 0) break;
                    ByteArrayInputStream bain = new ByteArrayInputStream(value);
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bain);
                        msg.setCert(cert);
                    }
                    catch (Exception e) {
                        throw new IOException(e.toString());
                    }
                    bain.close();
                    break;
                }
                case 37: {
                    msg.setPdfpasswd(value);
                    break;
                }
                case 38: {
                    msg.setPDFSignatureRectangles(this.parsePDFSignParameters(value));
                    break;
                }
                case 39: {
                    msg.setPDFVerifyResults(this.parsePDFVerifyResults(value));
                    break;
                }
                case 61: {
                    msg.setXmlVerifyResults(this.parseXMLVerifyResults(value));
                    break;
                }
                case 32: {
                    if (value.length == 0) break;
                    try {
                        X509EncodedKeySpec kspe = new X509EncodedKeySpec(value);
                        KeyFactory kf = KeyFactory.getInstance("RSA", "INFOSEC");
                        msg.setPublicKey(kf.generatePublic(kspe));
                        break;
                    }
                    catch (Exception e) {
                        throw new IOException(e.toString());
                    }
                }
                case 40: {
                    msg.setPdfImages(this.parsePDFImages(value));
                    break;
                }
                case 44: {
                    msg.setBcHeight(Double.parseDouble(new String(value)));
                    break;
                }
                case 45: {
                    msg.setBcElementWidth(Double.parseDouble(new String(value)));
                    break;
                }
                case 46: {
                    msg.setBcDoQuietZone(value[0] != 0);
                    break;
                }
                case 47: {
                    msg.setBcQuietZoneWidth(Double.parseDouble(new String(value)));
                    break;
                }
                case 48: {
                    msg.setBcDisplayHumanReadable(value[0] != 0);
                    break;
                }
                case 49: {
                    msg.setBcDisplayHumanReadableStartStop(value[0] != 0);
                    break;
                }
                case 50: {
                    msg.setBcReturnFormat(Integer.parseInt(new String(value)));
                    break;
                }
                case 51: {
                    msg.setBcAddCheckSUM(value[0] != 0);
                    break;
                }
                case 52: {
                    msg.setBcWideFactor(Float.parseFloat(new String(value)));
                    break;
                }
                case 53: {
                    msg.setBcEncodingMode(Integer.parseInt(new String(value)));
                    break;
                }
                case 54: {
                    msg.setBcErrorCorrectingLevel(Integer.parseInt(new String(value)));
                    break;
                }
                case 55: {
                    msg.setBcAspectRatio(Float.parseFloat(new String(value)));
                    break;
                }
                case 56: {
                    msg.setBcYHeight(Float.parseFloat(new String(value)));
                    break;
                }
                case 57: {
                    msg.setBcBarSize(Integer.parseInt(new String(value)));
                    break;
                }
                case 58: {
                    msg.setBcSymbology(value);
                    break;
                }
                case 59: {
                    msg.setXmlSigID(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 60: {
                    msg.setXmlReferenceURI(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 41: {
                    try {
                        msg.setAPIPasswd(value);
                        break;
                    }
                    catch (Exception e) {
                        throw new IOException(e.toString());
                    }
                }
                case 42: {
                    msg.setBankName(this.newString(value, "GBK"));
                    break;
                }
                case 43: {
                    msg.setBankID(new String(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 62: {
                    msg.setResourceName(new String(value, ExtendedConfig.getEncoding()));
                }
            }
        }
        return msg;
    }

    protected ArrayList parsePDFImages(byte[] bs) {
        ArrayList<PDFRequest> pres = new ArrayList<PDFRequest>();
        try {
            int i = 0;
            while (i < bs.length) {
                byte[] l = new byte[4];
                System.arraycopy(bs, i, l, 0, 4);
                int imgParaLength = Utils.generateInt(l);
                byte[] imgContent = new byte[imgParaLength];
                System.arraycopy(bs, i + 4, imgContent, 0, imgParaLength);
                PDFRequest prq = new PDFRequest();
                pres.add(prq.decodeImage(imgContent));
                i += 4 + imgParaLength;
            }
            return pres;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    protected ArrayList parsePDFSignParameters(byte[] bs) {
        ArrayList<PDFRequest> pres = new ArrayList<PDFRequest>();
        try {
            String str = new String(bs, ExtendedConfig.getEncoding());
            String[] pieces = str.split("<psr>");
            if (pieces.length > 0) {
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    PDFRequest prq = new PDFRequest();
                    if ((prq = prq.parse(pieces[i])) != null) {
                        pres.add(prq);
                    }
                    ++i;
                }
                return pres;
            }
            return null;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    protected ArrayList parsePDFVerifyResults(byte[] bs) {
        try {
            String str = new String(bs, ExtendedConfig.getEncoding());
            String[] pieces = str.split("<pvr>");
            if (pieces.length > 0) {
                ArrayList<PDFVerifyResult> results = new ArrayList<PDFVerifyResult>();
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    PDFVerifyResult pvr = PDFVerifyResult.parse(pieces[i]);
                    if (pvr != null) {
                        results.add(pvr);
                    }
                    ++i;
                }
                return results;
            }
            return null;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    protected ArrayList parseXMLVerifyResults(byte[] bs) {
        try {
            String str = null;
            str = ExtendedConfig.getEncoding() == null ? new String(bs) : new String(bs, ExtendedConfig.getEncoding());
            String[] pieces = str.split("<xvr>");
            if (pieces.length > 0) {
                ArrayList<XMLVerifyResult> results = new ArrayList<XMLVerifyResult>();
                int i = 0;
                int length = pieces.length;
                while (i < length) {
                    XMLVerifyResult pvr = XMLVerifyResult.parse(pieces[i]);
                    if (pvr != null) {
                        results.add(pvr);
                    }
                    ++i;
                }
                return results;
            }
            return null;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    public String toSubject(byte[] bs) {
        X500Principal dn = new X500Principal(bs);
        return dn.getName();
    }

    public void write(AbstractMessage msg, DataOutputStream out) throws IOException {
        byte[] data = this.generateBytes(1, Utils.generateBytes(0), msg);
        byte[] length = Utils.generateBytes(data.length - 5);
        System.arraycopy(length, 0, data, 1, 4);
        out.write(data);
        out.flush();
        data = null;
        NSMessage nsmsg = (NSMessage)msg;
        if (nsmsg.getPlainTextFile() != null || nsmsg.getCryptoTextFile() != null) {
            this._writeStream(nsmsg.getNetSignInputStream(), (OutputStream)out);
        }
    }

    protected byte[] readData(InputStream in, int len) throws IOException {
        byte[] allData = new byte[len];
        byte[] data = null;
        int rlen = len;
        while (rlen > 0) {
            data = rlen > 1024 ? new byte[1024] : new byte[rlen];
            int ilen = in.read(data);
            System.arraycopy(data, 0, allData, len - rlen, ilen);
            rlen -= ilen;
        }
        return allData;
    }

    public AbstractMessage read(DataInputStream in) throws IOException, ClassNotFoundException {
        int len = in.readInt();
        if (len < 0 || len > 0x32000000) {
            throw new IOException("Illegal length received :" + len);
        }
        byte[] allData = this.readData(in, len);
        NSMessage msg = this.generateMessage(allData);
        allData = null;
        if (msg.getPlainTextFile() != null || msg.getCryptoTextFile() != null) {
            msg.setNetSignInputStream(this._readStream(in));
        }
        return msg;
    }

    public static void main(String[] args) throws Exception {
        ByteRotator rotator = new ByteRotator();
        int i = 1;
        byte b = (byte)i;
        DataOutputStream out = new DataOutputStream(new FileOutputStream("D:/1.txt"));
        out.writeInt(i);
        out.write(Utils.generateBytes(i));
        out.writeByte(i);
        out.write("S".getBytes());
        out.write("B".getBytes());
        out.write("b".getBytes());
        out.writeBoolean(true);
        out.writeBoolean(false);
        out.close();
    }
}

