/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.communication.multiple;

import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.communication.multiple.ByteRotator;
import cn.com.infosec.netsign.communication.multiple.Rotator;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;

public class Byte2StringRotator
extends ByteRotator
implements Rotator {
    protected void _writeLength(int length, OutputStream out) throws IOException {
        String len_str = String.valueOf(length);
        String mode = "000000000000";
        byte[] len_b = len_str.getBytes();
        byte[] mode_b = mode.getBytes();
        int i = mode_b.length - len_b.length;
        int j = 0;
        while (i < 12) {
            mode_b[i] = len_b[j];
            ++i;
            ++j;
        }
        out.write(mode_b);
        len_b = null;
        mode_b = null;
    }

    protected void _writeResult(int result, DataOutputStream out) throws IOException {
        out.writeByte(4);
        out.writeByte(2);
        this._writeLength(String.valueOf(result).length(), out);
        out.write(String.valueOf(result).getBytes());
    }

    public void write(AbstractMessage msg, DataOutputStream out) throws IOException {
        byte[] data = this.generateBytes(2, "000000000000".getBytes(), msg);
        String length = String.valueOf(data.length - 13);
        byte[] lengthBs = length.getBytes();
        System.arraycopy(lengthBs, 0, data, 13 - lengthBs.length, lengthBs.length);
        out.write(data);
        ConsoleLogger.saveBinary((String)"/tmp/writed", (byte[])data);
        out.flush();
        data = null;
        NSMessage nsmsg = (NSMessage)msg;
        if (nsmsg.getPlainTextFile() != null || nsmsg.getCryptoTextFile() != null) {
            this._writeStream(nsmsg.getNetSignInputStream(), (OutputStream)out);
        }
        out.flush();
    }

    public AbstractMessage read(DataInputStream in) throws IOException, ClassNotFoundException {
        byte[] len_bs = new byte[12];
        int pos = 0;
        while (pos < 12) {
            int r = in.read(len_bs, pos, 12 - pos);
            if (r < 0) {
                throw new EOFException("read EOF,client close socket.");
            }
            pos += r;
        }
        int len = 0;
        try {
            len = Integer.parseInt(new String(len_bs, 0, 12));
        }
        catch (Exception e) {
            throw new IOException("read length failed,len=" + new String(len_bs, 1, 12));
        }
        if (len < 0 || len > 0x32000000) {
            throw new IOException("Illegal length received :" + len);
        }
        byte[] allData = new byte[len];
        int rlen = len;
        while (rlen > 0) {
            int l = in.read(allData, len - rlen, rlen);
            rlen -= l;
        }
        ConsoleLogger.saveReaded((String)"/tmp/readed", (byte[])allData, (byte[])len_bs, (byte)2);
        NSMessage msg = this.generateMessage(allData);
        allData = null;
        if (msg.getPlainTextFile() != null || msg.getCryptoTextFile() != null) {
            msg.setNetSignInputStream(this._readStream(in));
        }
        return msg;
    }

    protected int _readLen(int i, byte[] bytes) throws IOException {
        byte[] blen = new byte[12];
        System.arraycopy(bytes, i + 2, blen, 0, 12);
        int len = Integer.parseInt(new String(blen));
        if (len > bytes.length || len < 0) {
            throw new IOException("Illegal length received: " + len);
        }
        return len;
    }

    protected byte[] _readValue(int i, int len, byte[] bytes) {
        byte[] value = new byte[len];
        System.arraycopy(bytes, i + 14, value, 0, len);
        return value;
    }

    protected NSMessage generateMessage(byte[] bytes) throws IOException, ClassNotFoundException {
        NSMessageOpt msg = new NSMessageOpt();
        msg.setSize(bytes.length + 13);
        int i = 0;
        block64: while (i < bytes.length) {
            byte tag = bytes[i];
            int len = this._readLen(i, bytes);
            if (len < 0 || len > bytes.length) {
                throw new IOException("Error message length:" + len);
            }
            byte[] value = this._readValue(i, len, bytes);
            i += len + 14;
            switch (tag) {
                case 5: {
                    String errMsg = new String(value);
                    msg.setErrMsg(errMsg);
                    break;
                }
                case 4: {
                    String result = new String(value);
                    if (result == null || result.equals("")) continue block64;
                    msg.setResult(Integer.parseInt(result));
                    break;
                }
                case 1: {
                    String processor = new String(value);
                    msg.setProcessor(processor);
                    break;
                }
                case 2: {
                    String type = new String(value);
                    msg.setType(type);
                    break;
                }
                case 3: {
                    String clientId = new String(value);
                    msg.setClientId(clientId);
                    break;
                }
                case 6: {
                    byte commMode = value[0];
                    msg.setCommunicateMode(commMode);
                    break;
                }
                case 7: {
                    msg.setZipMode(value[0] != 0);
                    break;
                }
                case 8: {
                    msg.setEncKey(value);
                    break;
                }
                case 9: {
                    msg.setKeyHash(value);
                    break;
                }
                case 10: {
                    msg.setPlainText(value);
                    break;
                }
                case 11: {
                    msg.setCryptoText(value);
                    break;
                }
                case 16: {
                    msg.setEncCertDN(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 17: {
                    msg.setSignCertDN(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 18: {
                    String digestAlg = new String(value);
                    msg.setDigestAlg(digestAlg);
                    break;
                }
                case 20: {
                    msg.setSignSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 21: {
                    msg.setSignSerNumber(new String(value));
                    break;
                }
                case 22: {
                    msg.setSignIssuerSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 23: {
                    msg.setSignStartTime(new String(value));
                    break;
                }
                case 24: {
                    msg.setSignEndTime(new String(value));
                    break;
                }
                case 25: {
                    msg.setEncSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 26: {
                    msg.setEncSerNumber(new String(value));
                    break;
                }
                case 27: {
                    msg.setEncIssuerSubject(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 28: {
                    msg.setEncStartTime(new String(value));
                    break;
                }
                case 29: {
                    msg.setEncEndTime(new String(value));
                    break;
                }
                case 15: {
                    if (value[0] == 49) {
                        msg.setTransCert(true);
                        break;
                    }
                    msg.setTransCert(false);
                    break;
                }
                case 14: {
                    if (value.length == 0) break;
                    ByteArrayInputStream bain = new ByteArrayInputStream(value);
                    try {
                        CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bain);
                        msg.setCert(cert);
                    }
                    catch (Exception e) {
                        throw new IOException(e.toString());
                    }
                    bain.close();
                    break;
                }
                case 39: {
                    msg.setPDFVerifyResults(this.parsePDFVerifyResults(value));
                    break;
                }
                case 61: {
                    msg.setXmlVerifyResults(this.parseXMLVerifyResults(value));
                    break;
                }
                case 32: {
                    if (value.length == 0) break;
                    if (Utils.getPublicKeyType(value) == 99) {
                        try {
                            X509EncodedKeySpec kspe = new X509EncodedKeySpec(value);
                            KeyFactory kf = KeyFactory.getInstance("RSA", "INFOSEC");
                            msg.setPublicKey(kf.generatePublic(kspe));
                            break;
                        }
                        catch (Exception e) {
                            throw new IOException(e.toString());
                        }
                    }
                    msg.setPublicKey((PublicKey)new JCESM2PublicKey(value));
                    break;
                }
                case 19: {
                    String symmAlg = new String(value);
                    msg.setSymmetricalAlg(symmAlg);
                    break;
                }
                case 31: {
                    msg.setHashValue(value);
                    break;
                }
                case 40: {
                    msg.setPdfImages(this.parsePDFImages(value));
                    break;
                }
                case 44: {
                    msg.setBcHeight(Double.parseDouble(new String(value)));
                    break;
                }
                case 45: {
                    msg.setBcElementWidth(Double.parseDouble(new String(value)));
                    break;
                }
                case 46: {
                    msg.setBcDoQuietZone(value[0] != 0);
                    break;
                }
                case 47: {
                    msg.setBcQuietZoneWidth(Double.parseDouble(new String(value)));
                    break;
                }
                case 48: {
                    msg.setBcDisplayHumanReadable(value[0] != 0);
                    break;
                }
                case 49: {
                    msg.setBcDisplayHumanReadableStartStop(value[0] != 0);
                    break;
                }
                case 50: {
                    msg.setBcReturnFormat(Integer.parseInt(new String(value)));
                    break;
                }
                case 51: {
                    msg.setBcAddCheckSUM(value[0] != 0);
                    break;
                }
                case 52: {
                    msg.setBcWideFactor(Float.parseFloat(new String(value)));
                    break;
                }
                case 53: {
                    msg.setBcEncodingMode(Integer.parseInt(new String(value)));
                    break;
                }
                case 54: {
                    msg.setBcErrorCorrectingLevel(Integer.parseInt(new String(value)));
                    break;
                }
                case 55: {
                    msg.setBcAspectRatio(Float.parseFloat(new String(value)));
                    break;
                }
                case 56: {
                    msg.setBcYHeight(Float.parseFloat(new String(value)));
                    break;
                }
                case 57: {
                    msg.setBcBarSize(Integer.parseInt(new String(value)));
                    break;
                }
                case 58: {
                    msg.setBcSymbology(value);
                    break;
                }
                case 59: {
                    msg.setXmlSigID(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 60: {
                    msg.setXmlReferenceURI(this.newString(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 41: {
                    msg.setAPIPasswd(value);
                    break;
                }
                case 42: {
                    msg.setBankName(this.newString(value, "GBK"));
                    break;
                }
                case 43: {
                    msg.setBankID(new String(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 62: {
                    msg.setResourceName(new String(value, ExtendedConfig.getEncoding()));
                    break;
                }
                case 37: {
                    msg.setPdfpasswd(value);
                    break;
                }
                case 38: {
                    msg.setPDFSignatureRectangles(this.parsePDFSignParameters(value));
                    break;
                }
                case 12: {
                    msg.setTSAText(value);
                    break;
                }
                case 13: {
                    msg.setUsedTSA(value[0] != 0);
                    break;
                }
                case 30: {
                    msg.setTSAGenerateTime(new String(value));
                }
            }
        }
        return msg;
    }

    protected X509Certificate getCert(byte[] cert_bs) {
        X509Certificate cert = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert_bs));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cert;
    }
}

