/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.communication;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.communication.Communicator;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;

public class ObjectCommunicator
implements Communicator {
    private Socket socket = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;

    public ObjectCommunicator() {
    }

    private int recvLength() throws IOException {
        return this.in.readInt();
    }

    private byte[] recvBytes(int len) throws IOException {
        byte[] allData = new byte[len];
        byte[] data = null;
        int rlen = len;
        while (rlen > 0) {
            data = rlen > 1024 ? new byte[1024] : new byte[rlen];
            int ilen = this.in.read(data);
            System.arraycopy(data, 0, allData, len - rlen, ilen);
            rlen -= ilen;
        }
        return allData;
    }

    public ObjectCommunicator(Socket socket) {
        this.socket = socket;
        try {
            this.out = new DataOutputStream(socket.getOutputStream());
            this.in = new DataInputStream(socket.getInputStream());
        }
        catch (IOException ioEx) {
            ConsoleLogger.logException((Throwable)ioEx);
        }
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public boolean isClosed() {
        if (!this.socket.isConnected()) {
            return true;
        }
        return this.socket.isClosed();
    }

    public void send(AbstractMessage msg) throws IOException {
        byte[] bytes = null;
        ByteArrayOutputStream outByte = new ByteArrayOutputStream();
        ObjectOutputStream outObject = new ObjectOutputStream(outByte);
        try {
            outObject.writeObject(msg);
            outObject.flush();
            bytes = outByte.toByteArray();
        }
        finally {
            outObject.close();
        }
        this.out.writeInt(bytes.length);
        this.out.flush();
        this.out.write(bytes);
        this.out.flush();
    }

    public AbstractMessage recv() throws IOException, ClassNotFoundException {
        byte[] bytes = this.recvBytes(this.recvLength());
        ObjectInputStream inObject = new ObjectInputStream(new ByteArrayInputStream(bytes));
        AbstractMessage message = null;
        try {
            message = (AbstractMessage)inObject.readObject();
        }
        finally {
            inObject.close();
        }
        return message;
    }
}

