/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.x509.X509Extensions;
import cn.com.infosec.netcert.ocsp.client.OcspClient;
import cn.com.infosec.netcert.ocsp.client.OcspClientProperties;
import cn.com.infosec.netcert.ocsp.client.OcspPropertyException;
import cn.com.infosec.netcert.ocsp.client.OcspResponderInfo;
import cn.com.infosec.netsign.base.CRLUpdater;
import cn.com.infosec.netsign.base.NetSignX509CRL;
import cn.com.infosec.netsign.base.channels.ChannelException;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.config.CRLConfig;
import cn.com.infosec.netsign.frame.config.ConfigManager;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.config.OCSPConfig;
import cn.com.infosec.netsign.frame.config.TrustField;
import cn.com.infosec.netsign.frame.util.ByteArray;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.SignatureCache;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class TrustConfig
implements Serializable {
    private String name;
    private String rootCertDN;
    private List rootCertList;
    private TrustOCSPConfig ocsp;
    private TrustCrlConfig crl;
    private OcspClient client = null;
    private CRLUpdater updater = null;
    public static final String CRL_LOAD_MODE_ALL = "all";
    public static final String CRL_LOAD_MODE_REALTIME = "realtime";
    private static final int VERIFY_CRL_OK = 0;
    private static final int VERIFY_CRL_REVOKED = 1;
    private static final int VERIFY_CRL_NO_CRL_FILE = 2;
    private static final int VERIFY_CRL_CRL_FILE_EXPIRED = 3;

    public TrustConfig(TrustField config) throws ChannelException {
        this.name = config.getName();
        this.rootCertList = new ArrayList();
        String certPath = ConfigManager.getTrustConfig().getPath();
        ArrayList certs = config.getCerts();
        if (certs == null || certs.size() == 0) {
            throw new ChannelException("No root cert found in TrustField: " + config.getName());
        }
        int i = 0;
        int size = certs.size();
        while (i < size) {
            String certFile = String.valueOf(certPath) + certs.get(i);
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509", "INFOSEC");
                X509Certificate cert = (X509Certificate)factory.generateCertificate(new FileInputStream(certFile));
                if (Utils.getCertType(cert) == 1) {
                    cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                }
                this.rootCertList.add(cert);
            }
            catch (Exception ex) {
                throw new ChannelException(ex);
            }
            ++i;
        }
        this.rootCertDN = ((X509Certificate)this.rootCertList.get(0)).getSubjectDN().toString();
        System.out.println("DN of trust field: " + this.rootCertDN);
        if (config.getOcspConfig() != null) {
            this.ocsp = new TrustOCSPConfig(config.getOcspConfig());
            try {
                OcspResponderInfo respInfo = new OcspResponderInfo((X509Certificate)this.rootCertList.get(0), this.ocsp.getOCSPCert(), this.ocsp.getIP(), this.ocsp.getPort());
                respInfo.setSM2ID(ExtendedConfig.getSM3OCSPPucid());
                respInfo.setProvider(ExtendedConfig.getVerifyProvider());
                OcspClientProperties props = new OcspClientProperties();
                props.addResponderInfo(respInfo);
                this.client = new OcspClient(props);
                this.client.setCertIssuer((X509Certificate)this.rootCertList.get(0));
            }
            catch (OcspPropertyException ocsppex) {
                throw new ChannelException(ocsppex);
            }
        }
        if (config.getCrlConfig() != null) {
            this.crl = new TrustCrlConfig(config.getCrlConfig());
        }
    }

    public void setCRLUpdater(CRLUpdater updater) {
        this.updater = updater;
    }

    public Map getCRLList() {
        if (this.crl != null) {
            return this.crl.getCrlList();
        }
        return null;
    }

    public String getCRLPath() {
        if (this.crl != null) {
            return this.crl.getCrlPath();
        }
        return null;
    }

    public int getCRLUpdateInterval() {
        return this.crl.getInterval();
    }

    public boolean useCRLDP() {
        return this.crl.dpFlag;
    }

    public boolean isCrlEnabled() {
        return this.crl != null;
    }

    public boolean isOCSPEnabled() {
        return this.ocsp != null;
    }

    public String getName() {
        return this.name;
    }

    public String getRootCertDN() {
        return this.rootCertDN;
    }

    public List getRootCertList() {
        return this.rootCertList;
    }

    public TrustOCSPConfig getOCSP() {
        return this.ocsp;
    }

    public TrustCrlConfig getCrl() {
        return this.crl;
    }

    private boolean verifyallcrls(X509Certificate cert, Map crls) {
        boolean bRevoked = false;
        if (crls == null) {
            return bRevoked;
        }
        Collection values = crls.values();
        if (values == null || values.size() == 0) {
            return bRevoked;
        }
        Object[] crlEm = values.toArray();
        NetSignX509CRL crl = null;
        int i = 0;
        while (i < crlEm.length) {
            crl = (NetSignX509CRL)crlEm[i];
            if (crl.isRevoked(cert)) {
                bRevoked = true;
                break;
            }
            ++i;
        }
        return bRevoked;
    }

    private boolean checkCertValidity(long notBefore, long notAfter) {
        if (ExtendedConfig.isCheckCertValidity()) {
            long now = System.currentTimeMillis() / 1000L;
            return notBefore <= now && notAfter >= now;
        }
        return true;
    }

    public void VerifyCert(X509Certificate signCert, byte[] tbs, boolean checkValidity, String provider, long notBefore, long notAfter) throws CertTrustException, CertValidateException {
        PublicKey publicKey;
        if (checkValidity && !this.checkCertValidity(notBefore, notAfter)) {
            throw new CertValidateException("From:" + signCert.getNotBefore() + " To:" + signCert.getNotAfter());
        }
        byte[] digest = new byte[]{};
        try {
            if (tbs == null) {
                tbs = signCert.getTBSCertificate();
            }
            if (ExtendedConfig.isCacheCert()) {
                MessageDigest md = MessageDigest.getInstance("SHA1", "INFOSEC");
                digest = md.digest(tbs);
            }
        }
        catch (Exception ex) {
            throw new CertTrustException(ex);
        }
        ByteArray digestArray = new ByteArray(digest);
        if (!(ExtendedConfig.isCacheCert() && SignatureCache.isSignatureCached(digestArray) || (publicKey = ((X509Certificate)this.rootCertList.get(0)).getPublicKey()) == null)) {
            try {
                String sigAlg = signCert.getSigAlgOID();
                if (publicKey instanceof SM2PublicKey) {
                    NetSignImpl.verifyCert(sigAlg, signCert.getTBSCertificate(), signCert.getSignature(), (SM2PublicKey)publicKey, Utils.getOSCCApucID(1, null));
                } else {
                    NetSignImpl.verifyCert(sigAlg, tbs, signCert.getSignature(), publicKey, provider);
                }
                if (ExtendedConfig.isCacheCert()) {
                    SignatureCache.registerSignature(digestArray, true);
                }
            }
            catch (Exception ex) {
                ConsoleLogger.logString((String)"next is exception..");
                ConsoleLogger.logException((Throwable)ex);
                throw new CertTrustException(ex);
            }
        }
    }

    public int VerifyCRL(X509Certificate signCert) {
        ArrayList crldp = null;
        int bRevoked = 0;
        if (this.crl.getDPFlag()) {
            try {
                crldp = CryptoUtil.getcrldp((byte[])signCert.getExtensionValue(X509Extensions.CRLDistributionPoints.getId()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (crldp == null || crldp.size() == 0) {
                return this.verifyallcrls(signCert, this.crl.getCrlList()) ? 1 : 0;
            }
            bRevoked = 0;
            int i = 0;
            int size = crldp.size();
            while (i < size) {
                NetSignX509CRL crl509 = this.updater.getCRL(String.valueOf(crldp.get(i).toString()) + ".crl");
                if (crl509 == null) {
                    if (this.crl.onNoCrldp.equals("no-pass")) {
                        bRevoked = 2;
                        break;
                    }
                } else {
                    if (this.crl.checkValidity && !crl509.checkValidity()) {
                        bRevoked = 3;
                        break;
                    }
                    if (crl509.isRevoked(signCert)) {
                        bRevoked = 1;
                        break;
                    }
                }
                ++i;
            }
        } else {
            return this.verifyallcrls(signCert, this.crl.getCrlList()) ? 1 : 0;
        }
        return bRevoked;
    }

    public void VerifyOCSP(X509Certificate signCert) throws VerifyOCSPException, CertRevokedException {
        int status;
        try {
            status = this.client.getCertStatus(signCert);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new VerifyOCSPException(ex);
        }
        if (status == 1) {
            throw new CertRevokedException("The SignCert Has Been Revoked");
        }
        if (status == 2) {
            throw new VerifyOCSPException(OcspClient.getStatusDesp((int)status));
        }
    }

    public void VerifyCert(PBCRAWCert cert, String provider) throws CertTrustException, CertValidateException {
        String sigAlg = cert.getCert().getSigAlgName();
        byte[] digest = cert.getDigest();
        ByteArray digestArray = new ByteArray(digest);
        if (!SignatureCache.isSignatureCached(digestArray)) {
            PublicKey publicKey = ((X509Certificate)this.rootCertList.get(0)).getPublicKey();
            if (publicKey != null) {
                try {
                    if (publicKey instanceof SM2PublicKey) {
                        NetSignImpl.verifyCert(sigAlg, cert.getCert().getTBSCertificate(), cert.getCert().getSignature(), (SM2PublicKey)publicKey, Utils.getOSCCApucID(1, null));
                    } else {
                        NetSignImpl.verifyCert(sigAlg, cert.getCert().getTBSCertificate(), cert.getCert().getSignature(), publicKey, provider);
                    }
                    SignatureCache.registerSignature(digestArray, true);
                }
                catch (Exception ex) {
                    ConsoleLogger.logException((Throwable)ex);
                    throw new CertTrustException(ex);
                }
            } else {
                throw new CertTrustException("PublicKey of root certificate not found");
            }
        }
    }

    private class TrustCrlConfig
    implements Serializable {
        private boolean enabled;
        private Map crlMap = ExtendedConfig.getCRLLoadMode().equals("realtime") ? new Hashtable() : new HashMap();
        private String crlPath;
        private boolean dpFlag;
        private int interval;
        private String onNoCrldp;
        private boolean checkValidity;

        public boolean isCheckValidity() {
            return this.checkValidity;
        }

        public void setCheckValidity(boolean checkValidity) {
            this.checkValidity = checkValidity;
        }

        public String getOnNoCrldp() {
            return this.onNoCrldp;
        }

        public void setOnNoCrldp(String onNoCrldp) {
            this.onNoCrldp = onNoCrldp;
        }

        TrustCrlConfig(CRLConfig config) {
            this.crlPath = config.getCrlDir();
            this.interval = config.getCrlDownloadInterval();
            this.dpFlag = config.isUseCrldp();
            this.onNoCrldp = config.getOnNoCrldp();
            this.checkValidity = config.getCheckValidity();
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public Map getCrlList() {
            return this.crlMap;
        }

        public void setCrlList(Map crlMap) {
            this.crlMap = crlMap;
        }

        public String getCrlPath() {
            return this.crlPath;
        }

        public boolean getDPFlag() {
            return this.dpFlag;
        }

        public int getInterval() {
            return this.interval;
        }
    }

    private class TrustOCSPConfig
    implements Serializable {
        private String ip;
        private int port;
        private X509Certificate ocspCert;

        TrustOCSPConfig(OCSPConfig oc) throws ChannelException {
            this.ip = oc.getIp();
            this.port = oc.getPort();
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509", "INFOSEC");
                this.ocspCert = (X509Certificate)factory.generateCertificate(new FileInputStream("cert/ocspcert/" + oc.getOcspCert()));
            }
            catch (Exception ex) {
                throw new ChannelException(ex);
            }
        }

        public String getIP() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public X509Certificate getOCSPCert() {
            return this.ocspCert;
        }
    }
}

