/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.ASN1OctetString;
import cn.com.infosec.asn1.ASN1Set;
import cn.com.infosec.asn1.DEREncodable;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROctetString;
import cn.com.infosec.asn1.cms.Attribute;
import cn.com.infosec.asn1.cms.ContentInfo;
import cn.com.infosec.asn1.cms.IssuerAndSerialNumber;
import cn.com.infosec.asn1.cms.SignedData;
import cn.com.infosec.asn1.cms.SignerInfo;
import cn.com.infosec.asn1.tsp.MessageImprint;
import cn.com.infosec.asn1.tsp.TSTInfo;
import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.asn1.x509.X509NameTokenizer;
import cn.com.infosec.netsign.base.util.DERUtil;
import cn.com.infosec.netsign.base.util.TsaIDs;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.exceptions.DERDecodeException;
import cn.com.infosec.netsign.exceptions.DEREncodeException;
import cn.com.infosec.netsign.exceptions.TsaTokenException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class TimeStampToken {
    private ASN1Set signers;
    private TSTInfo tstoken;
    private X509Certificate signerCert;
    private byte[] btoken;

    public TimeStampToken(byte[] btoken) throws TsaTokenException, DERDecodeException {
        ContentInfo token = ContentInfo.getInstance((Object)DERUtil.derDecode(btoken));
        if (!TsaIDs.signedData.getId().equals(token.getContentType().getId())) {
            throw new TsaTokenException(-100291);
        }
        SignedData signeddata = SignedData.getInstance((Object)token.getContent());
        ContentInfo encont = signeddata.getEncapContentInfo();
        if (!TsaIDs.id_ct_TSTInfo.equals((Object)encont.getContentType())) {
            throw new TsaTokenException(-100290);
        }
        this.btoken = btoken;
        byte[] encapBytes = ((DEROctetString)encont.getContent()).getOctets();
        DERObject tobj = DERUtil.derDecode(encapBytes);
        this.tstoken = TSTInfo.getInstance((Object)tobj);
        MessageImprint imp = this.tstoken.getMessageImprint();
        if (imp.getHashedMessage().length != TsaIDs.getHashByteSize(imp.getHashAlgorithm().getObjectId())) {
            throw new TsaTokenException(-100292);
        }
        this.signers = signeddata.getSignerInfos();
    }

    public byte[] getHashedMessage() {
        return this.tstoken.getMessageImprint().getHashedMessage();
    }

    public boolean verifySignature(String digAlg, String provider) throws TsaTokenException, NoSuchAlgorithmException, NoSuchProviderException {
        try {
            byte[] bsigneddata = DERUtil.readConstructedElementByIndex(this.btoken, 1, true);
            SignedData signedData = SignedData.getInstance((Object)DERUtil.derDecode(bsigneddata));
            byte[] derEncapContent = null;
            derEncapContent = DEROctetString.getInstance((Object)signedData.getEncapContentInfo().getContent()).getOctets();
            byte[] messageDigest = null;
            if (digAlg.equals("SM3")) {
                messageDigest = SM3.SM3Digest((byte[])derEncapContent);
            } else {
                MessageDigest md = null;
                md = provider != null && !"".equals(provider) ? MessageDigest.getInstance(digAlg, provider) : MessageDigest.getInstance(digAlg, "INFOSEC");
                messageDigest = md.digest(derEncapContent);
            }
            byte[] messageDigestInSingerInfo = this.getMessageDigest();
            if (!Arrays.equals(messageDigest, messageDigestInSingerInfo)) {
                throw new TsaTokenException(-100297);
            }
            ASN1Set signedAttributes = this.getSignerInfo(this.signerCert).getAuthenticatedAttributes();
            byte[] message = DERUtil.derEncode(signedAttributes.getDERObject());
            return SoftCryptoImpl.verify((PublicKey)this.signerCert.getPublicKey(), (byte[])message, (byte[])this.getSignature(), (String)digAlg, (String)provider);
        }
        catch (CryptoException e) {
            throw new TsaTokenException(-100220);
        }
        catch (DEREncodeException e) {
            throw new TsaTokenException(-100293);
        }
        catch (DERDecodeException e) {
            throw new TsaTokenException(-100293);
        }
    }

    public byte[] getMessageDigest() throws TsaTokenException {
        SignerInfo signerInfo = this.getSignerInfo(this.signerCert);
        ASN1Set signerAttribute = signerInfo.getAuthenticatedAttributes();
        byte[] messageDigest = null;
        int i = 0;
        while (i < signerAttribute.size()) {
            Attribute signedAttribute = Attribute.getInstance((Object)signerAttribute.getObjectAt(i));
            if (signedAttribute.getAttrType().equals((Object)TsaIDs.id_messageDigest)) {
                DEREncodable msg = signedAttribute.getAttrValues().getObjectAt(0);
                ASN1OctetString msgo = DEROctetString.getInstance((Object)msg);
                messageDigest = msgo.getOctets();
            }
            ++i;
        }
        return messageDigest;
    }

    public String getSignDigestAlg() throws TsaTokenException {
        return TsaIDs.getAlgName(this.getSignerInfo(this.signerCert).getDigestAlgorithm().getObjectId());
    }

    public String getMessageHashAlg() {
        return TsaIDs.getAlgName(this.tstoken.getMessageImprint().getHashAlgorithm().getObjectId());
    }

    public String getSignEncryptAlg() throws TsaTokenException {
        return TsaIDs.getAlgName(this.getSignerInfo(this.signerCert).getDigestEncryptionAlgorithm().getObjectId());
    }

    public byte[] getSignature() throws TsaTokenException {
        return this.getSignerInfo(this.signerCert).getEncryptedDigest().getOctets();
    }

    public Date getGenTime() throws TsaTokenException {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssZ");
        try {
            return df.parse(this.tstoken.getGenTime().getTime());
        }
        catch (ParseException ex) {
            throw new TsaTokenException(-100295);
        }
    }

    public SignerInfo getSignerInfo(X509Certificate signerCert) throws TsaTokenException {
        if (this.signers.size() <= 0) {
            throw new TsaTokenException(-100294);
        }
        SignerInfo signer = null;
        IssuerAndSerialNumber isn = null;
        int i = 0;
        while (i < this.signers.size()) {
            signer = SignerInfo.getInstance((Object)this.signers.getObjectAt(i));
            isn = IssuerAndSerialNumber.getInstance((Object)signer.getSID().getId());
            if (TimeStampToken.compareX509Name(isn.getName(), signerCert.getIssuerDN()) && isn.getSerialNumber().getValue().equals(signerCert.getSerialNumber())) break;
            ++i;
        }
        if (i == this.signers.size()) {
            throw new TsaTokenException(-100294);
        }
        return signer;
    }

    public static boolean compareX509Name(X509Name dn1, Principal dn2) {
        return TimeStampToken.compareX509Name(dn1, new X509Name(dn2.toString()));
    }

    public static boolean compareX509Name(X509Name dn1, X509Name dn2) {
        if (dn1.equals((Object)dn2)) {
            return true;
        }
        Vector<String> rdns = new Vector<String>();
        X509NameTokenizer nt = new X509NameTokenizer(dn1.toString());
        while (nt.hasMoreTokens()) {
            rdns.add(nt.nextToken());
        }
        String[] s1 = rdns.toArray(new String[rdns.size()]);
        nt = new X509NameTokenizer(dn2.toString());
        rdns.clear();
        while (nt.hasMoreTokens()) {
            rdns.add(nt.nextToken());
        }
        String[] s2 = rdns.toArray(new String[rdns.size()]);
        if (s1.length != s2.length || s1.length == 0) {
            return false;
        }
        int len = s1.length;
        int i = 0;
        while (i < len) {
            boolean b = false;
            int j = 0;
            while (j < len) {
                if (s1[i].equals(s2[j])) {
                    b = true;
                    break;
                }
                ++j;
            }
            if (!b) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setSigners(ASN1Set signers) {
        this.signers = signers;
    }

    public ASN1Set getSigners() {
        return this.signers;
    }

    public void setTstoken(TSTInfo tstoken) {
        this.tstoken = tstoken;
    }

    public TSTInfo getTstoken() {
        return this.tstoken;
    }

    public void setBtoken(byte[] btoken) {
        this.btoken = btoken;
    }

    public byte[] getBtoken() {
        return this.btoken;
    }

    public void setSignerCert(X509Certificate signerCert) {
        this.signerCert = signerCert;
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }
}

