/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.bccms.BCCMSSignedDataGenerator;
import cn.com.infosec.bccms.BCCMSSignedDataParser;
import cn.com.infosec.bccms.InfosecCMSSignedData;
import cn.com.infosec.crypto.digests.SHA1Digest;
import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.base.NetSignCertPath;
import cn.com.infosec.netsign.base.NetSignCertPathBuilder;
import cn.com.infosec.netsign.base.util.CMSDigestVerifyException;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NotInTrustListException;
import cn.com.infosec.netsign.base.util.PKCS7SignedDataFX;
import cn.com.infosec.netsign.base.util.TimeStampToken;
import cn.com.infosec.netsign.base.util.TrustConfig;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.base.util.WeekAlgorithmUtil;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.HardCryptoImpl;
import cn.com.infosec.netsign.crypto.util.PKCS7EnvelopedData;
import cn.com.infosec.netsign.crypto.util.PKCS7HardEnvelopedData;
import cn.com.infosec.netsign.crypto.util.PKCS7HardSignedData;
import cn.com.infosec.netsign.crypto.util.SM3;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.crypto.weekalg.WeekAlgorithmException;
import cn.com.infosec.netsign.der.util.PKCS7SignedData;
import cn.com.infosec.netsign.der.util.PKCS7SignedDataParser;
import cn.com.infosec.netsign.exceptions.DERDecodeException;
import cn.com.infosec.netsign.exceptions.PlaintextStructureException;
import cn.com.infosec.netsign.exceptions.SignatureStructureException;
import cn.com.infosec.netsign.exceptions.TsaTokenException;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.frame.util.CertificateUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.oscca.OID;
import cn.com.infosec.oscca.OSCCAMessageDigest;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2Gear;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import cn.com.infosec.xmlparser.BinaryXMLParser;
import cn.com.infosec.xmlparser.BinaryXMLParserFactory;
import cn.com.infosec.xmlparser.XMLTag;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class NetSignImpl {
    public static final String MD5 = "MD5";
    public static final String MD2 = "MD2";
    public static final String SHA1 = "SHA1";
    private static HardCryptoImpl handler;
    public static final int TRIPLE_DES_CBC = 1;
    public static final int DES_CBC = 2;
    public static final int RC2_CBC = 3;
    public static final int RC4 = 4;
    public static final String PROVIDER_INFOSEC = "INFOSEC";
    public static final String PROVIDER_DATECH = "DatechCrypto";
    public static final String PROVIDER_SWXA = "SwxaJCE";
    public static final String PROVIDER_SWXA_ALG = "jce:SwxaJCE";
    private byte[] ContentData;
    private X509Certificate signCert;
    private X509Certificate encCert;
    private String TSAGenTime;
    private String[] certinfo;
    private String[] enccertinfo;
    private String digAlg = "";
    private String encAlg = "";
    private String p7Standard = null;
    private PKCS7EnvelopedData p7ed = null;
    private long signCertNotBefore;
    private long signCertNotAfter;
    private long encCertNotBefore;
    private long encCertNotAfter;
    private static HashMap signCatch;
    private static SM2Gear signGear;
    private static HashMap verifyCatch;
    private static SM2Gear verifyGear;

    static {
        Security.insertProviderAt((Provider)new InfosecProvider(), 100);
        handler = null;
        signCatch = new HashMap();
        signGear = new SM2Gear(ExtendedConfig.getSm2SignGear());
        verifyCatch = new HashMap();
        verifyGear = new SM2Gear(ExtendedConfig.getSm2VerifyGear());
    }

    public void setP7Standard(String standard) {
        this.p7Standard = standard;
    }

    public String getEncAlg() {
        return this.encAlg;
    }

    public static KeyPair generateDatechKeyPair(String keylable) throws Exception {
        SecureRandom secureRandom = SecureRandom.getInstance(keylable, PROVIDER_DATECH);
        KeyPairGenerator pg = KeyPairGenerator.getInstance("RSA", PROVIDER_DATECH);
        pg.initialize(1024, secureRandom);
        KeyPair kr = null;
        kr = pg.genKeyPair();
        return kr;
    }

    public byte[] hash1Base64(byte[] plaintext) throws IOException {
        SHA1Digest digest = new SHA1Digest();
        byte[] resbytes = new byte[digest.getDigestSize()];
        digest.update(plaintext, 0, plaintext.length);
        digest.doFinal(resbytes, 0);
        return Base64.encode((byte[])resbytes).getBytes();
    }

    public static void setHardCryptoHandler(HardCryptoImpl _handler) {
        handler = _handler;
    }

    public String[] getEncCertInfo() {
        return this.enccertinfo;
    }

    public String[] getSignCertInfo() {
        return this.certinfo;
    }

    public X509Certificate getSignCert() {
        return this.signCert;
    }

    private void getEncCerttmp() {
        this.enccertinfo = new String[5];
        this.enccertinfo[0] = this.encCert.getSubjectDN().getName();
        this.enccertinfo[1] = this.encCert.getIssuerDN().getName();
        this.encCertNotBefore = this.encCert.getNotBefore().getTime();
        this.encCertNotAfter = this.encCert.getNotAfter().getTime();
        this.enccertinfo[2] = new Date(this.encCertNotBefore).toString();
        this.enccertinfo[3] = new Date(this.encCertNotAfter).toString();
        this.enccertinfo[4] = this.encCert.getSerialNumber().toString(16).toUpperCase();
        this.encCertNotBefore /= 1000L;
        this.encCertNotAfter /= 1000L;
    }

    private void getSignCerttmp() {
        this.certinfo = new String[5];
        this.certinfo[0] = this.signCert.getSubjectDN().getName();
        this.certinfo[1] = this.signCert.getIssuerDN().getName();
        this.signCertNotBefore = this.signCert.getNotBefore().getTime() / 1000L;
        this.signCertNotAfter = this.signCert.getNotAfter().getTime() / 1000L;
        this.certinfo[2] = String.valueOf(this.signCertNotBefore);
        this.certinfo[3] = String.valueOf(this.signCertNotAfter);
        this.certinfo[4] = this.signCert.getSerialNumber().toString(16).toUpperCase();
    }

    public String getCertExtensionValue(String oid) {
        try {
            return CryptoUtil.getExtern((byte[])this.signCert.getExtensionValue(oid));
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    public String getSignCertInfo(int index) {
        return this.certinfo[index - 1];
    }

    public String getEncCertInfo(int index) {
        return this.enccertinfo[index - 1];
    }

    public byte[] getContentData() {
        return this.ContentData;
    }

    public byte[] GenerateHardSignedMsg(byte[] PlainText, byte[] label, Certificate[] certChain, String DigestAlg, boolean DetachedMode) throws CryptoException, InvalidParameterException, NoSuchAlgorithmException {
        byte[] signedData = null;
        if (PlainText == null || PlainText.length == 0) {
            throw new InvalidParameterException("The PlainText Is Null");
        }
        PKCS7HardSignedData p7hsd = new PKCS7HardSignedData(label, certChain, DigestAlg, "RSA");
        PKCS7HardSignedData.SetCryptoHandler((HardCryptoImpl)handler);
        p7hsd.update(PlainText);
        signedData = !DetachedMode ? p7hsd.getEncoded(PlainText) : p7hsd.getEncoded();
        return signedData;
    }

    public byte[] GenerateSingleSignedMsg(byte[] PlainText, PrivateKey priKey, X509Certificate[] certChain, DERObject[] certChainEncoded, Hashtable isAndsns, String DigestAlg, boolean DetachedMode, String provider, boolean usingQ7) throws InvalidParameterException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, WeekAlgorithmException {
        byte[] signedData = null;
        if (PlainText == null || PlainText.length == 0) {
            throw new InvalidParameterException("The PlainText Is NULL");
        }
        WeekAlgorithmUtil.isWeekAlg4Sign(priKey, DigestAlg);
        cn.com.infosec.netsign.crypto.util.PKCS7SignedData p7sd = new cn.com.infosec.netsign.crypto.util.PKCS7SignedData(priKey, (Certificate[])certChain, certChainEncoded, isAndsns, DigestAlg, provider);
        p7sd.setUsingQ7(usingQ7);
        p7sd.update(PlainText, 0, PlainText.length);
        signedData = !DetachedMode ? p7sd.getEncoded(PlainText, this.p7Standard) : p7sd.getEncoded(null, this.p7Standard);
        return signedData;
    }

    public byte[] GenerateCMSSingleSignedMsg(byte[] PlainText, PrivateKey priKey, X509Certificate signCert, String DigestAlg, boolean DetachedMode, String provider) throws InvalidParameterException, SignatureException, WeekAlgorithmException {
        byte[] signedData = null;
        if (PlainText == null || PlainText.length == 0) {
            throw new InvalidParameterException("The PlainText Is NULL");
        }
        WeekAlgorithmUtil.isWeekAlg4Sign(priKey, DigestAlg);
        try {
            return BCCMSSignedDataGenerator.generateCMSSignedData((byte[])PlainText, (PrivateKey)priKey, (X509Certificate)signCert, (String)DigestAlg, (boolean)DetachedMode, (String)provider);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new SignatureException(e.toString());
        }
    }

    public byte[] GenerateSingleSignedMsg(byte[] PlainText, SM2PrivateKey priKey, SM2Certificate cert, DERObject[] certChainEncoded, Hashtable isAndsns, String DigestAlg, boolean DetachedMode, boolean usingQ7) throws InvalidParameterException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, WeekAlgorithmException {
        byte[] signedData = null;
        if (PlainText == null || PlainText.length == 0) {
            throw new InvalidParameterException("The PlainText Is NULL");
        }
        WeekAlgorithmUtil.isWeekAlg4Sign((PrivateKey)priKey, DigestAlg);
        cn.com.infosec.netsign.crypto.util.PKCS7SignedData p7sd = new cn.com.infosec.netsign.crypto.util.PKCS7SignedData(priKey, DigestAlg, cert, certChainEncoded, isAndsns, Utils.getOSCCApucID(2, null));
        p7sd.setUsingQ7(usingQ7);
        p7sd.update(PlainText, 0, PlainText.length);
        signedData = !DetachedMode ? p7sd.getEncoded(PlainText, this.p7Standard) : p7sd.getEncoded(null, this.p7Standard);
        return signedData;
    }

    public byte[] GenerateSM2CMSSingleSignedMsg(byte[] PlainText, SM2PrivateKey priKey, SM2Certificate cert, String DigestAlg, boolean DetachedMode) throws InvalidParameterException, SignatureException, WeekAlgorithmException {
        if (PlainText == null || PlainText.length == 0) {
            throw new InvalidParameterException("The PlainText Is NULL");
        }
        WeekAlgorithmUtil.isWeekAlg4Sign((PrivateKey)priKey, DigestAlg);
        try {
            return BCCMSSignedDataGenerator.generateSM2CMSSignedData((byte[])PlainText, (SM2PrivateKey)priKey, (SM2Certificate)cert, (String)DigestAlg, (boolean)DetachedMode);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new SignatureException(e);
        }
    }

    public void verifyHardSignedMsg(byte[] SignedMsg, byte[] PlainText, Map Tcs, boolean checkValidity) throws InvalidParameterException, CryptoException, SecurityException, VerifySignatureException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new InvalidParameterException("The Signed Message Is NULL");
        }
        boolean isOK = false;
        PKCS7HardSignedData p7hard = new PKCS7HardSignedData(SignedMsg);
        PKCS7HardSignedData.SetCryptoHandler((HardCryptoImpl)handler);
        this.signCert = p7hard.getSigningCertificate();
        this.getSignCerttmp();
        TrustConfig tcg = (TrustConfig)Tcs.get(this.signCert.getIssuerDN().getName());
        if (tcg != null) {
            tcg.VerifyCert(this.signCert, null, checkValidity, PROVIDER_INFOSEC, this.signCertNotBefore, this.signCertNotAfter);
            if (tcg.isOCSPEnabled()) {
                tcg.VerifyOCSP(this.signCert);
            } else if (tcg.isCrlEnabled()) {
                NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(this.signCert));
            }
        } else {
            Certificate[] allCerts = p7hard.getCertificates();
            if (allCerts == null || allCerts.length < 2) {
                throw new CertTrustException("Not In Trust List");
            }
            this.verifyCert(this.signCert, allCerts, Tcs, checkValidity);
        }
        p7hard.updateContent(PlainText);
        isOK = p7hard.verify();
        if (!isOK) {
            throw new VerifySignatureException("signature was not verified ");
        }
    }

    public static void checkCrlVerifyResult(int type) throws CertRevokedException {
        switch (type) {
            case 1: {
                throw new CertRevokedException("The SignCert has been revoked");
            }
            case 2: {
                throw new CertRevokedException("The CRL file not found");
            }
            case 3: {
                throw new CertRevokedException("The CRL file has bean expired");
            }
        }
    }

    public void verifyHardSignedMsg(byte[] SignedMsg, Map Tcs, boolean checkValidity) throws InvalidParameterException, CryptoException, SecurityException, VerifySignatureException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new InvalidParameterException("The Signed Message Is NULL");
        }
        boolean isOK = false;
        PKCS7HardSignedData p7hard = new PKCS7HardSignedData(SignedMsg);
        PKCS7HardSignedData.SetCryptoHandler((HardCryptoImpl)handler);
        this.digAlg = p7hard.getDigAlg();
        this.signCert = p7hard.getSigningCertificate();
        this.getSignCerttmp();
        TrustConfig tcg = (TrustConfig)Tcs.get(this.signCert.getIssuerDN().getName());
        if (tcg != null) {
            tcg.VerifyCert(this.signCert, null, checkValidity, PROVIDER_INFOSEC, this.signCertNotBefore, this.signCertNotAfter);
            if (tcg.isOCSPEnabled()) {
                tcg.VerifyOCSP(this.signCert);
            } else if (tcg.isCrlEnabled()) {
                NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(this.signCert));
            }
        } else {
            Certificate[] allCerts = p7hard.getCertificates();
            if (allCerts == null || allCerts.length < 2) {
                throw new CertTrustException("Not In Trust List");
            }
            this.verifyCert(this.signCert, allCerts, Tcs, checkValidity);
        }
        isOK = p7hard.verify();
        if (!isOK) {
            throw new VerifySignatureException("signature was not verified ");
        }
        this.ContentData = p7hard.getContentData();
    }

    public void VerifySingleSignedMsg(byte[] SignedMsg, byte[] PlainText, Map Tcs, String provider, String digestAlg, boolean checkValidity, boolean verifyCert) throws InvalidParameterException, SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, SignatureException, VerifySignatureException, NotInTrustListException, CMSDigestVerifyException, WeekAlgorithmException {
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new InvalidParameterException("The Signed Message Is NULL");
        }
        if ((SignedMsg[1] & 0xFF) != 128) {
            if (ExtendedConfig.p7VerifySupportAuthAttrs() && this.p7Standard == null) {
                this.verifyP7SupportAuthAttrs(SignedMsg, PlainText, Tcs, provider, digestAlg, checkValidity, verifyCert);
            } else {
                this.verifyP7UnsupportAuthAttrs(SignedMsg, PlainText, Tcs, provider, digestAlg, checkValidity, verifyCert);
            }
        } else {
            this.verifyCMSSignedData(SignedMsg, PlainText, Tcs, provider, digestAlg, checkValidity, verifyCert, false);
        }
    }

    public void VerifyTSASingleSignedMsg(byte[] SignedMsg, byte[] TSATextDigest, Map Tcs, String provider, boolean checkValidity, boolean verifyCert) throws Exception {
        long gentime;
        TimeStampToken timeStamp;
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new TsaTokenException(-100219);
        }
        PKCS7SignedData p7 = null;
        byte[] tbs = null;
        try {
            p7 = PKCS7SignedDataParser.parse((byte[])SignedMsg, (String)provider);
            this.signCert = p7.getSignCert();
            if (this.signCert == null) {
                throw new SecurityException("No certificate in PKCS7 msg of stamptoken.");
            }
            this.getSignCerttmp();
            tbs = this.signCert.getTBSCertificate();
        }
        catch (Exception e) {
            throw new SecurityException("Not a well formed PKCS7 msg of stamptoken.", e);
        }
        try {
            timeStamp = new TimeStampToken(SignedMsg);
        }
        catch (DERDecodeException e) {
            throw new TsaTokenException(-100293);
        }
        timeStamp.setSignerCert(this.signCert);
        if (verifyCert) {
            this.verifyTSASignerCert(this.signCert, tbs, p7.getCerts(), Tcs, provider, this.signCertNotBefore, this.signCertNotAfter, checkValidity);
        }
        this.digAlg = AlgorithmUtil.getDigestAlgNameByOId((String)p7.getDigestAlgOid());
        WeekAlgorithmUtil.isWeekAlg4Verify(this.signCert.getPublicKey(), this.digAlg);
        if (timeStamp.verifySignature(this.digAlg, provider)) {
            if (!Arrays.equals(TSATextDigest, timeStamp.getHashedMessage())) {
                throw new TsaTokenException(-100297);
            }
            Date genDate = timeStamp.getGenTime();
            gentime = genDate.getTime() / 1000L;
            if (gentime < this.signCertNotBefore || gentime > this.signCertNotAfter) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date tokenT = new Date(gentime * 1000L);
                Date tokenBef = new Date(this.signCertNotBefore * 1000L);
                Date tokenAft = new Date(this.signCertNotAfter * 1000L);
                String errorMessage = "Token generate time[ " + df.format(tokenT) + " ] not in cert's validity period [ " + df.format(tokenBef) + "," + df.format(tokenAft) + " ].";
                throw new TsaTokenException(-100296, errorMessage);
            }
        } else {
            throw new TsaTokenException(-100220);
        }
        this.TSAGenTime = Long.toString(gentime);
    }

    private void verifyP7SupportAuthAttrs(byte[] SignedMsg, byte[] PlainText, Map Tcs, String provider, String digestAlg, boolean checkValidity, boolean verifyCert) throws InvalidParameterException, SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, SignatureException, VerifySignatureException, NotInTrustListException, CMSDigestVerifyException, WeekAlgorithmException {
        block18: {
            PKCS7SignedData p7 = null;
            byte[] tbs = null;
            try {
                p7 = PKCS7SignedDataParser.parse((byte[])SignedMsg, (String)provider);
                this.signCert = p7.getSignCert();
                this.getSignCerttmp();
                tbs = this.signCert.getTBSCertificate();
            }
            catch (Throwable e) {
                throw new SecurityException("Not a well formed PKCS7 msg", e);
            }
            this.digAlg = AlgorithmUtil.getDigestAlgNameByOId((String)p7.getDigestAlgOid());
            if (digestAlg != null && !this.digAlg.startsWith(digestAlg)) {
                throw new SecurityException("The digest algoritm is not match, " + this.digAlg + " " + digestAlg);
            }
            WeekAlgorithmUtil.isWeekAlg4Verify(this.signCert.getPublicKey(), this.digAlg);
            if (verifyCert) {
                this.verifyCert(this.signCert, tbs, p7.getCerts(), Tcs, provider, this.signCertNotBefore, this.signCertNotAfter, checkValidity);
            }
            this.ContentData = PlainText;
            if (this.ContentData == null) {
                this.ContentData = p7.getContent();
            }
            if (this.ContentData == null || this.ContentData.length == 0) {
                throw new InvalidParameterException("The PlainText Is NULL");
            }
            byte[] authAttrs = p7.getAuthenticateAttributesData();
            if (authAttrs != null) {
                byte[] plainDigest = null;
                try {
                    if (this.digAlg.equals("SM3")) {
                        plainDigest = SM3.SM3Digest((byte[])this.ContentData);
                    } else {
                        MessageDigest md = null;
                        md = provider != null && !"".equals(provider) ? MessageDigest.getInstance(this.digAlg, provider) : MessageDigest.getInstance(this.digAlg, PROVIDER_INFOSEC);
                        plainDigest = md.digest(this.ContentData);
                    }
                }
                catch (Exception e) {
                    throw new VerifySignatureException(e);
                }
                byte[] attr = p7.getAuthenticateAttribute("1.2.840.113549.1.9.4");
                int digestLength = 0;
                digestLength = (attr[1] & 0xFF) <= 121 ? attr.length - 2 : attr.length - 3;
                byte[] messageDigest = new byte[digestLength];
                System.arraycopy(attr, attr.length - messageDigest.length, messageDigest, 0, messageDigest.length);
                if (!Arrays.equals(plainDigest, messageDigest)) {
                    throw new VerifySignatureException("Attribute message digest not match");
                }
                try {
                    authAttrs[0] = 49;
                    if (!SoftCryptoImpl.verify((PublicKey)this.signCert.getPublicKey(), (byte[])authAttrs, (byte[])p7.getSignature(), (String)this.digAlg, (String)provider)) {
                        throw new VerifySignatureException("Signature not verified");
                    }
                    break block18;
                }
                catch (Exception e) {
                    throw new VerifySignatureException(e);
                }
            }
            try {
                if (!SoftCryptoImpl.verify((PublicKey)this.signCert.getPublicKey(), (byte[])this.ContentData, (byte[])p7.getSignature(), (String)this.digAlg, (String)provider)) {
                    throw new VerifySignatureException("Signature not verified");
                }
            }
            catch (Exception e) {
                throw new VerifySignatureException(e);
            }
        }
    }

    private void verifyCert(X509Certificate cert, byte[] tbs, Certificate[] allCerts, Map Tcs, String provider, long signCertNotBefore, long signCertNotAfter, boolean checkValidity) throws CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        TrustConfig tcg = (TrustConfig)Tcs.get(this.certinfo[1]);
        if (tcg == null) {
            tcg = (TrustConfig)Tcs.get(CryptoUtil.trimDN((String)this.certinfo[1]));
        }
        if (tcg != null) {
            tcg.VerifyCert(this.signCert, tbs, checkValidity, provider, signCertNotBefore, signCertNotAfter);
            if (tcg.isOCSPEnabled()) {
                tcg.VerifyOCSP(this.signCert);
            } else if (tcg.isCrlEnabled()) {
                NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(this.signCert));
            }
        } else {
            if (allCerts == null || allCerts.length < 2) {
                throw new NotInTrustListException("Not in trust list:issuer:" + this.signCert.getIssuerDN().toString() + " subject:" + this.signCert.getSubjectDN().toString());
            }
            this.verifyCert(this.signCert, allCerts, Tcs, checkValidity);
        }
    }

    private void verifyTSASignerCert(X509Certificate cert, byte[] tbs, Certificate[] allCerts, Map Tcs, String provider, long signCertNotBefore, long signCertNotAfter, boolean checkValidity) throws CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        TrustConfig tcg = (TrustConfig)Tcs.get(this.certinfo[1]);
        if (tcg == null) {
            tcg = (TrustConfig)Tcs.get(CryptoUtil.trimDN((String)this.certinfo[1]));
        }
        if (tcg != null) {
            tcg.VerifyCert(this.signCert, tbs, checkValidity, provider, signCertNotBefore, signCertNotAfter);
        } else {
            if (allCerts == null || allCerts.length < 2) {
                throw new NotInTrustListException("Not in trust list:issuer:" + this.signCert.getIssuerDN().toString() + " subject:" + this.signCert.getSubjectDN().toString());
            }
            this.afterwardsVerifyCert(this.signCert, allCerts, Tcs);
        }
    }

    private void verifyP7UnsupportAuthAttrs(byte[] SignedMsg, byte[] PlainText, Map Tcs, String provider, String digestAlg, boolean checkValidity, boolean verifyCert) throws InvalidParameterException, SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, SignatureException, VerifySignatureException, NotInTrustListException, CMSDigestVerifyException, WeekAlgorithmException {
        PKCS7SignedDataFX p7sd;
        boolean isOK = false;
        try {
            p7sd = new PKCS7SignedDataFX(SignedMsg, provider, digestAlg, this.p7Standard);
        }
        catch (CRLException e) {
            throw new SecurityException(e);
        }
        catch (CertificateException e) {
            throw new SecurityException(e);
        }
        catch (Throwable e) {
            throw new SecurityException("Not a well formed PKCS7 msg", e);
        }
        WeekAlgorithmUtil.isWeekAlg4Verify(p7sd);
        this.signCert = p7sd.getSigningCertificate();
        this.digAlg = p7sd.getDigAlg();
        this.getSignCerttmp();
        if (verifyCert) {
            this.verifyCert(this.signCert, p7sd.getSignCertTBS(), p7sd.getCertificates(), Tcs, provider, this.signCertNotBefore, this.signCertNotAfter, checkValidity);
        }
        this.ContentData = PlainText;
        if (this.ContentData == null) {
            this.ContentData = p7sd.getContentData();
        }
        if (this.ContentData == null || this.ContentData.length == 0) {
            throw new InvalidParameterException("The PlainText Is NULL");
        }
        p7sd.update(this.ContentData, 0, this.ContentData.length);
        isOK = p7sd.verify();
        if (!isOK) {
            throw new VerifySignatureException("signature was not verified ");
        }
    }

    public void afterwardsVerifySingleSignedMsg(byte[] SignedMsg, byte[] PlainText, Map Tcs, String provider, String digestAlg) throws InvalidParameterException, SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertTrustException, CertValidateException, SignatureException, VerifySignatureException, NotInTrustListException, VerifyOCSPException, CertRevokedException, CMSDigestVerifyException, WeekAlgorithmException {
        if (SignedMsg == null || SignedMsg.length == 0) {
            throw new InvalidParameterException("The Signed Message Is NULL");
        }
        if ((SignedMsg[1] & 0xFF) != 128) {
            PKCS7SignedDataFX p7sd;
            boolean isOK = false;
            try {
                p7sd = new PKCS7SignedDataFX(SignedMsg, provider, digestAlg, this.p7Standard);
            }
            catch (CRLException e) {
                throw new SecurityException(e);
            }
            catch (CertificateException e) {
                throw new SecurityException(e);
            }
            if (PlainText == null) {
                PlainText = p7sd.getContentData();
            }
            this.ContentData = PlainText;
            if (PlainText == null || PlainText.length == 0) {
                throw new InvalidParameterException("The PlainText Is NULL");
            }
            this.signCert = p7sd.getSigningCertificate();
            this.digAlg = p7sd.getDigAlg();
            this.getSignCerttmp();
            TrustConfig tcg = (TrustConfig)Tcs.get(this.signCert.getIssuerDN().getName());
            if (tcg != null) {
                tcg.VerifyCert(this.signCert, p7sd.getSignCertTBS(), false, provider, this.signCertNotBefore, this.signCertNotAfter);
            } else {
                Certificate[] allCerts = p7sd.getCertificates();
                if (allCerts == null || allCerts.length < 2) {
                    throw new NotInTrustListException("Not in trust list:issuer:" + this.signCert.getIssuerDN().toString() + " subject:" + this.signCert.getSubjectDN().toString());
                }
                this.afterwardsVerifyCert(this.signCert, allCerts, Tcs);
            }
            p7sd.update(PlainText, 0, PlainText.length);
            isOK = p7sd.verify();
            if (!isOK) {
                throw new VerifySignatureException("signature was not verified ");
            }
        } else {
            this.verifyCMSSignedData(SignedMsg, PlainText, Tcs, provider, digestAlg, false, true, true);
        }
    }

    public void verifyCMSSignedData(byte[] SignedMsg, byte[] plainText, Map Tcs, String provider, String digestAlg, boolean checkValidity, boolean verifyCert, boolean isAfterwards) throws InvalidParameterException, SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, SignatureException, VerifySignatureException, NotInTrustListException, CMSDigestVerifyException, WeekAlgorithmException {
        block34: {
            byte[] tbs;
            InfosecCMSSignedData icsd = null;
            try {
                icsd = BCCMSSignedDataParser.parse((byte[])SignedMsg);
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
                throw new SecurityException("Not a well formed PKCS7 msg", e);
            }
            this.signCert = icsd.getSignCert();
            if (this.signCert == null) {
                throw new SecurityException("Signing certificate not found in the SignedData");
            }
            this.getSignCerttmp();
            byte[] tbsCert = null;
            try {
                tbsCert = this.signCert.getTBSCertificate();
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
                throw new SignatureException(e.toString());
            }
            this.ContentData = plainText;
            if (this.ContentData == null) {
                this.ContentData = icsd.getContent();
            }
            this.digAlg = icsd.getDigestAlg();
            String digAlgTmp = OID.getAlgrithmNameByOid((String)this.digAlg);
            if (digAlgTmp != null) {
                this.digAlg = digAlgTmp;
            } else {
                digAlgTmp = PKCS7SignedDataFX.getAlgName(this.digAlg);
                if (digAlgTmp == null) {
                    throw new NoSuchAlgorithmException("Unsupport digest algrithm:" + digAlgTmp);
                }
                this.digAlg = digAlgTmp;
            }
            if (digestAlg != null && !this.digAlg.startsWith(digestAlg)) {
                throw new SecurityException("The digest algoritm is not match, " + this.digAlg + " " + digestAlg);
            }
            if (!isAfterwards) {
                WeekAlgorithmUtil.isWeekAlg4Verify(icsd);
            }
            if (verifyCert) {
                TrustConfig tcg;
                if (isAfterwards) {
                    checkValidity = false;
                }
                if ((tcg = (TrustConfig)Tcs.get(this.certinfo[1])) != null) {
                    tcg.VerifyCert(this.signCert, tbsCert, checkValidity, provider, this.signCertNotBefore, this.signCertNotAfter);
                    if (!isAfterwards) {
                        if (tcg.isOCSPEnabled()) {
                            tcg.VerifyOCSP(this.signCert);
                        } else if (tcg.isCrlEnabled()) {
                            NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(this.signCert));
                        }
                    }
                } else {
                    Certificate[] allCerts = icsd.getCertChain();
                    if (allCerts == null || allCerts.length < 2) {
                        throw new NotInTrustListException("Not in trust list:issuer:" + this.signCert.getIssuerDN().toString() + " subject:" + this.signCert.getSubjectDN().toString());
                    }
                    if (!isAfterwards) {
                        this.verifyCert(this.signCert, allCerts, Tcs, checkValidity);
                    } else {
                        this.afterwardsVerifyCert(this.signCert, allCerts, Tcs);
                    }
                }
            }
            if ((tbs = icsd.getTbs()) != null) {
                if (!Arrays.equals(tbs, this.ContentData)) {
                    byte[] contentDigest = icsd.getContentDigest();
                    if (contentDigest == null) {
                        throw new SecurityException("Content digest not found in the SignedData");
                    }
                    byte[] digested = null;
                    if (this.digAlg.startsWith("SM3")) {
                        digested = OSCCAMessageDigest.SM3Digest(null, null, null, (byte[])this.ContentData);
                    } else {
                        MessageDigest md = MessageDigest.getInstance(this.digAlg, PROVIDER_INFOSEC);
                        digested = md.digest(this.ContentData);
                    }
                    if (!Arrays.equals(digested, contentDigest)) {
                        throw new CMSDigestVerifyException();
                    }
                }
            } else {
                tbs = this.ContentData;
            }
            byte[] signature = icsd.getSignature();
            if (this.signCert.getPublicKey() instanceof JCESM2PublicKey) {
                try {
                    boolean verified = SDFJNI.SM2VierifyWithExternalKey((byte[])tbs, (String)this.digAlg, (byte[])signature, (byte[])this.signCert.getPublicKey().getEncoded(), (byte[])ExtendedConfig.getSM3SignpucID());
                    if (!verified) {
                        throw new VerifySignatureException("Signature verify failed");
                    }
                    break block34;
                }
                catch (CryptoException e) {
                    throw new VerifySignatureException(e.toString());
                }
            }
            Signature sig = Signature.getInstance(String.valueOf(this.digAlg) + "withRSA", provider);
            sig.initVerify(this.signCert.getPublicKey());
            sig.update(tbs);
            if (!sig.verify(signature)) {
                throw new VerifySignatureException("Signature verify failed");
            }
        }
    }

    public void verifySingleSignedCert(X509Certificate cert, Certificate[] allCerts, Map tcs, boolean checkValidity) throws CertTrustException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        String issuerdn = cert.getIssuerDN().toString();
        TrustConfig tcg = (TrustConfig)tcs.get(issuerdn);
        if (tcg == null) {
            issuerdn = CertificateUtil.trimDN((String)issuerdn);
            tcg = (TrustConfig)tcs.get(issuerdn);
        }
        if (tcg == null) {
            tcg = (TrustConfig)tcs.get(CertificateUtil.turnDN((String)issuerdn));
        }
        if (tcg != null) {
            tcg.VerifyCert(cert, null, checkValidity, ExtendedConfig.getVerifyProvider(), cert.getNotBefore().getTime() / 1000L, cert.getNotAfter().getTime() / 1000L);
            if (tcg.isOCSPEnabled()) {
                tcg.VerifyOCSP(cert);
            } else if (tcg.isCrlEnabled()) {
                NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(cert));
            }
        } else {
            if (allCerts == null || allCerts.length < 2) {
                throw new NotInTrustListException("Not in trust list:issuer:" + cert.getIssuerDN().toString() + " subject:" + cert.getIssuerDN().toString());
            }
            this.signCert = cert;
            this.verifyCert(cert, allCerts, tcs, checkValidity);
        }
    }

    public void afterwardsVerifyCert(X509Certificate cert, Map tcs) throws CertTrustException, CertTrustException, NotInTrustListException, CertValidateException {
        String certname = CryptoUtil.trimDN((String)cert.getIssuerDN().getName());
        TrustConfig tcg = (TrustConfig)tcs.get(certname);
        if (tcg == null) {
            throw new NotInTrustListException("Not in trust list:issuer:" + cert.getIssuerDN().toString() + " subject:" + cert.getSubjectDN().toString());
        }
        tcg.VerifyCert(cert, null, false, PROVIDER_INFOSEC, cert.getNotBefore().getTime() / 1000L, cert.getNotAfter().getTime() / 1000L);
    }

    public byte[] composeSingleEnvelopedMsg(byte[] PlainText, X509Certificate enccert, String alg, String provider, PublicKey pubk) throws InvalidParameterException, NoSuchProviderException, NoSuchAlgorithmException, EncryptDataException, EncryptKeyException, WriteEnvDataException, WeekAlgorithmException {
        PKCS7EnvelopedData p7Env = new PKCS7EnvelopedData();
        if (enccert == null) {
            throw new InvalidParameterException("The EncCert Is NuLL");
        }
        if (PlainText == null) {
            throw new InvalidParameterException("The PlainText Is NuLL");
        }
        WeekAlgorithmUtil.isWeekAlg4Encrypt(enccert.getPublicKey(), alg);
        byte[] envdata = p7Env.encryptOptCache(PlainText, enccert, alg, provider, pubk);
        return envdata;
    }

    public byte[] decomposeSingleEnvelopedMsg(byte[] EnvelopedMsg, X509Certificate Cert, PrivateKey decprikey, String provider) throws InvalidParameterException, CertificateNotMatchException, DecryptKeyException, DecryptDataException, SecurityException, NoSuchAlgorithmException, WeekAlgorithmException {
        if (EnvelopedMsg == null || EnvelopedMsg.length == 0) {
            throw new InvalidParameterException("The Envelope Data Is NULL");
        }
        if (Cert == null) {
            throw new InvalidParameterException("The Cert  Is NULL");
        }
        this.encCert = Cert;
        this.getEncCerttmp();
        this.p7ed = new PKCS7EnvelopedData();
        byte[] decryData = null;
        decryData = this.p7ed.decryptOptCache(EnvelopedMsg, Cert, decprikey, provider);
        WeekAlgorithmUtil.isWeekAlg4Decrypt(decprikey, this.p7ed);
        this.ContentData = decryData;
        this.encAlg = this.p7ed.getEncAlg();
        return decryData;
    }

    public byte[] composeHardSingleEnvelopedMsg(byte[] PlainText, X509Certificate enccert, String alg) throws InvalidParameterException, WriteEnvDataException, CryptoException {
        PKCS7HardEnvelopedData p7Env = new PKCS7HardEnvelopedData();
        if (enccert == null) {
            throw new InvalidParameterException("The EncCert Is NuLL");
        }
        if (PlainText == null) {
            throw new InvalidParameterException("The PlainText Is NuLL");
        }
        byte[] envdata = p7Env.encrypt(PlainText, (Certificate)enccert, alg, handler);
        return envdata;
    }

    public byte[] decomposeHardSingleEnvelopedMsg(byte[] EnvelopedMsg, X509Certificate Cert, byte[] decprikeylabel) throws InvalidParameterException, CertificateNotMatchException, SecurityException, CryptoException, NoSuchAlgorithmException {
        if (EnvelopedMsg == null || EnvelopedMsg.length == 0) {
            throw new InvalidParameterException("The Envelope Data Is NULL");
        }
        if (Cert == null) {
            throw new InvalidParameterException("The Cert Data Is NULL");
        }
        this.encCert = Cert;
        this.getEncCerttmp();
        PKCS7HardEnvelopedData p7ed = new PKCS7HardEnvelopedData();
        byte[] decryData = p7ed.decrypt(decprikeylabel, EnvelopedMsg, (Certificate)Cert, handler);
        this.ContentData = decryData;
        this.encAlg = p7ed.getEncAlg();
        return decryData;
    }

    public void verifyCert(X509Certificate signCert, Certificate[] allCerts, Map trusts, boolean checkValidity) throws CertTrustException, CertValidateException, CertRevokedException, VerifyOCSPException, NotInTrustListException {
        if (!ExtendedConfig.isVerifyCertChain()) {
            throw new NotInTrustListException("The SignCert not in trust list issuer:" + signCert.getIssuerDN().toString());
        }
        this.checkValidity(signCert);
        X509Certificate[] certs = this.convertCertificate(allCerts, signCert);
        NetSignCertPath[] paths = NetSignCertPathBuilder.build(signCert, certs);
        String[] trustNames = trusts.keySet().toArray(new String[0]);
        boolean verified = false;
        boolean ismatch = false;
        int i = 0;
        int length1 = paths.length;
        while (i < length1) {
            NetSignCertPath path = paths[i];
            int j = 0;
            int length2 = path.size();
            while (j < length2) {
                block11: {
                    int[] result = path.mostCloseIssuer(trustNames, j);
                    if (result != null) {
                        ismatch = true;
                        NetSignCertPath subPath = path.subPath(0, result[1] + 1);
                        TrustConfig tc = (TrustConfig)trusts.get(trustNames[result[0]]);
                        X509Certificate root = (X509Certificate)tc.getRootCertList().get(0);
                        try {
                            subPath.verify(root.getPublicKey(), checkValidity);
                        }
                        catch (Exception e) {
                            ConsoleLogger.logString((String)e.toString());
                            break block11;
                        }
                        if (tc.isOCSPEnabled()) {
                            tc.VerifyOCSP(signCert);
                        } else if (tc.isCrlEnabled()) {
                            NetSignImpl.checkCrlVerifyResult(tc.VerifyCRL(signCert));
                        }
                        verified = true;
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!verified) {
            if (!ismatch) {
                throw new NotInTrustListException("The SignCert not in trust list");
            }
            throw new CertTrustException("The SignCert not verified");
        }
    }

    public void afterwardsVerifyCert(X509Certificate signCert, Certificate[] allCerts, Map trusts) throws CertTrustException, CertValidateException, NotInTrustListException {
        if (!ExtendedConfig.isVerifyCertChain()) {
            throw new NotInTrustListException("The SignCert not in trust list issuer:" + signCert.getIssuerDN().toString());
        }
        X509Certificate[] certs = this.convertCertificate(allCerts, signCert);
        NetSignCertPath[] paths = NetSignCertPathBuilder.build(signCert, certs);
        String[] trustNames = trusts.keySet().toArray(new String[0]);
        boolean verified = false;
        boolean ismatch = false;
        int i = 0;
        int length1 = paths.length;
        while (i < length1) {
            NetSignCertPath path = paths[i];
            int j = 0;
            int length2 = path.size();
            while (j < length2) {
                block12: {
                    int[] result = path.mostCloseIssuer(trustNames, j);
                    if (result != null) {
                        ismatch = true;
                        NetSignCertPath subPath = path.subPath(0, result[1] + 1);
                        TrustConfig tc = (TrustConfig)trusts.get(trustNames[result[0]]);
                        X509Certificate root = (X509Certificate)tc.getRootCertList().get(0);
                        PublicKey rootPubk = null;
                        try {
                            if (Utils.getCertType(root) == 1) {
                                SM2Certificate sm2cert = new SM2Certificate(root, root.getEncoded(), root.getTBSCertificate());
                                rootPubk = sm2cert.getPublicKey();
                            } else {
                                rootPubk = root.getPublicKey();
                            }
                        }
                        catch (Exception e) {
                            ConsoleLogger.logException((Throwable)e);
                        }
                        try {
                            subPath.verify(rootPubk, false);
                        }
                        catch (Exception e) {
                            ConsoleLogger.logString((String)e.toString());
                            break block12;
                        }
                        verified = true;
                        return;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (!verified) {
            if (!ismatch) {
                throw new NotInTrustListException("The SignCert not in trust list:" + signCert.getIssuerDN().toString());
            }
            throw new CertTrustException("The SignCert not verified");
        }
    }

    private void checkValidity(X509Certificate cert) throws CertValidateException {
        if (ExtendedConfig.isCheckCertValidity()) {
            try {
                cert.checkValidity();
            }
            catch (Exception e) {
                throw new CertValidateException("Certificate:" + cert.getSubjectDN().getName());
            }
        }
    }

    private X509Certificate[] convertCertificate(Certificate[] certs, X509Certificate signCert) {
        X509Certificate[] xcerts = null;
        if (certs == null || certs.length == 0) {
            xcerts = new X509Certificate[]{signCert};
        } else {
            xcerts = new X509Certificate[certs.length];
            int i = 0;
            int length = certs.length;
            while (i < length) {
                xcerts[i] = (X509Certificate)certs[i];
                ++i;
            }
        }
        certs = null;
        return xcerts;
    }

    public String getDigestAlg() {
        return this.digAlg;
    }

    public void verifyQLBKB(byte[] plaintext, byte[] signed, String digalg, PublicKey pubk, String provider) throws SignatureException, SignatureStructureException, PlaintextStructureException, NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", provider);
        c.init(2, pubk);
        byte[] dec = c.doFinal(signed);
        ConsoleLogger.logBinary((String)"QLBKB decrypted signaute", (byte[])dec);
        MessageDigest md = MessageDigest.getInstance(digalg, provider);
        int digLength = md.getDigestLength();
        if (dec.length < digLength * 2) {
            throw new SignatureStructureException("the signature did not contained two hashed datas");
        }
        byte[] digestAllInSig = new byte[digLength];
        System.arraycopy(dec, dec.length - digLength * 2, digestAllInSig, 0, digLength);
        ConsoleLogger.logBinary((String)"QLBKB digest 1 in signature", (byte[])digestAllInSig);
        byte[] digestViewInSig = new byte[digLength];
        System.arraycopy(dec, dec.length - digLength, digestViewInSig, 0, digLength);
        ConsoleLogger.logBinary((String)"QLBKB digest 2 in signature", (byte[])digestViewInSig);
        byte[] digestAll = md.digest(plaintext);
        ConsoleLogger.logBinary((String)"QLBKB digest of all xml data", (byte[])digestAll);
        if (!Arrays.equals(digestAllInSig, digestAll)) {
            throw new SignatureException("Digest 1 not matched");
        }
        byte[] view = null;
        try {
            view = this.getViewInQLBKB(plaintext);
            ConsoleLogger.logBinary((String)"QLBKB view data", (byte[])view);
            ConsoleLogger.logString((byte[])view);
            if (view.length == 0) {
                throw new SignatureStructureException("no attribute named \"name\" in the xml");
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new SignatureStructureException(e.toString());
        }
        byte[] digestView = md.digest(view);
        ConsoleLogger.logBinary((String)"QLBKB digest of view data", (byte[])digestView);
        if (!Arrays.equals(digestViewInSig, digestView)) {
            throw new SignatureException("Digest 2 not matched");
        }
    }

    private byte[] getViewInQLBKB(byte[] plaintext) {
        BinaryXMLParser parser = BinaryXMLParserFactory.getInstance((String)"Infosec");
        parser.setXML(plaintext);
        byte[] view = new byte[]{};
        XMLTag tag = null;
        String attributeName = "name";
        if (!ExtendedConfig.isKLBSignOuterFields() && !parser.moveto("<Fields>".getBytes())) {
            parser.setLocation(0);
        }
        while ((tag = parser.getStartElement("name=\"".getBytes())) != null) {
            byte[] valueOfAttr = tag.getAttributeValue(attributeName.getBytes());
            if (valueOfAttr == null) continue;
            int start = tag.end + 1;
            tag = parser.getEndElement(tag.name);
            int end = tag.start - 1;
            int viewstart = view.length;
            byte[] tmp = new byte[view.length + valueOfAttr.length + end - start + 1 + 2];
            System.arraycopy(view, 0, tmp, 0, view.length);
            System.arraycopy(valueOfAttr, 0, tmp, viewstart, valueOfAttr.length);
            System.arraycopy(plaintext, start, tmp, viewstart + valueOfAttr.length, end - start + 1);
            tmp[tmp.length - 2] = 13;
            tmp[tmp.length - 1] = 10;
            view = new byte[tmp.length];
            System.arraycopy(tmp, 0, view, 0, tmp.length);
        }
        if (view.length != 0) {
            byte[] tmp = new byte[view.length - 2];
            System.arraycopy(view, 0, tmp, 0, tmp.length);
            view = tmp;
        }
        return view;
    }

    public void verifyRAWCert(PBCRAWCert cert, Map tcs) throws CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        String certName = CryptoUtil.trimDN((String)cert.getIssuerDN());
        String turnName = CryptoUtil.turnDN((String)certName);
        TrustConfig tcg = null;
        tcg = (TrustConfig)tcs.get(certName);
        if (tcg == null) {
            tcg = (TrustConfig)tcs.get(turnName);
        }
        if (tcg == null) {
            throw new NotInTrustListException("Not In Trust List(" + certName + ")");
        }
        long now = System.currentTimeMillis();
        if (now < Long.parseLong(cert.getNotBefore()) || now > Long.parseLong(cert.getNotAfter())) {
            Date d = new Date();
            d.setTime(Long.parseLong(cert.getNotBefore()));
            String notBefore = d.toString();
            d.setTime(Long.parseLong(cert.getNotAfter()));
            String notAfter = d.toString();
            throw new CertValidateException("Notbefore " + notBefore + " notafter " + notAfter);
        }
        try {
            tcg.VerifyCert(cert, ExtendedConfig.getVerifyProvider());
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new CertTrustException("Cert verify failed ");
        }
        if (tcg.isOCSPEnabled()) {
            tcg.VerifyOCSP(cert.getCert());
        } else if (tcg.isCrlEnabled()) {
            NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(cert.getCert()));
        }
    }

    public void isRAWCertRevoked(PBCRAWCert cert, Map tcs) throws CertTrustException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        String certName = CryptoUtil.trimDN((String)cert.getIssuerDN());
        TrustConfig tcg = null;
        tcg = (TrustConfig)tcs.get(certName);
        String turnName = CryptoUtil.turnDN((String)certName);
        if (tcg == null) {
            tcg = (TrustConfig)tcs.get(turnName);
        }
        if (tcg == null) {
            throw new NotInTrustListException("Not In Trust List(" + certName + ")");
        }
        if (tcg.isOCSPEnabled()) {
            tcg.VerifyOCSP(cert.getCert());
        } else if (tcg.isCrlEnabled()) {
            NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(cert.getCert()));
        }
    }

    public void verifyRAWCertChain(PBCRAWCert cert, Map tcs) throws CertTrustException, NotInTrustListException, CertValidateException {
        String certName = CryptoUtil.trimDN((String)cert.getIssuerDN());
        String turnName = CryptoUtil.turnDN((String)certName);
        TrustConfig tcg = null;
        tcg = (TrustConfig)tcs.get(certName);
        if (tcg == null) {
            tcg = (TrustConfig)tcs.get(turnName);
        }
        if (tcg == null) {
            throw new NotInTrustListException("Not In Trust List(" + certName + ")");
        }
        try {
            tcg.VerifyCert(cert, ExtendedConfig.getVerifyProvider());
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new CertTrustException("Cert verify failed ");
        }
    }

    public static void verifyCert(String sigAlgName, byte[] tbs, byte[] sig, PublicKey pubKey, String provider) throws Exception {
        Signature sign = Signature.getInstance(sigAlgName, provider);
        sign.initVerify(pubKey);
        sign.update(tbs);
        if (!sign.verify(sig)) {
            throw new Exception("Verify sign cert error.");
        }
    }

    public static void verifyCert(String sigAlgName, byte[] tbs, byte[] sig, SM2PublicKey pubKey, byte[] id) throws Exception {
        String digestAlg = OID.getAlgrithmNameByOid((String)sigAlgName);
        if (digestAlg != null) {
            digestAlg = sigAlgName;
        }
        if (!SDFJNI.SM2VierifyWithExternalKey((byte[])tbs, (String)(digestAlg = digestAlg != null && digestAlg.indexOf("with") > 0 ? digestAlg.split("with")[0] : "SM3"), (byte[])sig, (SM2PublicKey)pubKey, (byte[])id)) {
            throw new Exception("Verify sign cert error.");
        }
    }

    public void setTSAGenTime(String tSAGenTime) {
        this.TSAGenTime = tSAGenTime;
    }

    public String getTSAGenTime() {
        return this.TSAGenTime;
    }
}

