/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.jce.provider.InfosecProvider;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.crypto.util.PKCS10CertificationRequest;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.datech.jce.provider.DatechCrypto;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;

public class GenDatechP10 {
    private static String generate(String subject, String keylable) {
        try {
            KeyPair kp = NetSignImpl.generateDatechKeyPair(keylable);
            X509Name dn = new X509Name(subject);
            PKCS10CertificationRequest p10reqest = new PKCS10CertificationRequest("SHA1withRSA", dn, kp.getPublic(), null, kp.getPrivate(), "DatechCrypto");
            return CryptoUtil.createbase64csr((PKCS10CertificationRequest)p10reqest);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
        Security.addProvider((Provider)new InfosecProvider());
        Security.addProvider((Provider)new DatechCrypto());
        String p10str = GenDatechP10.generate(args[0], args[1]);
        System.out.println(p10str);
    }
}

