/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.util;

import cn.com.infosec.asn1.DERInputStream;
import cn.com.infosec.asn1.DERObject;
import cn.com.infosec.asn1.DEROutputStream;
import cn.com.infosec.netsign.base.util.DERBytes;
import cn.com.infosec.netsign.exceptions.DERDecodeException;
import cn.com.infosec.netsign.exceptions.DEREncodeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DERUtil {
    public static byte[] readConstructedElementByIndex(byte[] data, int index, boolean isexplicit) throws DERDecodeException {
        DERBytes dbs = new DERBytes(data, 0);
        int tag = dbs.getTag();
        if (!dbs.isConstructed()) {
            throw new DERDecodeException("not constructed ASN1 type");
        }
        return DERUtil.readOrderedElementByIndex(data, dbs.getContentOffset(), dbs.getContentLength(), index, isexplicit);
    }

    public static byte[] readOrderedElementByIndex(byte[] data, int offset, int length, int index, boolean isexplicit) throws DERDecodeException {
        if (offset >= data.length) {
            throw new DERDecodeException("bytes error");
        }
        DERBytes next = null;
        int n = offset;
        int len = offset + length <= data.length ? length : data.length - offset;
        int i = 0;
        while (i < index && len > 0) {
            next = new DERBytes(data, n);
            n += next.getLength();
            len -= next.getLength();
            ++i;
        }
        if (len <= 0) {
            throw new DERDecodeException("bytes error");
        }
        next = new DERBytes(data, n);
        byte[] bytes = null;
        if (!isexplicit) {
            bytes = new byte[next.getLength()];
            int i2 = 0;
            while (i2 < next.getLength()) {
                bytes[i2] = data[n + i2];
                ++i2;
            }
        } else {
            bytes = new byte[next.getContentLength()];
            int i3 = 0;
            while (i3 < next.getContentLength()) {
                bytes[i3] = data[next.getContentOffset() + i3];
                ++i3;
            }
        }
        return bytes;
    }

    public static DERObject derDecode(byte[] b) throws DERDecodeException {
        try {
            ByteArrayInputStream decodedBytes = new ByteArrayInputStream(b);
            DERInputStream in = new DERInputStream((InputStream)decodedBytes);
            return in.readObject();
        }
        catch (IOException ex) {
            throw new DERDecodeException(ex.getMessage());
        }
    }

    public static byte[] derEncode(DERObject obj) throws DEREncodeException {
        try {
            ByteArrayOutputStream encodedBytes = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream((OutputStream)encodedBytes);
            out.writeObject((Object)obj);
            return encodedBytes.toByteArray();
        }
        catch (IOException ex) {
            throw new DEREncodeException(obj.getClass().getName());
        }
    }
}

