/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors.util;

import cn.com.infosec.asn1.x509.X509Name;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.XMLVerifyResult;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.BinaryUtil;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.NotInTrustListException;
import cn.com.infosec.netsign.base.util.NotSignatrueXMLException;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.crypto.util.RadomNumber;
import cn.com.infosec.netsign.exceptions.GenerateXMLException;
import cn.com.infosec.netsign.exceptions.ParseXMLException;
import cn.com.infosec.netsign.exceptions.XMLCoreValidationException;
import cn.com.infosec.netsign.exceptions.XMLReferenceException;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.util.encoders.Base64;
import cn.com.infosec.xmlparser.BinaryXMLParser;
import cn.com.infosec.xmlparser.BinaryXMLParserFactory;
import cn.com.infosec.xmlparser.XMLTag;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xml.security.Init;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLSignatureUtil {
    private static XMLSignatureFactory fac = null;
    private static DocumentBuilderFactory dbf = null;
    private static final String regex = "(?su)<Signature[^>]*>\\s*<SignedInfo>\\s*<CanonicalizationMethod[^>]*>\\s*<SignatureMethod[^>]*>(<Reference (URI=)?[^>]*>\\s*(<Transforms>.*?</Transforms>)?\\s*<DigestMethod[^>]*>\\s*<DigestValue>.*?</DigestValue>\\s*</Reference>)+\\s*</SignedInfo>\\s*<SignatureValue>.*?</SignatureValue>\\s*(<KeyInfo>.*?</KeyInfo>\\s)?(<Object[^>]*>(<SignatureProperties>.*?</SignaturePropeies>)*(<Manifest>.*?</Manifest>)*.*?</Object>\\s*)*</Signature>";
    private static final String valid_regex = "(?su)<Signature[^>]*>\\s*<SignedInfo>\\s*<CanonicalizationMethod[^>]*>\\s*<SignatureMethod[^>]*>(<Reference (URI=)?[^>]*>\\s*(<Transforms>.*?</Transforms>)?\\s*<DigestMethod[^>]*>\\s*<DigestValue>.*?</DigestValue>\\s*</Reference>)+\\s*</SignedInfo>\\s*<SignatureValue>.*?</SignatureValue>\\s*(<KeyInfo>.*?</KeyInfo>\\s)?.*?</Signature>";
    private static EntityResolver er;

    static {
        fac = XMLSignatureFactory.getInstance("DOM");
        dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(false);
        dbf.setNamespaceAware(true);
        er = new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                ByteArrayInputStream in = new ByteArrayInputStream("<?xml version='1.0' encoding='utf-8'?>".getBytes());
                return new InputSource(in);
            }
        };
    }

    private static Document parseXML(byte[] xml, DocumentBuilder db) throws Exception {
        db.setEntityResolver(er);
        return db.parse(new ByteArrayInputStream(xml));
    }

    private static SignedInfo generateSignedInfo(XMLSignatureFactory fac, Reference ref) throws Exception {
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        return si;
    }

    private static KeyInfo generateKeyInfo(XMLSignatureFactory fac, String certDN, X509Certificate[] certs) {
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        ArrayList<Object> x509Content = new ArrayList<Object>();
        x509Content.add(certDN);
        int i = 0;
        while (i < certs.length) {
            x509Content.add(certs[i]);
            ++i;
        }
        X509Data x509d = kif.newX509Data(x509Content);
        return kif.newKeyInfo(Collections.singletonList(x509d));
    }

    private static byte[] processSignature(Document doc, String randstr, String certDN) throws GenerateXMLException, TransformerConfigurationException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(baos);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        try {
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new GenerateXMLException(e.toString());
        }
        byte[] aresult = baos.toByteArray();
        BinaryUtil util = new BinaryUtil();
        util.setXML(aresult);
        byte[] subName = ("<X509SubjectName>CN=" + randstr + "</X509SubjectName>").getBytes("UTF-8");
        byte[] finalResult = null;
        if (util.moveto(subName)) {
            byte[] exchange = ("<X509SubjectName>" + certDN + "</X509SubjectName>").getBytes("UTF-8");
            int start = util.getLocation();
            finalResult = new byte[aresult.length + (exchange.length - subName.length)];
            System.arraycopy(aresult, 0, finalResult, 0, start);
            System.arraycopy(exchange, 0, finalResult, start, exchange.length);
            System.arraycopy(aresult, start + subName.length, finalResult, start + exchange.length, aresult.length - start - subName.length);
        }
        if (finalResult == null) {
            finalResult = aresult;
        }
        return finalResult;
    }

    private static byte[] getSignatureXml(XMLSignature signature, DOMSignContext dsc, Document sdoc, String randstr, String certDN) throws Exception {
        try {
            signature.sign(dsc);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new SignatureException(e.toString());
        }
        return XMLSignatureUtil.processSignature(sdoc, randstr, certDN);
    }

    private static byte[] parseNS(byte[] xml) {
        byte[] result = null;
        BinaryXMLParser bp = BinaryXMLParserFactory.getInstance((String)"Infosec");
        bp.setXML(xml);
        XMLTag tag = null;
        byte[] oldattr = null;
        int start = 0;
        byte[] replacexml = "xmlns=\"http://www.infosec.com.cn/netsign/innerdata\"".getBytes();
        tag = bp.getStartElement("xmlns=\"".getBytes());
        if (tag != null) {
            String xns = tag.getAttributeValue("xmlns");
            if (!xns.equals("http://www.w3.org/2000/09/xmldsig#") && !xns.equals("http://www.infosec.com.cn/netsign/innerdata")) {
                oldattr = "xmlns=\"\"".getBytes();
                start = tag.end - oldattr.length;
            }
        } else {
            tag = bp.getStartElement("xmlns:".getBytes());
            if (tag != null) {
                String tmp = new String(xml);
                Pattern p = Pattern.compile("xmlns:.+=['\"].*?['\"]");
                Matcher m = p.matcher(tmp);
                if (m.find()) {
                    String str = m.group();
                    oldattr = str.getBytes();
                    if (!(str = str.contains("'") ? str.substring(str.indexOf("'") + 1, str.lastIndexOf("'")) : str.substring(str.indexOf("\"") + 1, str.lastIndexOf("\""))).equals("http://www.w3.org/2000/09/xmldsig#") && !str.equals("http://www.infosec.com.cn/netsign/innerdata")) {
                        start = tag.end - oldattr.length;
                    }
                }
            } else {
                String tmp = new String(xml);
                int x = tmp.indexOf("?>");
                start = x > 0 ? tmp.indexOf(">", x + 2) : tmp.indexOf(">");
                oldattr = ">".getBytes();
                replacexml = " xmlns=\"http://www.infosec.com.cn/netsign/innerdata\">".getBytes();
            }
        }
        if (start > 0 && oldattr != null) {
            result = new byte[xml.length + (replacexml.length - oldattr.length)];
            System.arraycopy(xml, 0, result, 0, start);
            System.arraycopy(replacexml, 0, result, start, replacexml.length);
            System.arraycopy(xml, start + oldattr.length, result, start + replacexml.length, xml.length - start - oldattr.length);
        }
        if (result == null) {
            return xml;
        }
        return result;
    }

    private static byte[] processEncoding(byte[] xml) {
        byte[] result = null;
        BinaryUtil butil = new BinaryUtil();
        butil.setXML(xml);
        byte[] title = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>".getBytes();
        if (butil.moveto("?>".getBytes())) {
            int endIndex = butil.getLocation() + "?>".getBytes().length;
            result = new byte[xml.length - endIndex + title.length];
            System.arraycopy(title, 0, result, 0, title.length);
            System.arraycopy(xml, endIndex, result, title.length, xml.length - endIndex);
        } else {
            result = new byte[xml.length + title.length];
            System.arraycopy(title, 0, result, 0, title.length);
            System.arraycopy(xml, 0, result, title.length, xml.length);
        }
        return result;
    }

    public static Object[] generateXmlEnvelopingSignature(byte[] xml, ServerKeyStore keyStore, String xmlSigID, AbstractMessage res) throws Exception {
        SignedInfo si;
        xml = XMLSignatureUtil.parseNS(xml);
        String certDN = keyStore.getCertDN();
        Document doc = null;
        DocumentBuilder db = null;
        byte[] signedXml = null;
        Object[] result = new Object[2];
        try {
            db = dbf.newDocumentBuilder();
            doc = XMLSignatureUtil.parseXML(xml, db);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ParseXMLException(e.toString());
        }
        DOMStructure content = new DOMStructure(doc.getDocumentElement());
        String objId = RadomNumber.getRandom();
        XMLObject obj = fac.newXMLObject(Collections.singletonList(content), objId, null, null);
        Reference ref = fac.newReference("#" + objId, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
        if (xmlSigID == null || xmlSigID.equals("")) {
            xmlSigID = RadomNumber.getRandom();
        }
        try {
            si = XMLSignatureUtil.generateSignedInfo(fac, ref);
        }
        catch (Exception e1) {
            ConsoleLogger.logException((Throwable)e1);
            throw new SignatureException(e1.toString());
        }
        String randstr = RadomNumber.getRandom();
        KeyInfo ki = XMLSignatureUtil.generateKeyInfo(fac, "CN=" + randstr, keyStore.getCertChain());
        XMLSignature signature = fac.newXMLSignature(si, ki, Collections.singletonList(obj), xmlSigID, null);
        Document sdoc = db.newDocument();
        DOMSignContext dsc = new DOMSignContext(keyStore.getPrivateKey(), (Node)sdoc);
        try {
            signedXml = XMLSignatureUtil.getSignatureXml(signature, dsc, sdoc, randstr, certDN);
            signedXml = XMLSignatureUtil.processEncoding(signedXml);
            result[0] = signedXml;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateXMLException(e.toString());
        }
        result[1] = xmlSigID;
        return result;
    }

    public static Object[] generateXmlEnvelopedSignature(byte[] xml, ServerKeyStore keyStore, String xmlSigID, AbstractMessage res, boolean hasCanonial) throws Exception {
        SignedInfo si;
        xml = XMLSignatureUtil.parseNS(xml);
        if (xmlSigID == null || xmlSigID.equals("")) {
            xmlSigID = RadomNumber.getRandom();
        }
        Object[] result = new Object[2];
        result[1] = xmlSigID;
        byte[] signedXml = null;
        DocumentBuilder db = null;
        Document doc = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = XMLSignatureUtil.parseXML(xml, db);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ParseXMLException(e.toString());
        }
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        Reference ref = fac.newReference("", fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(envelopedTransform), null, null);
        try {
            si = XMLSignatureUtil.generateSignedInfo(fac, ref);
        }
        catch (Exception e1) {
            ConsoleLogger.logException((Throwable)e1);
            throw new SignatureException(e1.toString());
        }
        String certDN = keyStore.getCertDN();
        String randstr = RadomNumber.getRandom();
        KeyInfo ki = XMLSignatureUtil.generateKeyInfo(fac, "CN=" + randstr, keyStore.getCertChain());
        XMLSignature signature = fac.newXMLSignature(si, ki, null, xmlSigID, null);
        DOMSignContext dsc = new DOMSignContext(keyStore.getPrivateKey(), (Node)doc.getDocumentElement());
        try {
            signedXml = XMLSignatureUtil.getSignatureXml(signature, dsc, doc, randstr, certDN);
            if (hasCanonial) {
                signedXml = XMLSignatureUtil.canonialXML(signedXml);
            }
            result[0] = signedXml;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateXMLException(e.toString());
        }
        return result;
    }

    public static Object[] generateXmlDetatchedSignature(byte[] xml, ServerKeyStore keyStore, String tbsID, String xmlSigID, AbstractMessage res, boolean hasCanonial) throws Exception {
        SignedInfo si;
        xml = XMLSignatureUtil.parseNS(xml);
        String certDN = keyStore.getCertDN();
        Document doc = null;
        Object[] result = new Object[2];
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = XMLSignatureUtil.parseXML(xml, db);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ParseXMLException(e.toString());
        }
        Element root = doc.getDocumentElement();
        String rootid = root.getAttribute("id");
        if (rootid != null && tbsID != null && rootid.equals(tbsID)) {
            throw new SignatureException("\u5206\u79bb\u7b7e\u540d\u4e0d\u80fd\u6307\u5b9a\u6839\u5143\u7d20");
        }
        byte[] signedXml = null;
        if (tbsID == null || tbsID.equals("")) {
            throw new XMLReferenceException();
        }
        Reference ref = fac.newReference("#" + tbsID, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
        if (xmlSigID == null || xmlSigID.equals("")) {
            xmlSigID = RadomNumber.getRandom();
        }
        try {
            si = XMLSignatureUtil.generateSignedInfo(fac, ref);
        }
        catch (Exception e1) {
            ConsoleLogger.logException((Throwable)e1);
            throw new SignatureException(e1.toString());
        }
        result[1] = xmlSigID;
        String randstr = RadomNumber.getRandom();
        KeyInfo ki = XMLSignatureUtil.generateKeyInfo(fac, "CN=" + randstr, keyStore.getCertChain());
        XMLSignature signature = fac.newXMLSignature(si, ki, null, xmlSigID, null);
        DOMSignContext dsc = new DOMSignContext(keyStore.getPrivateKey(), (Node)doc.getDocumentElement());
        try {
            signedXml = XMLSignatureUtil.getSignatureXml(signature, dsc, doc, randstr, certDN);
            if (hasCanonial) {
                signedXml = XMLSignatureUtil.canonialXML(signedXml);
            }
            result[0] = signedXml;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateXMLException(e.toString());
        }
        return result;
    }

    public static Object[] generateXmlDetatchedSignature(byte[] xml, ServerKeyStore keyStore, String[] tbsID, String xmlSigID, AbstractMessage res, boolean hasCanonial) throws Exception {
        SignedInfo si;
        xml = XMLSignatureUtil.parseNS(xml);
        String certDN = keyStore.getCertDN();
        Document doc = null;
        Object[] result = new Object[2];
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = XMLSignatureUtil.parseXML(xml, db);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ParseXMLException(e.toString());
        }
        Element root = doc.getDocumentElement();
        String rootid = root.getAttribute("id");
        if (rootid != null && tbsID != null && rootid.equals(tbsID)) {
            throw new SignatureException("\u5206\u79bb\u7b7e\u540d\u4e0d\u80fd\u6307\u5b9a\u6839\u5143\u7d20");
        }
        byte[] signedXml = null;
        if (tbsID == null || tbsID.length == 0) {
            throw new XMLReferenceException();
        }
        ArrayList<Reference> refLists = new ArrayList<Reference>();
        int i = 0;
        while (i < tbsID.length) {
            Reference ref = fac.newReference("#" + tbsID[i], fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            refLists.add(ref);
            ++i;
        }
        if (xmlSigID == null || xmlSigID.equals("")) {
            xmlSigID = RadomNumber.getRandom();
        }
        try {
            si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.synchronizedList(refLists));
        }
        catch (Exception e1) {
            ConsoleLogger.logException((Throwable)e1);
            throw new SignatureException(e1.toString());
        }
        result[1] = xmlSigID;
        String randstr = RadomNumber.getRandom();
        KeyInfo ki = XMLSignatureUtil.generateKeyInfo(fac, "CN=" + randstr, keyStore.getCertChain());
        XMLSignature signature = fac.newXMLSignature(si, ki, null, xmlSigID, null);
        DOMSignContext dsc = new DOMSignContext(keyStore.getPrivateKey(), (Node)doc.getDocumentElement());
        try {
            signedXml = XMLSignatureUtil.getSignatureXml(signature, dsc, doc, randstr, certDN);
            if (hasCanonial) {
                signedXml = XMLSignatureUtil.canonialXML(signedXml);
            }
            result[0] = signedXml;
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateXMLException(e.toString());
        }
        return result;
    }

    private static String nodeToString(Node element) {
        StreamResult result = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(element);
        result = new StreamResult(baos);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return new String(baos.toByteArray()).replaceAll("<\\?.*?\\?>", "").trim();
    }

    public static boolean checkByRegex(String originalText, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(originalText);
        return m.find();
    }

    public static Object[] generateAlipaySignature(byte[] xml, ServerKeyStore keyStore, String xmlSigID, AbstractMessage res) throws ParseXMLException, XMLReferenceException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, GenerateXMLException {
        String certDN = keyStore.getCertDN();
        Document doc = null;
        Object[] result = new Object[2];
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = XMLSignatureUtil.parseXML(xml, db);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ParseXMLException(e.toString());
        }
        byte[] signedXml = null;
        XMLSignature signature = null;
        NodeList nlist = doc.getElementsByTagName("Message");
        Transform envelopedTransform = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        int i = 0;
        while (i < nlist.getLength()) {
            boolean hasSig = false;
            Node node = nlist.item(i);
            Node subNode = null;
            NodeList subList = node.getChildNodes();
            int j = 0;
            while (j < subList.getLength()) {
                Node nn = subList.item(j);
                if (nn.getNodeType() == 1 && nn.getNodeName().equals("Signature") && XMLSignatureUtil.checkByRegex(XMLSignatureUtil.nodeToString(nn), regex)) {
                    subNode = null;
                    hasSig = true;
                    break;
                }
                if (nn.getNodeType() == 1 && !hasSig) {
                    subNode = nn;
                }
                ++j;
            }
            if (subNode != null && !hasSig) {
                String randstr = RadomNumber.getRandom();
                String refuri = XMLSignatureUtil.getAttributeValueByName(subNode, "id");
                Reference ref = fac.newReference("#" + refuri, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(envelopedTransform), null, null);
                SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
                signature = fac.newXMLSignature(si, null);
                DOMSignContext dsc = new DOMSignContext(keyStore.getPrivateKey(), node);
                try {
                    signedXml = XMLSignatureUtil.getSignatureXml(signature, dsc, doc, randstr, certDN);
                    result[0] = signedXml;
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                    throw new GenerateXMLException(e.toString());
                }
            }
            ++i;
        }
        if (result[0] == null) {
            result[0] = xml;
        }
        result[1] = xmlSigID;
        return result;
    }

    public static Object[] generateTenPaySignature(byte[] xml, ServerKeyStore keyStore, String tbsID, String xmlSigID) throws Exception {
        Document doc = null;
        Object[] result = new Object[2];
        DocumentBuilder db = null;
        byte[] signedXml = null;
        try {
            db = dbf.newDocumentBuilder();
            doc = XMLSignatureUtil.parseXML(xml, db);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new ParseXMLException(e.toString());
        }
        Element root = doc.getDocumentElement();
        String rootid = root.getAttribute("id");
        if (rootid != null && tbsID != null && rootid.equals(tbsID)) {
            throw new SignatureException("\u5206\u79bb\u7b7e\u540d\u4e0d\u80fd\u6307\u5b9a\u6839\u5143\u7d20");
        }
        Transform tran = fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        if (tbsID == null || tbsID.equals("")) {
            throw new XMLReferenceException();
        }
        Reference ref = fac.newReference("#" + tbsID, fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(tran), null, null);
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), Collections.singletonList(ref));
        if (xmlSigID == null || xmlSigID.equals("")) {
            xmlSigID = RadomNumber.getRandom();
        }
        result[1] = xmlSigID;
        XMLSignature signature = fac.newXMLSignature(si, null, null, xmlSigID, null);
        DOMSignContext dsc = new DOMSignContext(keyStore.getPrivateKey(), (Node)doc.getDocumentElement());
        signature.sign(dsc);
        Document tmp_doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Node sigNode = doc.getElementsByTagName("Signature").item(0);
        Node tmp_sig = tmp_doc.adoptNode(sigNode);
        Node ptNode = doc.getElementsByTagName("Message").item(0);
        Node tmp_pt = tmp_doc.adoptNode(ptNode);
        Element tmp_root = tmp_doc.createElement("Tenpay");
        tmp_pt.appendChild(tmp_sig);
        tmp_root.appendChild(tmp_pt);
        tmp_doc.appendChild(tmp_root);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DOMSource source = new DOMSource(tmp_doc);
        StreamResult sresult = new StreamResult(baos);
        TransformerFactory transFactory = TransformerFactory.newInstance();
        Transformer transformer = transFactory.newTransformer();
        try {
            transformer.transform(source, sresult);
        }
        catch (Exception e) {
            throw new GenerateXMLException(e.toString());
        }
        signedXml = baos.toByteArray();
        signedXml = XMLSignatureUtil.canonialXML(signedXml);
        result[0] = signedXml;
        return result;
    }

    private static byte[] canonialXML(byte[] xml) {
        Canonicalizer canon = null;
        Init.init();
        try {
            canon = Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            return canon.canonicalize(xml);
        }
        catch (Exception e) {
            return xml;
        }
    }

    private static String getAttributeValueByName(Node node, String attrName) {
        if (node.getNodeType() != 1) {
            return null;
        }
        NamedNodeMap nodeMap = node.getAttributes();
        int i = 0;
        while (i < nodeMap.getLength()) {
            Attr attribute = (Attr)nodeMap.item(i);
            if (attribute.getName().equals(attrName)) {
                return attribute.getValue();
            }
            ++i;
        }
        return null;
    }

    public static ArrayList alipayVerify(byte[] xml, ServerChannel channel, X509Certificate cert) throws SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException, CertTrustException, CertValidateException, VerifyOCSPException, CertRevokedException, NotInTrustListException {
        NetSignImpl simpl = new NetSignImpl();
        if (channel.getService().isVerifyCert()) {
            simpl.verifySingleSignedCert(cert, null, channel.getTrustConfigs(), channel.isCheckValidity());
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document inputxml = db.parse(new ByteArrayInputStream(xml));
        NodeList signatureList = inputxml.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        ArrayList<XMLVerifyResult> list = new ArrayList<XMLVerifyResult>();
        int i = 0;
        while (i < signatureList.getLength()) {
            Node sigNode = signatureList.item(i);
            XMLVerifyResult xmlvr = new XMLVerifyResult();
            xmlvr.setIssuerSubject(cert.getIssuerDN().toString());
            xmlvr.setSn(cert.getSerialNumber());
            xmlvr.setNotBefore(cert.getNotBefore().getTime());
            xmlvr.setNotAfter(cert.getNotAfter().getTime());
            xmlvr.setSubject(cert.getSubjectDN().toString());
            DOMValidateContext valContext = new DOMValidateContext(cert.getPublicKey(), sigNode);
            DOMStructure val = new DOMStructure(sigNode);
            XMLSignature signature = fac.unmarshalXMLSignature(val);
            List<Reference> refList = signature.getSignedInfo().getReferences();
            String[] refs = null;
            int j = 0;
            while (j < refList.size()) {
                refs = new String[refList.size()];
                Reference ref = refList.get(j);
                String uri = ref.getURI();
                if (uri.startsWith("#")) {
                    uri = uri.substring(1);
                }
                refs[j] = uri;
                ++j;
            }
            if (refs != null) {
                xmlvr.setReference(refs);
            }
            xmlvr.setSigId(signature.getId());
            boolean coreValidity = signature.validate(valContext);
            if (!coreValidity) {
                xmlvr.setReturnCode(-100263);
            }
            list.add(xmlvr);
            ++i;
        }
        return list;
    }

    public static ArrayList XMLSignatureVerify(byte[] xml, ServerChannel channel, String failedMsg, NSMessage res, NSMessage request, boolean isAfterwards, boolean needCert) throws SAXException, IOException, ParserConfigurationException, MarshalException, CertificateException, XMLSignatureException, NotSignatrueXMLException, NoSuchProviderException, SignatureException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (xml == null) {
            return null;
        }
        ArrayList<XMLVerifyResult> list = new ArrayList<XMLVerifyResult>();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(er);
        Document inputxml = db.parse(new ByteArrayInputStream(xml));
        NodeList signatureList = inputxml.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        Certificate[] certs = null;
        if (signatureList == null) {
            ConsoleLogger.logException((Throwable)new NotSignatrueXMLException());
            return list;
        }
        NetSignImpl simpl = new NetSignImpl();
        int i = 0;
        while (i < signatureList.getLength()) {
            Node sigNode = signatureList.item(i);
            if (XMLSignatureUtil.checkByRegex(XMLSignatureUtil.nodeToString(sigNode), valid_regex)) {
                ArrayList alist = new ArrayList();
                XMLVerifyResult xmlvr = new XMLVerifyResult();
                if ((alist = XMLSignatureUtil.getNodesByTagName(sigNode, "X509Certificate", alist)).size() == 0) {
                    ConsoleLogger.logException((Throwable)new CertificateException("there is no X509Certificate element"));
                }
                X509Certificate cert = null;
                String certString = null;
                String sigCertString = null;
                String tempcert = null;
                String certDN = null;
                String issureName = null;
                ArrayList certDNList = new ArrayList();
                certDNList = XMLSignatureUtil.getNodesByTagName(sigNode, "X509SubjectName", certDNList);
                certDN = ((Node)certDNList.get(0)).getTextContent();
                try {
                    if (alist.size() == 1) {
                        Node certNode = (Node)alist.get(0);
                        sigCertString = certString = certNode.getTextContent();
                        cert = XMLSignatureUtil.getCert(certString);
                        if (channel.getService().isVerifyCert()) {
                            if (isAfterwards) {
                                simpl.afterwardsVerifyCert(cert, channel.getTrustConfigs());
                            } else {
                                simpl.verifySingleSignedCert(cert, null, channel.getTrustConfigs(), channel.isCheckValidity());
                            }
                        }
                    } else if (alist.size() > 1) {
                        X509Certificate tcert;
                        Node cnode;
                        int j;
                        certs = new X509Certificate[alist.size()];
                        if (certDNList.size() > 0) {
                            j = 0;
                            while (j < alist.size()) {
                                cnode = (Node)alist.get(j);
                                certString = cnode.getTextContent();
                                certs[j] = tcert = XMLSignatureUtil.getCert(certString);
                                if (j == 0) {
                                    tempcert = certString;
                                }
                                if (cert == null && XMLSignatureUtil.equalsDN(tcert.getSubjectDN().getName(), ((Node)certDNList.get(0)).getTextContent())) {
                                    cert = tcert;
                                    sigCertString = certString;
                                }
                                ++j;
                            }
                        } else {
                            certDNList = XMLSignatureUtil.getNodesByTagName(sigNode, "X509IssuerName", certDNList);
                            issureName = ((Node)certDNList.get(0)).getTextContent();
                            if (certDNList.size() < 1) {
                                throw new XMLCoreValidationException();
                            }
                            j = 0;
                            while (j < alist.size()) {
                                cnode = (Node)alist.get(j);
                                certString = cnode.getTextContent();
                                tcert = XMLSignatureUtil.getCert(certString);
                                certs[j] = tcert;
                                if (cert == null && XMLSignatureUtil.equalsDN(tcert.getIssuerX500Principal().getName(), issureName)) {
                                    cert = tcert;
                                    sigCertString = certString;
                                }
                                ++j;
                            }
                        }
                        if (cert == null) {
                            cert = certs[0];
                            sigCertString = tempcert;
                        }
                        if (channel.getService().isVerifyCert()) {
                            if (isAfterwards) {
                                simpl.afterwardsVerifyCert(cert, channel.getTrustConfigs());
                            } else {
                                simpl.verifySingleSignedCert(cert, certs, channel.getTrustConfigs(), channel.isCheckValidity());
                            }
                        }
                    }
                    if (cert == null) {
                        ProcessUtil.throwDetailException(new CertificateException("There is no Certificate in verify file!"), res);
                    }
                    if (certDN != null && !XMLSignatureUtil.equalsDN(certDN, cert.getSubjectDN().toString())) {
                        xmlvr.setReturnCode(-100265);
                    } else if (issureName != null && !XMLSignatureUtil.equalsDN(cert.getIssuerDN().toString(), issureName)) {
                        xmlvr.setReturnCode(-100266);
                    }
                }
                catch (CertTrustException e) {
                    ProcessUtil.throwDetailException(e, res);
                }
                catch (CertValidateException e) {
                    ProcessUtil.throwDetailException(e, res);
                }
                catch (VerifyOCSPException e) {
                    ProcessUtil.throwDetailException(e, res);
                }
                catch (CertRevokedException e) {
                    ProcessUtil.throwDetailException(e, res);
                }
                catch (NotInTrustListException e) {
                    ProcessUtil.throwDetailException(e, res);
                }
                catch (XMLCoreValidationException e) {
                    ProcessUtil.throwDetailException(e, res);
                }
                if (needCert) {
                    xmlvr.setB64cert(sigCertString);
                }
                xmlvr.setIssuerSubject(cert.getIssuerDN().toString());
                xmlvr.setSn(cert.getSerialNumber());
                xmlvr.setNotBefore(cert.getNotBefore().getTime());
                xmlvr.setNotAfter(cert.getNotAfter().getTime());
                xmlvr.setSubject(cert.getSubjectDN().toString());
                Document tmpdoc = db.newDocument();
                if (signatureList.getLength() > 1) {
                    NodeList refNodeList = ((Element)sigNode).getElementsByTagName("Reference");
                    boolean isEnveloped = false;
                    int j = 0;
                    while (j < refNodeList.getLength()) {
                        Node tmp = refNodeList.item(j);
                        NamedNodeMap attrs = tmp.getAttributes();
                        int k = 0;
                        while (k < attrs.getLength()) {
                            Attr att = (Attr)attrs.item(k);
                            if (att.getName().equals("URI") && att.getValue().equals("")) {
                                isEnveloped = true;
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (isEnveloped) {
                        Node tmpSignNode;
                        tmpdoc = sigNode.cloneNode(true).getOwnerDocument();
                        sigNode = tmpSignNode = tmpdoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
                    }
                }
                DOMValidateContext valContext = new DOMValidateContext(cert.getPublicKey(), sigNode);
                XMLSignature signature = fac.unmarshalXMLSignature(valContext);
                List<Reference> refList = signature.getSignedInfo().getReferences();
                String[] refs = new String[refList.size()];
                int j = 0;
                while (j < refList.size()) {
                    Reference ref = refList.get(j);
                    String uri = ref.getURI();
                    if (!uri.startsWith("#") && !uri.equals("")) {
                        throw new XMLSignatureException("Unsupport reference uri out side this document");
                    }
                    if (uri.startsWith("#")) {
                        uri = uri.substring(1);
                    }
                    refs[j] = uri;
                    ++j;
                }
                xmlvr.setReference(refs);
                xmlvr.setSigId(signature.getId());
                if (res.getResult() < 0) {
                    xmlvr.setReturnCode(res.getResult());
                    res.setResult(1);
                    res.setErrMsg("");
                    list.add(xmlvr);
                } else {
                    Iterator<Reference> iter = signature.getSignedInfo().getReferences().iterator();
                    int errorsize = 0;
                    int j2 = 0;
                    while (iter.hasNext()) {
                        Reference tmpref = iter.next();
                        boolean refValid = tmpref.validate(valContext);
                        if (!refValid) {
                            errorsize = 1;
                            break;
                        }
                        ++j2;
                    }
                    if (errorsize > 0) {
                        xmlvr.setReturnCode(-100263);
                    } else {
                        boolean sv = signature.getSignatureValue().validate(valContext);
                        if (!sv) {
                            xmlvr.setReturnCode(-100263);
                        }
                    }
                    list.add(xmlvr);
                }
            }
            ++i;
        }
        return list;
    }

    private static void testXMLVerfy(byte[] xml) throws Exception {
        if (xml == null) {
            return;
        }
        ArrayList list = new ArrayList();
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(er);
        Document inputxml = db.parse(new ByteArrayInputStream(xml));
        NodeList signatureList = inputxml.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        X509Certificate[] certs = null;
        if (signatureList == null) {
            ConsoleLogger.logException((Throwable)new NotSignatrueXMLException());
            return;
        }
        NetSignImpl simpl = new NetSignImpl();
        int i = 0;
        while (i < signatureList.getLength()) {
            Node sigNode = signatureList.item(i);
            if (XMLSignatureUtil.checkByRegex(XMLSignatureUtil.nodeToString(sigNode), valid_regex)) {
                ArrayList alist = new ArrayList();
                XMLVerifyResult xmlvr = new XMLVerifyResult();
                if ((alist = XMLSignatureUtil.getNodesByTagName(sigNode, "X509Certificate", alist)).size() == 0) {
                    ConsoleLogger.logException((Throwable)new CertificateException("there is no X509Certificate element"));
                }
                X509Certificate cert = null;
                String certString = null;
                String sigCertString = null;
                String tempcert = null;
                String certDN = null;
                String issureName = null;
                ArrayList certDNList = new ArrayList();
                if ((certDNList = XMLSignatureUtil.getNodesByTagName(sigNode, "X509SubjectName", certDNList)).size() > 0) {
                    certDN = ((Node)certDNList.get(0)).getTextContent();
                }
                if (alist.size() == 1) {
                    Node certNode = (Node)alist.get(0);
                    sigCertString = certString = certNode.getTextContent();
                    cert = XMLSignatureUtil.getCert(certString);
                } else if (alist.size() > 1) {
                    X509Certificate tcert;
                    Node cnode;
                    int j;
                    certs = new X509Certificate[alist.size()];
                    if (certDNList.size() > 0) {
                        j = 0;
                        while (j < alist.size()) {
                            cnode = (Node)alist.get(j);
                            certString = cnode.getTextContent();
                            certs[j] = tcert = XMLSignatureUtil.getCert(certString);
                            if (j == 0) {
                                tempcert = certString;
                            }
                            if (cert == null && XMLSignatureUtil.equalsDN(tcert.getSubjectDN().getName(), ((Node)certDNList.get(0)).getTextContent())) {
                                cert = tcert;
                                sigCertString = certString;
                            }
                            ++j;
                        }
                    } else {
                        certDNList = XMLSignatureUtil.getNodesByTagName(sigNode, "X509IssuerName", certDNList);
                        issureName = ((Node)certDNList.get(0)).getTextContent();
                        if (certDNList.size() < 1) {
                            throw new XMLCoreValidationException();
                        }
                        j = 0;
                        while (j < alist.size()) {
                            cnode = (Node)alist.get(j);
                            certString = cnode.getTextContent();
                            certs[j] = tcert = XMLSignatureUtil.getCert(certString);
                            if (cert == null && XMLSignatureUtil.equalsDN(tcert.getIssuerX500Principal().getName(), issureName)) {
                                cert = tcert;
                                sigCertString = certString;
                            }
                            ++j;
                        }
                    }
                    if (cert == null) {
                        cert = certs[0];
                        sigCertString = tempcert;
                    }
                }
                if (cert == null) {
                    throw new CertificateException("There is no Certificate in verify file!");
                }
                if (certDN != null && !XMLSignatureUtil.equalsDN(certDN, cert.getSubjectDN().toString())) {
                    xmlvr.setReturnCode(-100265);
                } else if (issureName != null && !XMLSignatureUtil.equalsDN(cert.getIssuerDN().toString(), issureName)) {
                    xmlvr.setReturnCode(-100266);
                }
                xmlvr.setB64cert(sigCertString);
                xmlvr.setIssuerSubject(cert.getIssuerDN().toString());
                xmlvr.setSn(cert.getSerialNumber());
                xmlvr.setNotBefore(cert.getNotBefore().getTime());
                xmlvr.setNotAfter(cert.getNotAfter().getTime());
                xmlvr.setSubject(cert.getSubjectDN().toString());
                Document tmpdoc = db.newDocument();
                if (signatureList.getLength() > 1) {
                    NodeList refNodeList = ((Element)sigNode).getElementsByTagName("Reference");
                    boolean isEnveloped = false;
                    int j = 0;
                    while (j < refNodeList.getLength()) {
                        Node tmp = refNodeList.item(j);
                        NamedNodeMap attrs = tmp.getAttributes();
                        int k = 0;
                        while (k < attrs.getLength()) {
                            Attr att = (Attr)attrs.item(k);
                            if (att.getName().equals("URI") && att.getValue().equals("")) {
                                isEnveloped = true;
                                break;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    if (isEnveloped) {
                        Node tmpSignNode;
                        tmpdoc = sigNode.cloneNode(true).getOwnerDocument();
                        sigNode = tmpSignNode = tmpdoc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
                    }
                }
                DOMValidateContext valContext = new DOMValidateContext(cert.getPublicKey(), sigNode);
                XMLSignature signature = fac.unmarshalXMLSignature(valContext);
                List<Reference> refList = signature.getSignedInfo().getReferences();
                String[] refs = new String[refList.size()];
                int j = 0;
                while (j < refList.size()) {
                    Reference ref = refList.get(j);
                    String uri = ref.getURI();
                    if (!uri.startsWith("#") && !uri.equals("")) {
                        throw new XMLSignatureException("Unsupport reference uri out side this document");
                    }
                    if (uri.startsWith("#")) {
                        uri = uri.substring(1);
                    }
                    refs[j] = uri;
                    ++j;
                }
                xmlvr.setReference(refs);
                xmlvr.setSigId(signature.getId());
                Iterator<Reference> iter = signature.getSignedInfo().getReferences().iterator();
                int errorsize = 0;
                int j2 = 0;
                while (iter.hasNext()) {
                    Reference tmpref = iter.next();
                    boolean refValid = tmpref.validate(valContext);
                    if (!refValid) {
                        errorsize = 1;
                        break;
                    }
                    ++j2;
                }
                if (errorsize > 0) {
                    xmlvr.setReturnCode(-100263);
                } else {
                    boolean sv = signature.getSignatureValue().validate(valContext);
                    if (!sv) {
                        xmlvr.setReturnCode(-100263);
                    }
                }
            }
            ++i;
        }
        System.out.println("XMLSignatureUtil.testXMLVerfy()");
    }

    public static void main(String[] args) throws Exception {
        String path = "d:/sig1.xml";
        FileInputStream fis = new FileInputStream(path);
        byte[] bt = new byte[fis.available()];
        fis.read(bt);
        XMLSignatureUtil.testXMLVerfy(bt);
    }

    private static boolean equalsDN(String dn1, String dn2) {
        dn1 = dn1.trim();
        dn2 = dn2.trim();
        if (dn1.length() != dn2.length()) {
            return false;
        }
        if (dn1.equals(dn2)) {
            return true;
        }
        X509Name name1 = new X509Name(dn1);
        X509Name name2 = new X509Name(dn2);
        return name1.equals((Object)name2);
    }

    private static X509Certificate getCert(String certString) throws CertificateException, NoSuchProviderException {
        X509Certificate xt = null;
        if (certString != null) {
            byte[] certByte = Base64.decode((String)certString);
            ByteArrayInputStream bis = new ByteArrayInputStream(certByte);
            CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
            xt = (X509Certificate)cf.generateCertificate(bis);
        }
        return xt;
    }

    private static ArrayList getNodesByTagName(Node parentNode, String nodeName, ArrayList list) {
        if (parentNode.getNodeType() == 1 && parentNode.getNodeName().equals(nodeName)) {
            list.add(parentNode);
        }
        NodeList alist = parentNode.getChildNodes();
        int i = 0;
        while (i < alist.getLength()) {
            Node tmpNode = alist.item(i);
            list = XMLSignatureUtil.getNodesByTagName(tmpNode, nodeName, list);
            ++i;
        }
        return list;
    }

    public static byte[] getVarifyResult(List verList) {
        if (verList == null || verList.size() < 1) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("<XMLSigVerifyResults>");
        int i = 0;
        while (i < verList.size()) {
            sb.append("<Result>");
            XMLVerifyResult xr = (XMLVerifyResult)verList.get(i);
            sb.append("<returnCode>").append(xr.getReturnCode()).append("</returnCode>");
            sb.append("<SigId>").append(xr.getSigId() != null ? xr.getSigId() : "").append("</SigId>");
            sb.append("<ReferenceURIs>");
            String[] refs = xr.getReference();
            if (refs != null) {
                int j = 0;
                while (j < refs.length) {
                    sb.append("<URI>").append(refs[j]).append("</URI>");
                    ++j;
                }
            }
            sb.append("</ReferenceURIs>");
            sb.append("<X509Certificate>").append(xr.getB64cert()).append("</X509Certificate>");
            sb.append("<Subject>").append(xr.getSubject()).append("</Subject>");
            sb.append("<IssuerSubject>").append(xr.getIssuerSubject()).append("</IssuerSubject>");
            sb.append("<NotBefore>").append(xr.getNotBefore()).append("</NotBefore>");
            sb.append("<NotAfter>").append(xr.getNotAfter()).append("</NotAfter>");
            sb.append("<SerialNumber>").append(xr.getSn()).append("</SerialNumber>");
            sb.append("</Result>");
            ++i;
        }
        sb.append("</XMLSigVerifyResults>");
        return sb.toString().getBytes();
    }

    public static List getVerifyResults(byte[] xml) throws SAXException, IOException, ParserConfigurationException {
        Document inputxml = dbf.newDocumentBuilder().parse(new ByteArrayInputStream(xml));
        NodeList nlist = inputxml.getElementsByTagName("Result");
        ArrayList<XMLVerifyResult> list = new ArrayList<XMLVerifyResult>();
        int i = 0;
        while (i < nlist.getLength()) {
            Node node = nlist.item(i);
            NodeList tlist = node.getChildNodes();
            XMLVerifyResult xmlvr = new XMLVerifyResult();
            int j = 0;
            while (j < tlist.getLength()) {
                Node cnode = tlist.item(j);
                String nodeName = cnode.getNodeName();
                String content = cnode.getTextContent();
                if (nodeName.equals("returnCode")) {
                    xmlvr.setReturnCode(Integer.parseInt(content));
                } else if (nodeName.equals("SigId")) {
                    xmlvr.setSigId(content);
                } else if (nodeName.equals("X509Certificate")) {
                    xmlvr.setB64cert(content);
                } else if (nodeName.equals("Subject")) {
                    xmlvr.setSubject(content);
                } else if (nodeName.equals("IssuerSubject")) {
                    xmlvr.setIssuerSubject(content);
                } else if (nodeName.equals("NotBefore")) {
                    xmlvr.setNotBefore(Long.parseLong(content));
                } else if (nodeName.equals("NotAfter")) {
                    xmlvr.setNotAfter(Long.parseLong(content));
                } else if (nodeName.equals("SerialNumber")) {
                    xmlvr.setSn(BigInteger.valueOf(Long.parseLong(content)));
                } else if (nodeName.equals("ReferenceURIs")) {
                    NodeList rlist = cnode.getChildNodes();
                    String[] refs = new String[rlist.getLength()];
                    int k = 0;
                    while (k < rlist.getLength()) {
                        refs[k] = rlist.item(k).getTextContent();
                        ++k;
                    }
                    xmlvr.setReference(refs);
                }
                ++j;
            }
            list.add(xmlvr);
            ++i;
        }
        return list;
    }
}

