/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors.util;

import cn.com.infosec.jce.exception.CertificateNotMatchException;
import cn.com.infosec.jce.exception.DecryptDataException;
import cn.com.infosec.jce.exception.DecryptKeyException;
import cn.com.infosec.jce.exception.EncryptDataException;
import cn.com.infosec.jce.exception.EncryptKeyException;
import cn.com.infosec.jce.exception.WriteEnvDataException;
import cn.com.infosec.jce.provider.JCESM2PrivateKey;
import cn.com.infosec.jce.provider.JCESM2PublicKey;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.PDFRequest;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.CryptoUtil;
import cn.com.infosec.netsign.base.processors.util.GZipUtil;
import cn.com.infosec.netsign.base.util.CMSDigestVerifyException;
import cn.com.infosec.netsign.base.util.CRLFileExpiredException;
import cn.com.infosec.netsign.base.util.CRLFileNotFoundException;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.NotInTrustListException;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.crypto.exception.CryptoException;
import cn.com.infosec.netsign.crypto.weekalg.WeekAlgorithmException;
import cn.com.infosec.netsign.exceptions.AddImage2PDFException;
import cn.com.infosec.netsign.exceptions.GenerateBarCodeFailedException;
import cn.com.infosec.netsign.exceptions.GenerateXMLException;
import cn.com.infosec.netsign.exceptions.NotSignatureFileException;
import cn.com.infosec.netsign.exceptions.PDFPageNumberOutofRangeException;
import cn.com.infosec.netsign.exceptions.ParseXMLException;
import cn.com.infosec.netsign.exceptions.PlaintextStructureException;
import cn.com.infosec.netsign.exceptions.ReadPDFException;
import cn.com.infosec.netsign.exceptions.SignatureStructureException;
import cn.com.infosec.netsign.exceptions.TsaTokenException;
import cn.com.infosec.netsign.exceptions.XMLCoreValidationException;
import cn.com.infosec.netsign.exceptions.XMLReferenceException;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.logger.AbstractLogger;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceFilter;
import cn.com.infosec.netsign.resources.ResourceList;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.CertSYNResult;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.logger.SynLogger;
import cn.com.infosec.synfw.util.AuthMessageUtil;
import com.datech.jce.provider.hsmcsp.NoSuchPaddingException;
import com.itextpdf.text.DocumentException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import org.bouncycastle.cms.CMSException;

public class ProcessUtil {
    public static byte[] disassemble(byte[] message, boolean cryptoFlag, CryptoUtil cryptoUtil, NSMessage req, AbstractMessage res) {
        byte[] byteText = message;
        if (byteText == null) {
            res.setResult(-100208);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100208));
            return byteText;
        }
        if (req.getCommunicateMode() == 0) {
            if (!cryptoFlag) {
                res.setResult(-100206);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100206));
                return byteText;
            }
            byte[] key = null;
            byte[] encKey = req.getEncKey();
            if (encKey == null) {
                res.setResult(-100209);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100209));
                return byteText;
            }
            byte[] keyHash = req.getKeyHash();
            if (keyHash == null) {
                res.setResult(-100210);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100210));
                return byteText;
            }
            try {
                key = cryptoUtil.getkey(req.getAddress(), keyHash, encKey);
            }
            catch (Exception ex) {
                res.setResult(-100211);
                res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100211)) + ": " + ex.getMessage());
                return byteText;
            }
            req.setEncKey(key);
            try {
                byteText = cryptoUtil.DecMessage(key, byteText);
            }
            catch (Exception ex) {
                res.setResult(-100212);
                res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100212)) + ": " + ex.getMessage());
                return byteText;
            }
        }
        if (req.getCommunicateMode() != 1) {
            res.setResult(-100207);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100207));
            return byteText;
        }
        if (ExtendedConfig.isAutoUnzip()) {
            try {
                byte[] unziped = GZipUtil.unzip(byteText);
                if (unziped != null && unziped.length > 0) {
                    byteText = unziped;
                }
            }
            catch (IOException unziped) {}
        } else if (req.isZipMode()) {
            try {
                byteText = GZipUtil.unzip(byteText);
            }
            catch (IOException ioEx) {
                res.setResult(-100215);
                res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100215)) + ": " + ioEx.getMessage());
                return byteText;
            }
        }
        return byteText;
    }

    public static byte[] assemble(byte[] message, CryptoUtil cryptoUtil, NSMessage req, NSMessage res) {
        res.setCommunicateMode(req.getCommunicateMode());
        res.setZipMode(req.isZipMode());
        byte[] byteText = message;
        if (req.isZipMode()) {
            try {
                byteText = GZipUtil.zip(byteText);
            }
            catch (IOException ioEx) {
                res.setResult(-100214);
                res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100214)) + ": " + ioEx.getMessage());
                return byteText;
            }
        }
        if (req.getCommunicateMode() == 0) {
            try {
                byteText = cryptoUtil.EncMessage(req.getEncKey(), byteText);
            }
            catch (Exception ex) {
                res.setResult(-100213);
                res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100213)) + ": " + ex.getMessage());
            }
        }
        return byteText;
    }

    public static byte[] assembleOnlyZip(byte[] message, NSMessage req, NSMessage res) {
        res.setZipMode(req.isZipMode());
        byte[] byteText = message;
        if (ExtendedConfig.isAutoUnzip()) {
            try {
                byte[] unziped = GZipUtil.unzip(byteText);
                if (unziped != null && unziped.length > 0) {
                    byteText = unziped;
                }
            }
            catch (IOException unziped) {}
        } else if (req.isZipMode()) {
            try {
                byteText = GZipUtil.unzip(byteText);
            }
            catch (IOException ioEx) {
                res.setResult(-100215);
                res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100215)) + ": " + ioEx.getMessage());
                return byteText;
            }
        }
        return byteText;
    }

    public static String getDigestAlgoritim(NSMessage req, ServerChannel channel, PublicKey pubk) {
        String processor = req.getProcessor();
        String digestAlg = req.getDigestAlg();
        if (digestAlg == null) {
            if (processor.indexOf("Sign") >= 0 || processor.equals("MakeMSEnvelopedMSGProcessor")) {
                digestAlg = pubk instanceof SM2PublicKey || pubk instanceof JCESM2PublicKey ? channel.getService().getSigDigestAlg("SM2") : channel.getService().getSigDigestAlg("");
            }
            if (processor.indexOf("Verify") >= 0 || processor.equals("DecryptoMSEnvelopedMSGProcessor")) {
                digestAlg = pubk instanceof SM2PublicKey || pubk instanceof JCESM2PublicKey ? channel.getService().getVerifyDigestAlg("SM2") : channel.getService().getVerifyDigestAlg("");
            }
            if (digestAlg == null) {
                digestAlg = channel.getDefaultDigestAlg();
            }
        }
        return digestAlg;
    }

    public static String getDigestAlgoritim(NSMessage req, ServerChannel channel, ServerKeyStore keyStore) {
        PrivateKey prik;
        String processor = req.getProcessor();
        String digestAlg = req.getDigestAlg();
        PrivateKey privateKey = prik = keyStore == null ? null : keyStore.getPrivateKey();
        if (digestAlg == null) {
            if (processor.indexOf("Sign") > 0 || processor.equals("MakeMSEnvelopedMSGProcessor")) {
                digestAlg = prik instanceof SM2PrivateKey || prik instanceof JCESM2PrivateKey ? channel.getService().getSigDigestAlg("SM2") : channel.getService().getSigDigestAlg("");
            }
            if (processor.indexOf("Verify") > 0 || processor.equals("DecryptoMSEnvelopedMSGProcessor")) {
                digestAlg = prik instanceof SM2PrivateKey || prik instanceof JCESM2PrivateKey ? channel.getService().getVerifyDigestAlg("SM2") : channel.getService().getVerifyDigestAlg("");
            }
            if (digestAlg == null) {
                digestAlg = channel.getDefaultDigestAlg();
            }
        }
        ConsoleLogger.logString((String)("Digest algorithm:" + digestAlg));
        return digestAlg;
    }

    public static String getDigestAlgorithm(PDFRequest req, ServerChannel channel, ServerKeyStore keyStore) {
        PrivateKey prik = keyStore == null ? null : keyStore.getPrivateKey();
        String digestAlg = req.getPdfDigestAlg();
        if (digestAlg == null && (digestAlg = prik instanceof SM2PrivateKey || prik instanceof JCESM2PrivateKey ? channel.getService().getSigDigestAlg("SM2") : channel.getService().getSigDigestAlg("")) == null) {
            digestAlg = channel.getDefaultDigestAlg();
        }
        ConsoleLogger.logString((String)("Digest algorithm:" + digestAlg));
        return digestAlg;
    }

    public static String getSymmetricalAlgorithm(NSMessage req, ServerChannel channel) {
        String symmetricalAlg = req.getSymmetricalAlg();
        if (symmetricalAlg == null && (symmetricalAlg = channel.getService().getSymmetricalAlg()) == null) {
            symmetricalAlg = channel.getDefaultSymmetricalAlg();
        }
        return symmetricalAlg;
    }

    public static byte[] generateSignMsg(byte[] plainText, ServerKeyStore keyStore, String digestAlg, boolean isDetached, AbstractMessage res, boolean usedHardWare, String provider, String standard) {
        byte[] signedMsg;
        block8: {
            signedMsg = null;
            if (keyStore == null) {
                res.setResult(-100204);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
                return signedMsg;
            }
            NetSignImpl impl = new NetSignImpl();
            impl.setP7Standard(standard);
            if (usedHardWare) {
                try {
                    PrivateKey tmpprikey = keyStore.getPrivateKey();
                    if (tmpprikey instanceof SM2PrivateKey) {
                        signedMsg = impl.GenerateSingleSignedMsg(plainText, (SM2PrivateKey)tmpprikey, (SM2Certificate)keyStore.getCertChain()[0], keyStore.getCertChainEncoded(), keyStore.getIsAndsns(), digestAlg, isDetached, ExtendedConfig.isSM2SignUsingQ7());
                        break block8;
                    }
                    signedMsg = impl.GenerateHardSignedMsg(plainText, keyStore.getLabel(), keyStore.getCertChain(), digestAlg, isDetached);
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            } else {
                try {
                    PrivateKey tmpprikey = keyStore.getPrivateKey();
                    signedMsg = tmpprikey instanceof SM2PrivateKey ? impl.GenerateSingleSignedMsg(plainText, (SM2PrivateKey)tmpprikey, (SM2Certificate)keyStore.getCert(), keyStore.getCertChainEncoded(), keyStore.getIsAndsns(), digestAlg, isDetached, ExtendedConfig.isSM2SignUsingQ7()) : impl.GenerateSingleSignedMsg(plainText, keyStore.getPrivateKey(), keyStore.getCertChain(), keyStore.getCertChainEncoded(), keyStore.getIsAndsns(), digestAlg, isDetached, provider, ExtendedConfig.isRSASignUsingQ7());
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            }
        }
        return signedMsg;
    }

    public static byte[] generateCMSSignMsg(byte[] plainText, ServerKeyStore keyStore, String digestAlg, boolean isDetached, AbstractMessage res, boolean usedHardWare, String provider) {
        byte[] signedMsg;
        block10: {
            signedMsg = null;
            if (keyStore == null) {
                res.setResult(-100204);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
                return signedMsg;
            }
            NetSignImpl impl = new NetSignImpl();
            PrivateKey tmpprikey = keyStore.getPrivateKey();
            if (tmpprikey instanceof SM2PrivateKey) {
                try {
                    signedMsg = impl.GenerateSM2CMSSingleSignedMsg(plainText, (SM2PrivateKey)tmpprikey, (SM2Certificate)keyStore.getCertChain()[0], digestAlg, isDetached);
                }
                catch (Exception e) {
                    ProcessUtil.throwDetailException(e, res);
                }
            } else {
                if (usedHardWare) {
                    try {
                        throw new SignatureException("Generate CMS SignedData using hard mode is unsupport yet.");
                    }
                    catch (Exception ex) {
                        ProcessUtil.throwDetailException(ex, res);
                        break block10;
                    }
                }
                try {
                    signedMsg = impl.GenerateCMSSingleSignedMsg(plainText, keyStore.getPrivateKey(), keyStore.getCertChain()[0], digestAlg, isDetached, provider);
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            }
        }
        return signedMsg;
    }

    public static void addSignCertInfo(String[] certInfo, NSMessageOpt res) {
        res.setSignEndTime(certInfo[3]);
        res.setSignIssuerSubject(certInfo[1]);
        res.setSignSerNumber(certInfo[4]);
        res.setSignStartTime(certInfo[2]);
        res.setSignSubject(certInfo[0]);
    }

    public static void addSignCert(boolean isReturnCert, X509Certificate cert, NSMessageOpt res) {
        if (isReturnCert) {
            res.setTransCert(true);
            res.setCert(cert);
        }
    }

    public static AdminMessage createAdminMessage(AbstractMessage request) {
        AdminMessage res = new AdminMessage();
        res.setType("response");
        res.setProcessor(request.getProcessor());
        return res;
    }

    public static NSMessage createNSMessage(AbstractMessage request) {
        NSMessage res = new NSMessage();
        res.setType("response");
        res.setProcessor(request.getProcessor());
        return res;
    }

    public static NSMessageOpt createNSMessageOpt(AbstractMessage request) {
        NSMessageOpt res = new NSMessageOpt();
        res.setType("response");
        res.setProcessor(request.getProcessor());
        return res;
    }

    public static void throwDetailException(Exception ex, AbstractMessage res) {
        ConsoleLogger.logException((Throwable)ex);
        if (ex instanceof CertificateEncodingException) {
            res.setResult(-100118);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof InvalidParameterException) {
            res.setResult(-100100);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof InvalidAlgorithmParameterException) {
            res.setResult(-100231);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CertStoreException) {
            res.setResult(-100232);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof DocumentException) {
            res.setResult(-100233);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof MalformedURLException) {
            res.setResult(-100234);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CMSException) {
            res.setResult(-100235);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CryptoException) {
            res.setResult(-100101);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CertificateNotMatchException) {
            res.setResult(-100102);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof SecurityException) {
            res.setResult(-100103);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof VerifySignatureException) {
            res.setResult(-100104);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CertTrustException) {
            res.setResult(-100105);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof NotInTrustListException) {
            res.setResult(-100124);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CertValidateException) {
            res.setResult(-100106);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof VerifyOCSPException) {
            res.setResult(-100107);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CertRevokedException) {
            res.setResult(-100108);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof EncryptKeyException) {
            res.setResult(-100115);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof EncryptDataException) {
            res.setResult(-100116);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof WriteEnvDataException) {
            res.setResult(-100117);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof DecryptKeyException) {
            res.setResult(-100109);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof DecryptDataException) {
            res.setResult(-100110);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof NoSuchProviderException) {
            res.setResult(-100111);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof NoSuchAlgorithmException) {
            res.setResult(-100112);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof InvalidKeyException) {
            res.setResult(-100113);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof SignatureException) {
            res.setResult(-100114);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof PlaintextStructureException) {
            res.setResult(-100119);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof SignatureStructureException) {
            res.setResult(-100120);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof javax.crypto.NoSuchPaddingException || ex instanceof NoSuchPaddingException) {
            res.setResult(-100121);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof IllegalBlockSizeException) {
            res.setResult(-100122);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof BadPaddingException || ex instanceof com.datech.jce.provider.hsmcsp.BadPaddingException) {
            res.setResult(-100123);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CRLFileNotFoundException) {
            res.setResult(-100125);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CMSDigestVerifyException) {
            res.setResult(-100127);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof CRLFileExpiredException) {
            res.setResult(-100126);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof ReadPDFException) {
            res.setResult(-100228);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof PDFPageNumberOutofRangeException) {
            res.setResult(-100237);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof AddImage2PDFException) {
            res.setResult(-100239);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof GenerateBarCodeFailedException) {
            res.setResult(-100251);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof ParseXMLException) {
            res.setResult(-100260);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof GenerateXMLException) {
            res.setResult(-100261);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof NotSignatureFileException) {
            res.setResult(-100262);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof XMLCoreValidationException) {
            res.setResult(-100263);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof XMLReferenceException) {
            res.setResult(-100264);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof WeekAlgorithmException) {
            res.setResult(-100128);
            res.setErrMsg(ex.getMessage());
            return;
        }
        if (ex instanceof TsaTokenException) {
            res.setResult(((TsaTokenException)ex).getErrorNo());
            res.setErrMsg(ex.getMessage());
            return;
        }
        res.setResult(-100004);
        res.setErrMsg(ex.toString());
    }

    public static void accessLog(AbstractLogger logger, String msg, String level, NetSignRequest nsreq) {
        if (level.equals("info")) {
            StringBuffer buf = new StringBuffer(msg);
            if (ExtendedConfig.isLogRespTime()) {
                double tdc = (double)(System.nanoTime() - nsreq.getRecvTimeNano()) / 1000000.0;
                String tradeCost = String.format("%.4f", new Double(tdc));
                double ioc = (double)nsreq.getIoCostNano() / 1000000.0;
                String ioCost = String.format("%.4f", new Double(ioc));
                double tc = tdc + ioc;
                String totalCost = String.format("%.4f", new Double(tc));
                buf.append(" ( TradeCost: ").append(tradeCost).append(" ms ReadCost: ").append(ioCost).append(" ms TotalCost: ").append(totalCost).append(" ms )");
                if (tc > (double)ExtendedConfig.getLongBusinessTime()) {
                    ConsoleLogger.logStringForce((String)buf.toString());
                }
            }
            logger.Log(buf.toString());
        }
    }

    public static void accessLog(AbstractLogger logger, String msg, String level, NetSignRequest nsreq, NSMessage res) {
        if (level.equals("info")) {
            StringBuffer buf = new StringBuffer(msg);
            if (ExtendedConfig.isLogRespTime()) {
                double tdc = (double)(System.nanoTime() - nsreq.getRecvTimeNano()) / 1000000.0;
                String tradeCost = String.format("%.4f", new Double(tdc));
                double ioc = (double)nsreq.getIoCostNano() / 1000000.0;
                String ioCost = String.format("%.4f", new Double(ioc));
                double tc = tdc + ioc;
                String totalCost = String.format("%.4f", new Double(tc));
                buf.append(" ( TradeCost: ").append(tradeCost).append(" ms ReadCost: ").append(ioCost).append(" ms TotalCost: ").append(totalCost).append(" ms )");
                if (tc > (double)ExtendedConfig.getLongBusinessTime()) {
                    ConsoleLogger.logStringForce((String)buf.toString());
                }
            }
            logger.Log(buf.toString());
        } else if (level.equals("detail")) {
            StringBuffer buf = new StringBuffer(msg);
            if (ExtendedConfig.isLogRespTime()) {
                double tdc = (double)(System.nanoTime() - nsreq.getRecvTimeNano()) / 1000000.0;
                String tradeCost = String.format("%.4f", new Double(tdc));
                double ioc = (double)nsreq.getIoCostNano() / 1000000.0;
                String ioCost = String.format("%.4f", new Double(ioc));
                double tc = tdc + ioc;
                String totalCost = String.format("%.4f", new Double(tc));
                buf.append(" ( TradeCost: ").append(tradeCost).append(" ms ReadCost: ").append(ioCost).append(" ms TotalCost: ").append(totalCost).append(" ms )");
                if (tc > (double)ExtendedConfig.getLongBusinessTime()) {
                    ConsoleLogger.logStringForce((String)buf.toString());
                }
            }
            if (res != null) {
                buf.append("\n" + res.getProcessor() + ": " + res.getResult() + ", " + res.getString());
            }
            logger.Log(buf.toString());
        }
    }

    public static void log(AbstractLogger logger, String id, AbstractMessage req, AbstractMessage res) {
        if (req != null) {
            logger.Log(String.valueOf(id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg() + req.getString());
        } else {
            logger.Log(String.valueOf(id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
        }
    }

    public static ResourceList getResourceList(ServerChannel channel, String listName) {
        ResourcePool rp = channel.getResourcePool();
        if (rp == null || rp.size() < 1) {
            return null;
        }
        if (listName != null && !"".equals(listName)) {
            PBCRAWCertProxy query = new PBCRAWCertProxy();
            query.setType(2001);
            query.addCondition("name", (Object)listName);
            return rp.getResourceList((ResourceListFilter)query);
        }
        Iterator iter = rp.entrySet().iterator();
        return (ResourceList)((Map.Entry)iter.next()).getValue();
    }

    public static PBCRAWCert getPBCRAWCert(String dnorbankcode, PBCRAWCertResourceList certlist) {
        if (dnorbankcode == null) {
            return null;
        }
        if (certlist != null) {
            PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceByDNorBankCode((String)dnorbankcode);
            List certs = certlist.getResource((ResourceFilter)query);
            if (certs != null && certs.size() > 0) {
                return (PBCRAWCert)certs.get(0);
            }
            return null;
        }
        return null;
    }

    public static AdminMessage fillContent2Res(AdminMessage res, CertSYNResult result, boolean needauth, int authtype) {
        String authcode = SynConfig.getAuthCode_host();
        HashMap<String, byte[]> mapRes = new HashMap<String, byte[]>();
        byte[] rawSynRes = null;
        try {
            rawSynRes = CertSYNResult.Object2ByteArrays((CertSYNResult)result);
        }
        catch (Exception e) {
            SynLogger.log((String)"( processor )Tranform CertSYNResult 2 byteArrays failed. Caused by: ");
            SynLogger.log((Throwable)e);
        }
        mapRes.put("rawSynRes", rawSynRes);
        if (needauth) {
            byte[] encrySynRes = null;
            MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
            try {
                encrySynRes = auther.generateAuthMessage(rawSynRes, authcode);
            }
            catch (Exception e) {
                SynLogger.log((String)"( processor )Fill content 2 Res failed. Caused by: ");
                SynLogger.log((Throwable)e);
            }
            mapRes.put("encrySynRes", encrySynRes);
        }
        res.setContent(mapRes);
        return res;
    }

    public static HostOfRAWCert findAuthCodeforVerify(byte[] authcodedigest) {
        HostOfRAWCert deshost = null;
        ArrayList hostlists = HostOfRAWCert.parse((List)SynConfig.getHostslist());
        int i = 0;
        int size = hostlists.size();
        while (i < size) {
            HostOfRAWCert host = (HostOfRAWCert)hostlists.get(i);
            String authcodetemp = host.getAuthCode();
            byte[] digest = AuthMessageUtil.genDegist((byte[])authcodetemp.getBytes(), (String)"SHA-1");
            if (Arrays.equals(authcodedigest, digest)) {
                deshost = host;
                break;
            }
            ++i;
        }
        return deshost;
    }
}

