/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors.util;

import cn.com.infosec.netsign.base.BarCodeParameters;
import cn.com.infosec.netsign.exceptions.GenerateBarCodeFailedException;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.itextpdf.text.pdf.BarcodePDF417;
import com.swetake.util.Qrcode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.krysalis.barcode4j.ChecksumMode;
import org.krysalis.barcode4j.HumanReadablePlacement;
import org.krysalis.barcode4j.impl.codabar.CodabarBean;
import org.krysalis.barcode4j.impl.code128.Code128Bean;
import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.impl.int2of5.Interleaved2Of5Bean;
import org.krysalis.barcode4j.output.CanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;

public class BarCodeUtil {
    public static final String MIME_TYPE_PNG = "image/x-png";
    public static final String MIME_TYPE_JPEG = "image/jpeg";
    public static final String MIME_TYPE_GIF = "image/gif";

    public static byte[] genBarcde39(BarCodeParameters paras, String msg, boolean addCheckSUM, float wideFactor, boolean displayStartStop) throws GenerateBarCodeFailedException {
        Code39Bean bean = new Code39Bean();
        int dpi = 150;
        if (paras.getModuleWidth() > 0.0) {
            dpi = BarCodeUtil.getDPI(paras.getModuleWidth());
            bean.setModuleWidth(UnitConv.in2mm((double)(1.0f / (float)dpi)));
        }
        if (paras.getBarHeight() > 0.0) {
            bean.setBarHeight(paras.getBarHeight());
        }
        if (addCheckSUM) {
            bean.setChecksumMode(ChecksumMode.CP_ADD);
            bean.setDisplayChecksum(true);
        } else {
            bean.setChecksumMode(ChecksumMode.CP_IGNORE);
        }
        if (wideFactor > 1.0f) {
            bean.setWideFactor((double)wideFactor);
        }
        if (paras.isDoQuietZone()) {
            bean.doQuietZone(true);
            if (paras.getQuietZoneWidth() > 0.0) {
                bean.setQuietZone(paras.getQuietZoneWidth());
            }
        } else {
            bean.doQuietZone(false);
        }
        if (paras.isDisplayHumanReadable()) {
            bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
            if (displayStartStop) {
                bean.setDisplayStartStop(true);
            }
        } else {
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String mimeType = BarCodeUtil.getMIMEType(paras.getImageFormat());
            BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, mimeType, dpi, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateBarCodeFailedException(e.toString());
        }
        return out.toByteArray();
    }

    public static byte[] genBarcde128(BarCodeParameters paras, String msg) throws GenerateBarCodeFailedException {
        Code128Bean bean = new Code128Bean();
        int dpi = 150;
        if (paras.getModuleWidth() > 0.0) {
            dpi = BarCodeUtil.getDPI(paras.getModuleWidth());
            bean.setModuleWidth(UnitConv.in2mm((double)(1.0f / (float)dpi)));
        }
        if (paras.getBarHeight() > 0.0) {
            bean.setBarHeight(paras.getBarHeight());
        }
        if (paras.isDoQuietZone()) {
            bean.doQuietZone(true);
            if (paras.getQuietZoneWidth() > 0.0) {
                bean.setQuietZone(paras.getQuietZoneWidth());
            }
        } else {
            bean.doQuietZone(false);
        }
        if (paras.isDisplayHumanReadable()) {
            bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        } else {
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String mimeType = BarCodeUtil.getMIMEType(paras.getImageFormat());
            BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, mimeType, dpi, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateBarCodeFailedException(e.toString());
        }
        return out.toByteArray();
    }

    public static byte[] genBarcdeInter25(BarCodeParameters paras, String msg, boolean addCheckSUM, float wideFactor) throws GenerateBarCodeFailedException {
        Interleaved2Of5Bean bean = new Interleaved2Of5Bean();
        int dpi = 150;
        if (paras.getModuleWidth() > 0.0) {
            dpi = BarCodeUtil.getDPI(paras.getModuleWidth());
            bean.setModuleWidth(UnitConv.in2mm((double)(1.0f / (float)dpi)));
        }
        if (paras.getBarHeight() > 0.0) {
            bean.setBarHeight(paras.getBarHeight());
        }
        if (addCheckSUM) {
            bean.setChecksumMode(ChecksumMode.CP_ADD);
            bean.setDisplayChecksum(true);
        } else {
            bean.setChecksumMode(ChecksumMode.CP_IGNORE);
        }
        if (wideFactor > 1.0f) {
            bean.setWideFactor((double)wideFactor);
        }
        if (paras.isDoQuietZone()) {
            bean.doQuietZone(true);
            if (paras.getQuietZoneWidth() > 0.0) {
                bean.setQuietZone(paras.getQuietZoneWidth());
            }
        } else {
            bean.doQuietZone(false);
        }
        if (paras.isDisplayHumanReadable()) {
            bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
        } else {
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String mimeType = BarCodeUtil.getMIMEType(paras.getImageFormat());
            BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, mimeType, dpi, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateBarCodeFailedException(e.toString());
        }
        return out.toByteArray();
    }

    public static byte[] genBarcdeCodabar(BarCodeParameters paras, String msg, boolean addCheckSUM, float wideFactor, boolean displayStartStop) throws GenerateBarCodeFailedException {
        CodabarBean bean = new CodabarBean();
        int dpi = 150;
        if (paras.getModuleWidth() > 0.0) {
            dpi = BarCodeUtil.getDPI(paras.getModuleWidth());
            bean.setModuleWidth(UnitConv.in2mm((double)(1.0f / (float)dpi)));
        }
        if (paras.getBarHeight() > 0.0) {
            bean.setBarHeight(paras.getBarHeight());
        }
        if (wideFactor > 1.0f) {
            bean.setWideFactor((double)wideFactor);
        }
        if (paras.isDoQuietZone()) {
            bean.doQuietZone(true);
            if (paras.getQuietZoneWidth() > 0.0) {
                bean.setQuietZone(paras.getQuietZoneWidth());
            }
        } else {
            bean.doQuietZone(false);
        }
        if (paras.isDisplayHumanReadable()) {
            bean.setMsgPosition(HumanReadablePlacement.HRP_BOTTOM);
            if (displayStartStop) {
                bean.setDisplayStartStop(true);
            }
        } else {
            bean.setMsgPosition(HumanReadablePlacement.HRP_NONE);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            String mimeType = BarCodeUtil.getMIMEType(paras.getImageFormat());
            BitmapCanvasProvider canvas = new BitmapCanvasProvider((OutputStream)out, mimeType, dpi, 12, false, 0);
            bean.generateBarcode((CanvasProvider)canvas, msg);
            canvas.finish();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateBarCodeFailedException(e.toString());
        }
        return out.toByteArray();
    }

    public static byte[] genBarcdePDF417(byte[] msg, boolean isBinary, int errorCorrectLevel, float aspetRatio, float yheight, int returnFormat) throws GenerateBarCodeFailedException {
        BarcodePDF417 bc = new BarcodePDF417();
        int options = 0;
        if (isBinary) {
            options |= 0x20;
        }
        if (errorCorrectLevel > -1) {
            options |= 0x10;
        }
        bc.setOptions(options);
        bc.setText(msg);
        if (errorCorrectLevel > -1 && errorCorrectLevel < 9) {
            bc.setErrorLevel(errorCorrectLevel);
        }
        if (errorCorrectLevel > 8) {
            bc.setErrorLevel(8);
        }
        if (aspetRatio > 0.0f) {
            bc.setAspectRatio(aspetRatio);
        }
        if (yheight > 1.0f) {
            bc.setYHeight(yheight);
        }
        try {
            Image img = bc.createAwtImage(Color.black, Color.white);
            BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 1);
            Graphics2D g = bufferedImage.createGraphics();
            g.drawImage(img, 0, 0, null);
            g.dispose();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            String format = BarCodeUtil.getReturnFormat(returnFormat);
            ImageIO.write((RenderedImage)bufferedImage, format, out);
            return out.toByteArray();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateBarCodeFailedException(e.toString());
        }
    }

    public static byte[] genBarcdeQRCode(byte[] msg, int encodeMode, int errorCorrectingLevel, int barSize, int returnFormat) throws GenerateBarCodeFailedException {
        Qrcode qrcode = new Qrcode();
        qrcode.setQrcodeErrorCorrect(BarCodeUtil.qrCodeECLevel(errorCorrectingLevel));
        qrcode.setQrcodeEncodeMode(BarCodeUtil.qrEncodingMode(encodeMode));
        qrcode.setQrcodeVersion(0);
        try {
            boolean[][] b = qrcode.calQrcode(msg);
            barSize = barSize < 1 ? 3 : barSize;
            int picSize = barSize * b.length;
            BufferedImage bi = new BufferedImage(picSize, picSize, 1);
            Graphics2D g = bi.createGraphics();
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, picSize, picSize);
            g.setColor(Color.BLACK);
            int i = 0;
            while (i < b.length) {
                int j = 0;
                while (j < b.length) {
                    if (b[j][i]) {
                        g.fillRect(j * barSize, i * barSize, barSize, barSize);
                    }
                    ++j;
                }
                ++i;
            }
            g.dispose();
            bi.flush();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bi, BarCodeUtil.getReturnFormat(returnFormat), out);
            return out.toByteArray();
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            throw new GenerateBarCodeFailedException(e.toString());
        }
    }

    private static char qrEncodingMode(int m) {
        switch (m) {
            case 0: {
                return 'B';
            }
            case 1: {
                return 'A';
            }
            case 2: {
                return 'N';
            }
        }
        return 'B';
    }

    private static char qrCodeECLevel(int l) {
        switch (l) {
            case 0: {
                return 'L';
            }
            case 1: {
                return 'M';
            }
            case 2: {
                return 'H';
            }
            case 3: {
                return 'Q';
            }
        }
        return 'L';
    }

    private static String getReturnFormat(int type) {
        switch (type) {
            case 0: {
                return "PNG";
            }
            case 1: {
                return "JPEG";
            }
            case 2: {
                return "GIF";
            }
        }
        return "PNG";
    }

    private static String getMIMEType(int type) {
        switch (type) {
            case 0: {
                return MIME_TYPE_PNG;
            }
            case 1: {
                return MIME_TYPE_JPEG;
            }
            case 2: {
                return MIME_TYPE_GIF;
            }
        }
        return MIME_TYPE_PNG;
    }

    private static int getDPI(double moduleWidth) {
        int dpi = (int)(1.0 / UnitConv.mm2in((double)moduleWidth));
        dpi = dpi == 0 ? 1 : dpi;
        dpi = dpi >= 10000 ? 9999 : dpi;
        return dpi;
    }

    public static void main(String[] args) throws Exception {
        String testString = "1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111";
        while (true) {
            System.out.println(testString.length());
            byte[] png = BarCodeUtil.genBarcdeQRCode(testString.getBytes(), 2, 0, 3, 0);
            testString = String.valueOf(testString) + "1";
        }
    }
}

