/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.XMLVerifyResult;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.processors.util.XMLSignatureUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import java.util.ArrayList;

public class XMLAlipayVerifyProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public XMLAlipayVerifyProcessor() {
    }

    public XMLAlipayVerifyProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " XMLAlipayVerifyProcessor failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] xml = request.getPlainText();
        xml = ProcessUtil.disassemble(xml, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        ArrayList list = null;
        try {
            list = XMLSignatureUtil.alipayVerify(xml, this.channel, request.getCert());
        }
        catch (Exception e) {
            ProcessUtil.throwDetailException(e, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setXmlVerifyResults(list);
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(this.channel.getId()) + " " + request.getAddress() + " XMLAlipayVerifyProcessor success ");
        boolean needDebugLog = false;
        int i = 0;
        while (i < list.size()) {
            XMLVerifyResult xmlvr = (XMLVerifyResult)list.get(i);
            sb.append("signature id:" + xmlvr.getSigId() + "   return code:" + xmlvr.getReturnCode()).append(";");
            if (!needDebugLog && xmlvr.getReturnCode() < 0) {
                needDebugLog = true;
            }
            ++i;
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), sb.toString(), this.channel.getLogLevel(), nsreq, res);
        if (needDebugLog) {
            res.setErrMsg(sb.toString());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
        }
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    public void setChannel(ServerChannel channel) {
        this.channel = channel;
    }
}

