/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.processors.util.XMLSignatureUtil;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;

public class XMLAlipaySignProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public XMLAlipaySignProcessor() {
    }

    public XMLAlipaySignProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " XMLAlipaySignProcessor failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] xml = request.getPlainText();
        xml = ProcessUtil.disassemble(xml, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String certDN = request.getSignCertDN();
        byte[] signedXml = null;
        Object[] result = new Object[2];
        ServerKeyStore keyStore = this.channel.getSignKeyStore(certDN);
        if (keyStore == null) {
            res.setResult(-100204);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        try {
            result = XMLSignatureUtil.generateAlipaySignature(xml, keyStore, request.getXmlSigID(), request);
            signedXml = (byte[])result[0];
        }
        catch (Exception e) {
            ProcessUtil.throwDetailException(e, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        signedXml = ProcessUtil.assemble(signedXml, this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setCryptoText(signedXml);
        res.setXmlSigID((String)result[1]);
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " XMLAlipaySignProcessor success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    public void setChannel(ServerChannel channel) {
        this.channel = channel;
    }
}

