/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class VerifyQLBKeyBusinessProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private String provider = "INFOSEC";

    public VerifyQLBKeyBusinessProcessor() {
    }

    private void setNoCertError(AbstractMessage res) {
        res.setResult(-100204);
        res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public VerifyQLBKeyBusinessProcessor(ServerChannel channel) {
        this.channel = channel;
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " KLBRAWVerify failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        X509Certificate cert = request.getCert();
        if (cert == null) {
            this.setNoCertError(res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PublicKey key = null;
        try {
            if (Utils.getCertType(cert) == 1) {
                cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                key = cert.getPublicKey();
            } else {
                key = cert.getPublicKey();
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        byte[] cryptoText = request.getCryptoText();
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, key);
        NetSignImpl impl = new NetSignImpl();
        try {
            DigestAlgorithm digestam;
            if (cert != null && this.channel.getService().isVerifyCert()) {
                impl.verifySingleSignedCert(cert, null, this.channel.getTrustConfigs(), this.channel.isCheckValidity());
            }
            if ((digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg)) == null) {
                throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
            }
            impl.verifyQLBKB(plainText, cryptoText, digestAlg, cert.getPublicKey(), this.provider);
        }
        catch (Exception ex) {
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " KLBRAWVerify success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

