/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import java.security.cert.X509Certificate;

public class VerifyCertProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certlist;

    public VerifyCertProcessor() {
    }

    public VerifyCertProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    private void setNoCertError(AbstractMessage res, String dn) {
        res.setResult(-100224);
        res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100224)) + ": " + dn);
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " VerifyCert failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        X509Certificate certEntry = request.getCert();
        String certDN = request.getSignCertDN();
        if (certEntry == null) {
            this.certlist = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
            if (this.certlist == null) {
                res.setResult(-100280);
                res.setErrMsg("No certificate list found by " + request.getResourceName());
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
            PBCRAWCert cert = null;
            if (certDN != null && (cert = ProcessUtil.getPBCRAWCert(certDN, this.certlist)) != null) {
                if (cert.isInBlackList()) {
                    res.setResult(-100226);
                    res.setErrMsg("The bank who have this certificate is in blacklist");
                    ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                    ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
                    return NetSignResponse.createNetSignResponse(res, nsreq);
                }
                certEntry = cert.getCert();
            }
        } else {
            certDN = certEntry.getSubjectDN().getName();
        }
        if (certEntry == null) {
            this.setNoCertError(res, certDN);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        try {
            NetSignImpl nsi = new NetSignImpl();
            nsi.verifySingleSignedCert(certEntry, null, this.channel.getTrustConfigs(), this.channel.isCheckValidity());
        }
        catch (Exception e) {
            ProcessUtil.throwDetailException(e, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setSignSerNumber(certEntry.getSerialNumber().toString(16).toUpperCase());
        res.setSignStartTime(String.valueOf(certEntry.getNotBefore().getTime() / 1000L));
        res.setSignEndTime(String.valueOf(certEntry.getNotAfter().getTime() / 1000L));
        res.setSignIssuerSubject(certEntry.getIssuerDN().getName());
        res.setSignSubject(certEntry.getSubjectDN().getName());
        ProcessUtil.accessLog(this.channel.getAccessLogger(), "VerifyCertProcessor successed.", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

