/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;

public class VerifyCertChainProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certlist;

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " VerifyCertChain failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        this.certlist = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
        if (this.certlist == null) {
            res.setResult(-100280);
            res.setErrMsg("No certificate list found by " + request.getResourceName());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String certDN = request.getSignCertDN();
        PBCRAWCert cert = null;
        if (certDN != null) {
            cert = ProcessUtil.getPBCRAWCert(certDN, this.certlist);
        }
        if (cert == null || cert.getCertDN() == null) {
            this.setNoCertError(res, certDN);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (cert.isInBlackList()) {
            res.setResult(-100226);
            res.setErrMsg("The bank who have this certificate is in blacklist");
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        try {
            NetSignImpl nsi = new NetSignImpl();
            nsi.verifyRAWCertChain(cert, this.channel.getTrustConfigs());
        }
        catch (Exception e) {
            ProcessUtil.throwDetailException(e, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setSignSerNumber(cert.getSerialNumber());
        res.setSignStartTime(String.valueOf(cert.getNotBeforeLong() / 1000L));
        res.setSignEndTime(String.valueOf(cert.getNotAfterLong() / 1000L));
        res.setSignIssuerSubject(cert.getIssuerDN());
        res.setSignSubject(cert.getCertDN());
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " VerifyCertChain success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    public VerifyCertChainProcessor() {
    }

    public VerifyCertChainProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    private void setNoCertError(AbstractMessage res, String dn) {
        res.setResult(-100224);
        res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100224)) + ": " + dn);
    }
}

