/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.Resource;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;

public class UploadRAWCertProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certList;

    public UploadRAWCertProcessor() {
    }

    public UploadRAWCertProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        String lastUpdate;
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        NSMessage res = ProcessUtil.createNSMessage(request);
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " upload raw cert failed";
        this.certList = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
        if (this.certList == null) {
            res.setResult(-100280);
            res.setErrMsg("No certificate list found by " + request.getResourceName());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " " + failedMsg + ":" + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String bankID = request.getBankID();
        String bankName = request.getBankName();
        bankName = bankName == null ? "" : bankName;
        X509Certificate cert = request.getCert();
        if (cert == null) {
            res.setResult(-100205);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100205));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), failedMsg, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PBCRAWCert rawC = new PBCRAWCert();
        rawC.setCert(cert);
        rawC.setPath(this.certList.getPath());
        rawC.addModifyTime();
        ArrayList updatetimes = (ArrayList)rawC.getModifyTimes();
        String string = lastUpdate = updatetimes == null || updatetimes.size() == 0 ? "" : (String)updatetimes.get(updatetimes.size() - 1);
        if (ExtendedConfig.isCheckBankID() && bankID != null && !bankID.equals("") && rawC.getCertDN().indexOf(bankID) < 0) {
            res.setResult(-100227);
            res.setErrMsg("BankID:" + bankID + " not contaned in the subject:" + rawC.getCertDN());
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (bankID != null && !"".equals(bankID)) {
            rawC.setBankCode(bankID);
        }
        if (bankName != null && !"".equals(bankName)) {
            rawC.setBankName(bankName);
        }
        if (SynConfig.getHostslist().size() > 0) {
            PBCRAWCertSynManager synmanager = PBCRAWCertSynManagerFactory.getSynManager();
            CertTask task = null;
            task = CertTask.getInstance((String)bankID, (String)this.certList.getName(), (String)cert.getSubjectDN().getName(), (String)"synuploadresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)rawC);
            synmanager.realTimeSyn((Task)task);
        }
        NetSignImpl impl = new NetSignImpl();
        byte[] sigNew = cert.getSignature();
        PBCRAWCert certOld = ProcessUtil.getPBCRAWCert(rawC.getBankCode(), this.certList);
        if (certOld == null || certOld.getCert() == null || !Arrays.equals(sigNew, certOld.getCert().getSignature())) {
            this.certList.log("UploadRAWCertProcessor Certificate bankcode=[ " + bankID + " ] with certDN=[ " + cert.getSubjectDN().getName() + " ] is new.");
            byte[] certByte = null;
            try {
                impl.verifySingleSignedCert(cert, null, this.channel.getTrustConfigs(), true);
                certByte = cert.getEncoded();
            }
            catch (Exception e) {
                ProcessUtil.throwDetailException(e, res);
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), failedMsg, this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
        }
        try {
            PBCRAWCertProxy query = PBCRAWCertProxyFactory.getSetAndSaveResource((Resource)rawC);
            this.certList.setResource((ResourceSetter)query);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg(e.toString());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + " save bankinfo.conf failed", this.channel.getLogLevel(), nsreq, res);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " UploadRAWCert bankcode=[ " + bankID + " ] with certDN=[ " + cert.getSubjectDN().getName() + " ] success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

