/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;

public class UpdateBankInfoProcessor
implements Processor {
    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        PBCRAWCert cert = (PBCRAWCert)req.getContent();
        if (cert == null) {
            res.setResult(-100041);
            res.setErrMsg("No bank info received");
            return res;
        }
        PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByPath((String)cert.getPath());
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)ResourceManager.getAllResourceList().getResourceList((ResourceListFilter)query);
        PBCRAWCert tmp = ProcessUtil.getPBCRAWCert(cert.getBankCode(), certList);
        if (tmp == null) {
            res.setResult(-100036);
            res.setErrMsg("Can not find bankinfo by id.");
            return res;
        }
        query.setType(3001);
        query.addCondition("resource", (Object)cert);
        try {
            if (certList.setResource((ResourceSetter)query)) {
                certList.log("UpdateBankInfoProcessor bank name of " + cert.getBankCode() + " updated.");
            } else {
                certList.log("UpdateBankInfoProcessor bank name of " + cert.getBankCode() + " need not to update.");
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg("UpdateBankInfoProcessor Save bank info failed:" + e.toString());
            certList.log("UpdateBankInfoProcessor update bank name of " + cert.getBankCode() + " failed:" + e.toString());
        }
        return res;
    }
}

