/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.TrustConfig;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.ChannelManager;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.CertSYNParameters;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;
import cn.com.infosec.synfw.logger.SynLogger;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public class SYNUploadCertProcessor
implements Processor {
    private PBCRAWCertResourceList certList = null;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res;
        block26: {
            res = ProcessUtil.createAdminMessage(request);
            AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
            String bankid = null;
            String listname = null;
            byte[] cert = null;
            String uploadTime = null;
            CertSYNParameters synpara = null;
            HashMap map = (HashMap)req.getContent();
            byte[] rawPara = (byte[])map.get("rawSynPara");
            boolean needauth = (Boolean)map.get("needauth");
            int authtype = -1;
            try {
                synpara = CertSYNParameters.ByteArrays2Object((byte[])rawPara);
            }
            catch (Exception e1) {
                SynLogger.log((String)"( SYNUploadCertProcessor )Tranform CertSYNParameters 2 byteArrays failed. Caused by: ");
                SynLogger.log((Throwable)e1);
            }
            HostOfRAWCert desthost = null;
            boolean needauthSelf = false;
            String authcode = null;
            if (needauth) {
                byte[] authcodedigest = (byte[])map.get("authcode");
                desthost = ProcessUtil.findAuthCodeforVerify(authcodedigest);
                if (desthost != null) {
                    needauthSelf = desthost.isNeedauth();
                    authcode = desthost.getAuthCode();
                }
                authtype = (Integer)map.get("authtype");
                if (authcode == null) {
                    SynLogger.log((String)"SYNUploadCert failed, Caused by: Can't find corresponding authcode with req.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            }
            if (needauthSelf && authcode != null) {
                if (needauth) {
                    byte[] encrySynPara = (byte[])map.get("encrySynPara");
                    MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
                    boolean isverifyok = auther.verifyAuthMessage(rawPara, authcode, encrySynPara);
                    if (!isverifyok) {
                        SynLogger.log((String)"SYNUploadCert failed, Caused by: Syn parameters can't verified.");
                        res.setResult(-100180);
                        res.setErrMsg("SYNParameters can't verifed.");
                        return res;
                    }
                } else {
                    SynLogger.log((String)"SYNUploadCert failed, Caused by: Syn parameters need to verify, there are not auth-message. Can't to verify.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            }
            bankid = synpara.getBankid();
            listname = synpara.getListname();
            PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByName((String)listname);
            this.certList = (PBCRAWCertResourceList)ResourceManager.getAllResourceList().getResourceList((ResourceListFilter)query);
            cert = synpara.getX509();
            if (cert == null) {
                SynLogger.log((String)"SynUploadCertificateProcessor failed -100035 ");
                res.setResult(-100035);
                res.setErrMsg("Receive raw cert failed");
                return res;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            X509Certificate x509 = null;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
                x509 = (X509Certificate)cf.generateCertificate(bais);
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
                res.setResult(-100050);
                res.setErrMsg("Generate certificate failed:" + e.toString());
                return res;
            }
            if (x509 == null) {
                res.setResult(-100050);
                res.setErrMsg("Generate certificate failed");
                return res;
            }
            uploadTime = synpara.getOperatetime();
            PBCRAWCert rawCert = new PBCRAWCert();
            rawCert.setCert(x509);
            rawCert.setPath(this.certList.getPath());
            rawCert.addModifyTime(uploadTime);
            if (bankid != null && !bankid.equals("")) {
                rawCert.setBankCode(bankid);
            }
            String certDN = rawCert.getCertDN();
            String issuerDN = rawCert.getIssuerDN();
            if (!synpara.isIslocalOper() && SynConfig.isCenter_host()) {
                CertTask task;
                PBCRAWCertSynManager synmanager;
                if (desthost != null && desthost.getWeb_type() == 1) {
                    synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                    task = null;
                    task = CertTask.getInstance((String)bankid, (String)listname, (String)certDN, (String)"synuploadresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)rawCert);
                    task.setSrcOftask(1);
                    task.setSrcOfhost(desthost);
                    synmanager.realTimeSyn((Task)task);
                } else {
                    synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                    task = null;
                    task = CertTask.getInstance((String)bankid, (String)listname, (String)certDN, (String)"synuploadresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)rawCert);
                    task.setSrcOftask(0);
                    synmanager.realTimeSyn((Task)task);
                }
            }
            NetSignImpl impl = new NetSignImpl();
            Map channels = ChannelManager.getServerChannels();
            Map tcs = this.getTrustConfig(channels, rawCert.getIssuerDN());
            if (tcs != null) {
                try {
                    impl.verifyRAWCert(rawCert, tcs);
                    query.setType(3001);
                    query.addCondition("resource", (Object)rawCert);
                    if (this.certList.setResource((ResourceSetter)query)) {
                        SynLogger.log((String)("SynUploadCertificateProcessor save " + certDN + ".cer finished"));
                        this.certList.log("Certificate [ " + certDN + " ] saved by SYN");
                        break block26;
                    }
                    SynLogger.log((String)("SynUploadCertificateProcessor save " + certDN + ".cer failed"));
                    this.certList.log("Certificate [ " + certDN + " ] saved by SYN failed.");
                }
                catch (CertTrustException e) {
                    SynLogger.log((Throwable)e);
                    res.setResult(-100105);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (CertValidateException e) {
                    SynLogger.log((Throwable)e);
                    res.setResult(-100106);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (CertRevokedException e) {
                    SynLogger.log((Throwable)e);
                    res.setResult(-100108);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (VerifyOCSPException e) {
                    SynLogger.log((Throwable)e);
                    res.setResult(-100107);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (Exception e) {
                    SynLogger.log((Throwable)e);
                    res.setResult(-100004);
                    res.setErrMsg("upload RAWCert failed:" + e.toString());
                }
            } else {
                SynLogger.log((String)("Syn upload cert cannot find trust cert by issuerDN: " + issuerDN));
                res.setResult(-100048);
                res.setErrMsg("Can not find trust cert by the dn of the cert.");
            }
        }
        return res;
    }

    private Map getTrustConfig(Map serverChannels, String issuerDN) {
        issuerDN = CryptoUtil.trimDN((String)issuerDN);
        String turnDN = CryptoUtil.turnDN((String)issuerDN);
        ServerChannel[] scs = serverChannels.values().toArray(new ServerChannel[0]);
        int i = 0;
        int length = scs.length;
        while (i < length) {
            Map tcs;
            ServerChannel sc = scs[i];
            if (sc.getResourcePool() != null && sc.getResourcePool().get(this.certList.getName()) != null && (tcs = sc.getTrustConfigs()) != null) {
                TrustConfig tc = null;
                tc = (TrustConfig)tcs.get(issuerDN);
                if (tc == null && tcs.size() > 0) {
                    tc = (TrustConfig)tcs.get(turnDN);
                }
                if (tc != null) {
                    return tcs;
                }
            }
            ++i;
        }
        return null;
    }
}

