/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.CertSYNParameters;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.logger.SynLogger;
import java.io.FileOutputStream;
import java.util.HashMap;

public class SYNUploadBankInfoProcessor
implements Processor {
    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        byte[] bs = null;
        String listname = null;
        CertSYNParameters synpara = null;
        HashMap map = (HashMap)req.getContent();
        byte[] rawPara = (byte[])map.get("rawSynPara");
        boolean needauth = (Boolean)map.get("needauth");
        int authtype = -1;
        try {
            synpara = CertSYNParameters.ByteArrays2Object((byte[])rawPara);
        }
        catch (Exception e1) {
            SynLogger.log((String)"( SynUploadBankInfoProcessor )Tranform CertSYNParameters 2 byteArrays failed. Caused by: ");
            SynLogger.log((Throwable)e1);
        }
        HostOfRAWCert desthost = null;
        boolean needauthSelf = false;
        String authcode = null;
        if (needauth) {
            byte[] authcodedigest = (byte[])map.get("authcode");
            desthost = ProcessUtil.findAuthCodeforVerify(authcodedigest);
            if (desthost != null) {
                needauthSelf = desthost.isNeedauth();
                authcode = desthost.getAuthCode();
            }
            authtype = (Integer)map.get("authtype");
            if (authcode == null) {
                SynLogger.log((String)"SynUploadBankInfo failed, Caused by: Can't find corresponding authcode with req.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        if (needauthSelf && authcode != null) {
            if (needauth) {
                byte[] encrySynPara = (byte[])map.get("encrySynPara");
                MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
                boolean isverifyok = auther.verifyAuthMessage(rawPara, authcode, encrySynPara);
                if (!isverifyok) {
                    SynLogger.log((String)"SynUploadBankInfo failed, Caused by: Syn parameters can't verified.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            } else {
                SynLogger.log((String)"SynUploadBankInfo failed, Caused by: Syn parameters need to verify, there are not auth-message. Can't to verify.");
                res.setResult(-100180);
                res.setErrMsg("SYNParameters can't verifed.");
                return res;
            }
        }
        if ((bs = synpara.getBankinfo()) == null || bs.length == 0) {
            SynLogger.log((String)"SynUploadBankInfoProcessor failed -100041 ");
            res.setResult(-100041);
            res.setErrMsg("No bankinfo received");
            return res;
        }
        listname = synpara.getListname();
        PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByName((String)listname);
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)ResourceManager.getAllResourceList().getResourceList((ResourceListFilter)query);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(certList.getDetailFile());
            out.write(bs);
            out.flush();
            SynLogger.log((String)"SynUploadBankInfoProcessor finished");
            certList.log("Detail file updated by SYN.");
            AdminMessage adminMessage = res;
            return adminMessage;
        }
        catch (Exception e) {
            SynLogger.log((String)("SynUploadBankInfoProcessor failed -100221 " + e.toString()));
            SynLogger.log((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg("Save file IO error");
            AdminMessage adminMessage = res;
            return adminMessage;
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

