/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxyFactory;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.CertSYNParameters;
import cn.com.infosec.netsign.synfwimpl.CertSYNResult;
import cn.com.infosec.netsign.synfwimpl.config.HostOfRAWCert;
import cn.com.infosec.synfw.auth.MessageAuth;
import cn.com.infosec.synfw.auth.MessageAuthFactory;
import cn.com.infosec.synfw.logger.SynLogger;
import java.io.FileInputStream;
import java.util.HashMap;

public class SYNDownloadBankInfoProcessor
implements Processor {
    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        byte[] bs;
        int authtype;
        boolean needauth;
        AdminMessage res;
        block25: {
            res = ProcessUtil.createAdminMessage(request);
            AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
            String listname = null;
            CertSYNParameters synpara = null;
            HashMap map = (HashMap)req.getContent();
            byte[] rawPara = (byte[])map.get("rawSynPara");
            needauth = (Boolean)map.get("needauth");
            authtype = -1;
            try {
                synpara = CertSYNParameters.ByteArrays2Object((byte[])rawPara);
            }
            catch (Exception e1) {
                SynLogger.log((String)"( SYNDownloadBankInfoProcessor )Tranform CertSYNParameters 2 byteArrays failed. Caused by: ");
                SynLogger.log((Throwable)e1);
            }
            HostOfRAWCert desthost = null;
            boolean needauthSelf = false;
            String authcode = null;
            if (needauth) {
                byte[] authcodedigest = (byte[])map.get("authcode");
                desthost = ProcessUtil.findAuthCodeforVerify(authcodedigest);
                if (desthost != null) {
                    needauthSelf = desthost.isNeedauth();
                    authcode = desthost.getAuthCode();
                }
                authtype = (Integer)map.get("authtype");
                if (authcode == null) {
                    SynLogger.log((String)"SYNDownloadBankInfo failed, Caused by: Can't find corresponding authcode with req.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            }
            if (needauthSelf && authcode != null) {
                if (needauth) {
                    byte[] encrySynPara = (byte[])map.get("encrySynPara");
                    MessageAuth auther = MessageAuthFactory.getInstance((int)authtype);
                    boolean isverifyok = auther.verifyAuthMessage(rawPara, authcode, encrySynPara);
                    if (!isverifyok) {
                        SynLogger.log((String)"SYNDownloadBankInfo failed, Caused by: Syn parameters can't verified.");
                        res.setResult(-100180);
                        res.setErrMsg("SYNParameters can't verifed.");
                        return res;
                    }
                } else {
                    SynLogger.log((String)"SYNDownloadBankInfo failed, Caused by: Syn parameters need to verify, there are not auth-message. Can't to verify.");
                    res.setResult(-100180);
                    res.setErrMsg("SYNParameters can't verifed.");
                    return res;
                }
            }
            listname = synpara.getListname();
            PBCRAWCertProxy query = PBCRAWCertProxyFactory.getFindResourceListByName((String)listname);
            PBCRAWCertResourceList certList = (PBCRAWCertResourceList)ResourceManager.getAllResourceList().getResourceList((ResourceListFilter)query);
            FileInputStream in = null;
            bs = new byte[]{};
            if (certList != null) {
                try {
                    try {
                        in = new FileInputStream(certList.getDetailFile());
                        bs = new byte[in.available()];
                        in.read(bs);
                        SynLogger.log((String)("SynDownLoafBankInfo for " + listname + " exist"));
                    }
                    catch (Exception e) {
                        SynLogger.log((String)("SynDownLoafBankInfo for " + listname + " did not exist"));
                        try {
                            if (in != null) {
                                in.close();
                            }
                            break block25;
                        }
                        catch (Exception exception) {}
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (in != null) {
                            in.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            } else {
                res.setResult(-100280);
                res.setErrMsg("No resource list " + listname + " found.");
                return res;
            }
        }
        CertSYNResult result = new CertSYNResult();
        result.setBankinfo(bs);
        res = ProcessUtil.fillContent2Res(res, result, needauth, authtype);
        return res;
    }
}

