/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.base.util.WeekAlgorithmUtil;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class RAWVerifyProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private String provider = "INFOSEC";

    public RAWVerifyProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public RAWVerifyProcessor(ServerChannel channel) {
        this.channel = channel;
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public Response process(Request req) {
        PublicKey key;
        X509Certificate cert;
        NSMessageOpt res;
        String failedMsg;
        NSMessage request;
        NetSignRequest nsreq;
        block14: {
            PBCRAWCertResourceList certlist;
            PBCRAWCert pcert;
            String certDN;
            nsreq = (NetSignRequest)req;
            request = nsreq.getNSMessage();
            failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " RAWVerify failed:";
            res = ProcessUtil.createNSMessageOpt(request);
            cert = request.getCert();
            if (cert == null && (certDN = request.getSignCertDN()) != null && (pcert = ProcessUtil.getPBCRAWCert(certDN, certlist = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName()))) != null) {
                cert = pcert.getCert();
            }
            key = null;
            if (cert != null) {
                try {
                    if (Utils.getCertType(cert) == 1) {
                        SM2Certificate sm2cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                        key = sm2cert.getPublicKey();
                        break block14;
                    }
                    key = cert.getPublicKey();
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                }
            } else {
                key = request.getPublicKey();
            }
        }
        if (key == null) {
            res.setResult(-100205);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100205));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] cryptoText = request.getCryptoText();
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, key);
        NetSignImpl impl = new NetSignImpl();
        try {
            boolean flag;
            WeekAlgorithmUtil.isWeekAlg4Verify(key, digestAlg);
            DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
            if (digestam == null) {
                throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
            }
            if (cert != null && this.channel.getService().isVerifyCert()) {
                impl.verifySingleSignedCert(cert, null, this.channel.getTrustConfigs(), this.channel.isCheckValidity());
            }
            if (!(flag = SoftCryptoImpl.verify((PublicKey)key, (byte[])plainText, (byte[])cryptoText, (String)digestAlg, (String)ExtendedConfig.getVerifyProvider()))) {
                throw new VerifySignatureException(" signature was not verified");
            }
        }
        catch (Exception ex) {
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (ExtendedConfig.isReturnVerifyResult()) {
            res.setDigestAlg(digestAlg);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " RAWVerify success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

