/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.WeekAlgorithmUtil;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.manager.CryptoManager;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.oscca.SDFJNI;
import cn.com.infosec.oscca.sm2.SM2PrivateKey;
import cn.com.infosec.oscca.sm2.SM2PublicKey;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;

public class RAWSignProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certList;

    public RAWSignProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    private static byte[] generateSignMsg(byte[] plainText, ServerKeyStore keyStore, String digestAlg, AbstractMessage res, boolean usedHardWare, String provider) {
        byte[] signedMsg = null;
        if (keyStore == null) {
            res.setResult(-100204);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
            return signedMsg;
        }
        PrivateKey prik = keyStore.getPrivateKey();
        if (prik instanceof SM2PrivateKey) {
            if (usedHardWare) {
                try {
                    signedMsg = SDFJNI.SM2SignWithExternalKey((byte[])plainText, (String)digestAlg, (byte[])((SM2PrivateKey)keyStore.getPrivateKey()).getD(), (SM2PublicKey)((SM2PublicKey)keyStore.getPublicKey()), (byte[])Utils.getOSCCApucID(2, null));
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            } else {
                try {
                    signedMsg = SDFJNI.SM2SignWithExternalKey((byte[])plainText, (String)digestAlg, (byte[])((SM2PrivateKey)keyStore.getPrivateKey()).getD(), (SM2PublicKey)((SM2PublicKey)keyStore.getPublicKey()), (byte[])Utils.getOSCCApucID(2, null));
                }
                catch (Exception ex) {
                    ProcessUtil.throwDetailException(ex, res);
                }
            }
        } else if (usedHardWare) {
            try {
                DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
                if (digestam == null) {
                    throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
                }
                signedMsg = CryptoManager.getHardCryptoImpl().SignWithAlg(keyStore.getLabel(), plainText, digestam.getValue());
            }
            catch (Exception ex) {
                ProcessUtil.throwDetailException(ex, res);
            }
        } else {
            try {
                DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
                if (digestam == null) {
                    throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
                }
                WeekAlgorithmUtil.isWeekAlg4Sign(keyStore.getPrivateKey(), digestAlg);
                signedMsg = SoftCryptoImpl.sign((PrivateKey)keyStore.getPrivateKey(), (byte[])plainText, (String)digestAlg, (String)provider);
            }
            catch (Exception ex) {
                ProcessUtil.throwDetailException(ex, res);
            }
        }
        return signedMsg;
    }

    public RAWSignProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " RAWSign failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String certDN = request.getSignCertDN();
        certDN = "".equals(certDN) ? null : certDN;
        ServerKeyStore ks = null;
        if (certDN != null) {
            ks = this.channel.getSignKeyStore(certDN);
            if (ks == null) {
                this.certList = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
                PBCRAWCert cert = ProcessUtil.getPBCRAWCert(certDN, this.certList);
                if (cert != null && cert.getCertDN() != null) {
                    ks = this.channel.getSignKeyStore(cert.getCertDN());
                }
            }
        } else {
            ks = this.channel.getSignKeyStore(certDN);
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, ks);
        byte[] signedMsg = RAWSignProcessor.generateSignMsg(plainText, ks, digestAlg, res, this.channel.isUsedHardware(), ExtendedConfig.getSignProvider());
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (ExtendedConfig.isReturnSignResult()) {
            res.setCryptoText(signedMsg);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " RAWSign success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

