/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.PDFVerifyResult;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.PDFUtil;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.NotInTrustListException;
import cn.com.infosec.netsign.base.util.TrustConfig;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfPKCS7;
import com.itextpdf.text.pdf.PdfReader;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;

public class PDFVerifyProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private String provider = "INFOSEC";

    public PDFVerifyProcessor() {
    }

    public PDFVerifyProcessor(ServerChannel channel) {
        this.channel = channel;
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " PDFVerify failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] pdf = request.getPlainText();
        pdf = ProcessUtil.disassemble(pdf, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (!PDFUtil.isValid(pdf)) {
            res.setResult(-100233);
            res.setErrMsg("Collisions in PDF Signatures!");
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] passwd = request.getPdfpasswd();
        PdfReader reader = null;
        try {
            reader = passwd == null ? new PdfReader(pdf) : new PdfReader(pdf, passwd);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            failedMsg = String.valueOf(failedMsg) + "Parse pdf file failed:" + e.toString();
            res.setResult(-100228);
            res.setErrMsg(failedMsg);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        AcroFields af = reader.getAcroFields();
        ArrayList names = af.getSignatureNames();
        if (names == null || names.size() == 0) {
            failedMsg = String.valueOf(failedMsg) + "no signature found in the pdf file";
            res.setResult(-100236);
            res.setErrMsg(failedMsg);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        ArrayList<PDFVerifyResult> results = new ArrayList<PDFVerifyResult>();
        boolean allok = true;
        NetSignImpl impl = new NetSignImpl();
        int i = 0;
        int size = names.size();
        while (i < size) {
            block20: {
                PDFVerifyResult pvr = new PDFVerifyResult();
                String signName = (String)names.get(i);
                pvr.setFieldName(signName);
                PdfPKCS7 pdfp7 = null;
                try {
                    pdfp7 = af.verifySignature(signName, ExtendedConfig.getVerifyProvider());
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                    allok = false;
                    pvr.setReturnCode(-100103);
                    results.add(pvr);
                    break block20;
                }
                if (this.channel.getService().isVerifyCert()) {
                    this.verifyCertificate(pdfp7, res, pvr, impl);
                }
                if (request.isTransCert()) {
                    try {
                        pvr.setB64cert(Base64.encode((byte[])pdfp7.getSigningCertificate().getEncoded()));
                    }
                    catch (Exception e) {
                        ConsoleLogger.logException((Throwable)e);
                    }
                }
                boolean isverified = false;
                try {
                    isverified = pdfp7.verify();
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                }
                if (!isverified) {
                    pvr.setReturnCode(-100104);
                }
                if (pvr.getReturnCode() != 1) {
                    allok = false;
                }
                results.add(pvr);
            }
            ++i;
        }
        if (ExtendedConfig.isReturnVerifyResult()) {
            res.setPDFVerifyResults(results);
        }
        if (!allok) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getPDFVerifyResults2Trans(), this.channel.getLogLevel(), nsreq, res);
        } else {
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " PDFVerify success", this.channel.getLogLevel(), nsreq, res);
        }
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    private void verifyCertificate(PdfPKCS7 pdfp7, NSMessageOpt res, PDFVerifyResult pvr, NetSignImpl impl) {
        try {
            X509Certificate signCert = pdfp7.getSigningCertificate();
            pvr.setSubject(signCert.getSubjectDN().getName());
            pvr.setSn(signCert.getSerialNumber());
            pvr.setIssuerSubject(signCert.getIssuerDN().getName());
            pvr.setNotAfter(signCert.getNotAfter().getTime() / 1000L);
            pvr.setNotBefore(signCert.getNotBefore().getTime() / 1000L);
            Map tcs = this.channel.getTrustConfigs();
            TrustConfig tcg = (TrustConfig)tcs.get(pvr.getIssuerSubject());
            if (tcg != null) {
                tcg.VerifyCert(signCert, signCert.getTBSCertificate(), this.channel.isCheckValidity(), this.provider, pvr.getNotBefore(), pvr.getNotAfter());
                if (tcg.isOCSPEnabled()) {
                    tcg.VerifyOCSP(signCert);
                } else if (tcg.isCrlEnabled()) {
                    NetSignImpl.checkCrlVerifyResult(tcg.VerifyCRL(signCert));
                }
            } else {
                Certificate[] allCerts = pdfp7.getCertificates();
                if (allCerts == null || allCerts.length < 2) {
                    throw new NotInTrustListException("Not in trust list");
                }
                impl.verifyCert(signCert, allCerts, tcs, this.channel.isCheckValidity());
            }
        }
        catch (Exception e) {
            this.setPDFVerifyError(e, pvr);
        }
    }

    private void setPDFVerifyError(Exception e, PDFVerifyResult pvr) {
        ConsoleLogger.logException((Throwable)e);
        if (e instanceof VerifyOCSPException) {
            pvr.setReturnCode(-100107);
            return;
        }
        if (e instanceof CertRevokedException) {
            pvr.setReturnCode(-100108);
            return;
        }
        if (e instanceof CertValidateException) {
            pvr.setReturnCode(-100106);
            return;
        }
        if (e instanceof CertTrustException) {
            pvr.setReturnCode(-100105);
            return;
        }
        if (e instanceof NotInTrustListException) {
            pvr.setReturnCode(-100124);
            return;
        }
        pvr.setReturnCode(-100004);
    }

    private String[] getCertInfo(X509Certificate signCert) {
        String[] certinfo = new String[5];
        certinfo[0] = signCert.getSubjectDN().getName();
        certinfo[1] = signCert.getIssuerDN().getName();
        long signCertNotBefore = signCert.getNotBefore().getTime() / 1000L;
        long signCertNotAfter = signCert.getNotAfter().getTime() / 1000L;
        certinfo[2] = String.valueOf(signCertNotBefore);
        certinfo[3] = String.valueOf(signCertNotAfter);
        certinfo[4] = signCert.getSerialNumber().toString(16).toUpperCase();
        return certinfo;
    }
}

