/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;

public class PBCSHLCDetachedSignProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certList;

    public void setChannel(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " PBCSHLCDetachedSign failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String certDN = request.getSignCertDN();
        ServerKeyStore sk = null;
        sk = this.channel.getSignKeyStore(certDN);
        if (sk == null && certDN != null && !certDN.equals("")) {
            this.certList = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
            PBCRAWCert cert = ProcessUtil.getPBCRAWCert(certDN, this.certList);
            if (cert != null && cert.getCertDN() != null) {
                sk = this.channel.getSignKeyStore(cert.getCertDN());
            }
        }
        byte[] signedMsg = ProcessUtil.generateSignMsg(plainText, sk, ProcessUtil.getDigestAlgoritim(request, this.channel, sk), true, res, this.channel.isUsedHardware(), ExtendedConfig.getSignProvider(), "PBC Shanghai local clearing");
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        if (ExtendedConfig.isReturnSignResult()) {
            res.setCryptoText(signedMsg);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " PBCSHLCDetachedSign success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

