/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NetSignX509Certificate;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;

public class MakeEnvelopedMSGProcessor
implements NetSignProcessor {
    private ServerChannel channel = null;

    public MakeEnvelopedMSGProcessor() {
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    private NetSignX509Certificate getEncCert(NSMessage request, AbstractMessage response) {
        NetSignX509Certificate cert = null;
        if (request.isTransCert()) {
            cert = NetSignX509Certificate.getInstance(request.getCert());
            if (cert == null) {
                cert = this.channel.getEnvelopeCert();
            }
        } else {
            cert = this.channel.getEnvelopeCert(request.getEncCertDN());
        }
        return cert;
    }

    private byte[] composeEnvelopedMsg(byte[] plainText, NetSignX509Certificate cert, String symmetricalAlg, AbstractMessage response) {
        if (cert == null) {
            response.setResult(-100202);
            response.setErrMsg(ErrorInfoRes.getErrorInfo(-100202));
            return null;
        }
        NetSignImpl impl = new NetSignImpl();
        byte[] cryptoText = null;
        if (this.channel.isUsedHardware()) {
            try {
                cryptoText = impl.composeHardSingleEnvelopedMsg(plainText, cert.getCert(), symmetricalAlg);
            }
            catch (Exception ex) {
                ProcessUtil.throwDetailException(ex, response);
            }
        } else {
            try {
                cryptoText = impl.composeSingleEnvelopedMsg(plainText, cert.getCert(), symmetricalAlg, ExtendedConfig.getEncryptProvider(), cert.getPublicKey());
            }
            catch (Exception ex) {
                ProcessUtil.throwDetailException(ex, response);
            }
        }
        return cryptoText;
    }

    public MakeEnvelopedMSGProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " MakeEnvelope failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        byte[] plainText = request.getPlainText();
        plainText = ProcessUtil.disassemble(plainText, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        NetSignX509Certificate enccert = this.getEncCert(request, res);
        if (enccert == null) {
            res.setResult(-100203);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100203));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] envelopeData = this.composeEnvelopedMsg(plainText, enccert, ProcessUtil.getSymmetricalAlgorithm(request, this.channel), res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        envelopeData = ProcessUtil.assembleOnlyZip(envelopeData, request, res);
        if (res.getResult() > 0) {
            res.setCryptoText(envelopeData);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " MakeEnvelope success", this.channel.getLogLevel(), nsreq, res);
        } else {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
        }
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

