/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;

public class DownloadRAWCertProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public DownloadRAWCertProcessor() {
    }

    public DownloadRAWCertProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String dn = request.getSignCertDN();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " download raw cert " + dn + " failed:";
        NSMessage res = ProcessUtil.createNSMessage(request);
        if (dn == null || dn.equals("")) {
            res.setResult(-100225);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100225));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100225, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PBCRAWCertResourceList certList = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, request.getResourceName());
        PBCRAWCert cert = ProcessUtil.getPBCRAWCert(dn, certList);
        if (cert == null || cert.getCert() == null) {
            res.setResult(-100224);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100224, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setCert(cert.getCert());
        res.setTransCert(true);
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " Download cert " + dn + " success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

