/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public class DigestSignVerifyProcessor
implements NetSignProcessor {
    private ServerChannel channel = null;

    public DigestSignVerifyProcessor() {
    }

    public DigestSignVerifyProcessor(ServerChannel c) {
        this.channel = c;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DigestSignVerify failed";
        X509Certificate cert = request.getCert();
        if (cert == null || cert.getPublicKey() == null) {
            this.setNoCertError(res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), failedMsg, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PublicKey key = null;
        if (Utils.getCertType(cert) == 1) {
            try {
                cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                key = cert.getPublicKey();
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
            }
        } else {
            key = cert.getPublicKey();
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, key);
        NetSignImpl impl = new NetSignImpl();
        try {
            DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
            if (digestam == null) {
                throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
            }
            if (this.channel.getService().isVerifyCert()) {
                impl.verifySingleSignedCert(cert, null, this.channel.getTrustConfigs(), this.channel.isCheckValidity());
            }
        }
        catch (Exception ex) {
            ConsoleLogger.logException((Throwable)ex);
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        try {
            Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", "INFOSEC");
            c.init(2, cert.getPublicKey());
            byte[] digest = c.doFinal(request.getCryptoText());
            if (!this.verify(request.getHashValue(), digest)) {
                throw new VerifySignatureException(" signature was not verified");
            }
            this.setResponse(res, request.getCert());
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DigestSignVerify success", this.channel.getLogLevel(), nsreq, res);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            ProcessUtil.throwDetailException(e, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }

    private void printbytearray(String s, byte[] abyte0) {
    }

    private void setResponse(NSMessageOpt resp, X509Certificate cert) {
        String signSubject = cert.getSubjectX500Principal().getName();
        resp.setSignSubject(signSubject);
        String signSerNumber = cert.getSerialNumber().toString();
        resp.setSignSerNumber(signSerNumber);
        String signIssuerSubject = cert.getIssuerX500Principal().getName();
        resp.setSignIssuerSubject(signIssuerSubject);
        String signStartTime = String.valueOf(cert.getNotBefore().getTime() / 1000L);
        resp.setSignStartTime(signStartTime);
        String signEndTime = String.valueOf(cert.getNotAfter().getTime() / 1000L);
        resp.setSignEndTime(signEndTime);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean verify(byte[] hashValue, byte[] digest) {
        try {
            int add = digest.length - hashValue.length;
            int i = hashValue.length;
            while (true) {
                if (i <= 0) {
                    return true;
                }
                if (hashValue[i - 1] != digest[i + add - 1]) {
                    return false;
                }
                --i;
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            return false;
        }
    }

    private void setNoCertError(AbstractMessage res) {
        res.setResult(-100205);
        res.setErrMsg(ErrorInfoRes.getErrorInfo(-100205));
    }
}

