/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.resources.ResourceDeleter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;

public class DeleteRAWCertProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private PBCRAWCertResourceList certList;

    public DeleteRAWCertProcessor() {
    }

    public DeleteRAWCertProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request request) {
        NetSignRequest nsreq = (NetSignRequest)request;
        NSMessage req = nsreq.getNSMessage();
        NSMessage res = ProcessUtil.createNSMessage(req);
        String dn = req.getSignCertDN();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + req.getAddress() + " delete raw cert " + dn + " failed:";
        if (dn == null || dn.equals("")) {
            res.setResult(-100205);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100205));
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), req, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100205, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        this.certList = (PBCRAWCertResourceList)ProcessUtil.getResourceList(this.channel, req.getResourceName());
        if (this.certList == null) {
            res.setResult(-100280);
            res.setErrMsg("DeleteRAWCertProcessor no certificate list found in this channel");
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), req, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100280, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        PBCRAWCert cert = new PBCRAWCert();
        cert.setCertDN(dn);
        PBCRAWCert certtemp = ProcessUtil.getPBCRAWCert(dn, this.certList);
        if (certtemp != null) {
            cert = certtemp;
        }
        cert.addModifyTime();
        if (dn != null && SynConfig.getHostslist().size() > 0) {
            PBCRAWCertSynManager synmanager = PBCRAWCertSynManagerFactory.getSynManager();
            CertTask task = CertTask.getInstance(null, (String)this.certList.getName(), (String)dn, (String)"syndeleteresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)cert);
            synmanager.realTimeSyn((Task)task);
        }
        PBCRAWCertProxy query = new PBCRAWCertProxy();
        query.setType(4002);
        query.addCondition("resource", (Object)cert);
        try {
            if (!this.certList.deleteResource((ResourceDeleter)query)) {
                this.certList.log("DeleteRAWCertProcessor deleted cert " + dn + " failed");
                res.setResult(-100224);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100205));
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), req, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100224, this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
            this.certList.log("DeleteRAWCertProcessor deleted cert " + dn);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " DeleteRAWCertProcessor deleted " + dn + " successed.", this.channel.getLogLevel(), nsreq, res);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100221);
            res.setErrMsg(e.toString());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), req, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + " save bankinfo.conf failed", this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setResult(1);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

