/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.NetSignX509Certificate;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;

public class DecryptoMSEnvelopedMSGProcessor
implements NetSignProcessor {
    private ServerChannel channel;

    public DecryptoMSEnvelopedMSGProcessor() {
    }

    public DecryptoMSEnvelopedMSGProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DecryptoMSEnvelope failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        byte[] cryptotext = request.getCryptoText();
        byte[] plaintext = ProcessUtil.disassemble(cryptotext, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] plain = null;
        String[] enccertinfo = new String[5];
        String[] signcertinfo = new String[5];
        NetSignImpl netsignimpl = new NetSignImpl();
        NetSignX509Certificate sk = this.channel.getEnvelopeCert(request.getEncCertDN());
        if (sk == null) {
            res.setResult(-100203);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100203)) + " : " + request.getEncCertDN());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100203, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] plaintemp = null;
        if (this.channel.isUsedHardware()) {
            try {
                plaintemp = netsignimpl.decomposeHardSingleEnvelopedMsg(plaintext, sk.getCert(), sk.getKeyLable().getBytes());
                enccertinfo = netsignimpl.getEncCertInfo();
                netsignimpl.verifyHardSignedMsg(plaintemp, this.channel.getTrustConfigs(), this.channel.isCheckValidity());
                plain = netsignimpl.getContentData();
                signcertinfo = netsignimpl.getSignCertInfo();
            }
            catch (Exception ex) {
                res.setResult(-100212);
                res.setErrMsg(ErrorInfoRes.getErrorInfo(-100212));
                ProcessUtil.throwDetailException(ex, res);
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
        }
        try {
            if (sk.getPrivateKey() == null) {
                res.setResult(-100204);
                res.setErrMsg("No private key bond to this certificate : " + request.getEncCertDN());
                ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100204, this.channel.getLogLevel(), nsreq, res);
                return NetSignResponse.createNetSignResponse(res, nsreq);
            }
            String provider = ExtendedConfig.getDecryptProvider();
            plaintemp = netsignimpl.decomposeSingleEnvelopedMsg(plaintext, sk.getCert(), sk.getPrivateKey(), provider);
            enccertinfo = netsignimpl.getEncCertInfo();
            String digestAlg = request.getDigestAlg();
            provider = ExtendedConfig.getVerifyProvider();
            netsignimpl.VerifySingleSignedMsg(plaintemp, null, this.channel.getTrustConfigs(), provider, digestAlg, this.channel.isCheckValidity(), this.channel.getService().isVerifyCert());
            plain = netsignimpl.getContentData();
            signcertinfo = netsignimpl.getSignCertInfo();
        }
        catch (Exception ex) {
            res.setResult(-100212);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100212));
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setDigestAlg(netsignimpl.getDigestAlg());
        res.setSymmetricalAlg(netsignimpl.getEncAlg());
        res.setEncEndTime(enccertinfo[3]);
        res.setEncIssuerSubject(enccertinfo[1]);
        res.setEncSerNumber(enccertinfo[4]);
        res.setEncStartTime(enccertinfo[2]);
        res.setEncSubject(enccertinfo[0]);
        res.setSignEndTime(signcertinfo[3]);
        res.setSignIssuerSubject(signcertinfo[1]);
        res.setSignSerNumber(signcertinfo[4]);
        res.setSignStartTime(signcertinfo[2]);
        res.setSignSubject(signcertinfo[0]);
        byte[] assembletext = ProcessUtil.assemble(plain, this.channel.getCryptoUtil(), request, res);
        if (res.getResult() > 0) {
            res.setPlainText(assembletext);
        } else {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DecryptoMSEnvelope success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

