/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.NetSignX509Certificate;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class DecryptoEnvelopedMSGProcessor
implements NetSignProcessor {
    private ServerChannel channel = null;

    public DecryptoEnvelopedMSGProcessor() {
    }

    public DecryptoEnvelopedMSGProcessor(ServerChannel channel) {
        this.channel = channel;
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
    }

    public Response process(Request req) {
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DecryptoEnvelope failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        byte[] assembltext = request.getCryptoText();
        byte[] disassembletext = ProcessUtil.disassemble(assembltext, this.channel.isCryptoCommunicate(), this.channel.getCryptoUtil(), request, res);
        if (res.getResult() < 0) {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        String certdn = request.getEncCertDN();
        NetSignImpl netsignimpl = new NetSignImpl();
        NetSignX509Certificate sk = this.channel.getEnvelopeCert(certdn);
        X509Certificate x509 = null;
        PrivateKey prik = null;
        Object ks = null;
        if (sk == null) {
            res.setResult(-100203);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100203)) + " : " + request.getEncCertDN());
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100203, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        x509 = sk.getCert();
        prik = sk.getPrivateKey();
        String[] enccertinfo = null;
        byte[] plaintext = null;
        try {
            if (this.channel.isUsedHardware()) {
                netsignimpl.decomposeHardSingleEnvelopedMsg(disassembletext, x509, sk.getKeyLable().getBytes());
            } else {
                if (prik == null) {
                    res.setResult(-100204);
                    res.setErrMsg("No private key bond to this certificate : " + request.getEncCertDN());
                    ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
                    ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100204, this.channel.getLogLevel(), nsreq, res);
                    return NetSignResponse.createNetSignResponse(res, nsreq);
                }
                String provider = ExtendedConfig.getDecryptProvider();
                netsignimpl.decomposeSingleEnvelopedMsg(disassembletext, x509, prik, provider);
            }
            enccertinfo = netsignimpl.getEncCertInfo();
            plaintext = netsignimpl.getContentData();
        }
        catch (Exception ex) {
            res.setResult(-100212);
            res.setErrMsg(ErrorInfoRes.getErrorInfo(-100212));
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + -100212, this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setSymmetricalAlg(netsignimpl.getEncAlg());
        res.setEncEndTime(enccertinfo[3]);
        res.setEncIssuerSubject(enccertinfo[1]);
        res.setEncSerNumber(enccertinfo[4]);
        res.setEncStartTime(enccertinfo[2]);
        res.setEncSubject(enccertinfo[0]);
        assembltext = ProcessUtil.assemble(plaintext, this.channel.getCryptoUtil(), request, res);
        if (res.getResult() > 0) {
            res.setPlainText(assembltext);
        } else {
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
        }
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " DecryptoEnvelope success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

