/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.isfw2.sfw.Request;
import cn.com.infosec.isfw2.sfw.Response;
import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.NSMessage;
import cn.com.infosec.netsign.base.NSMessageOpt;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.ServerKeyStore;
import cn.com.infosec.netsign.base.util.Utils;
import cn.com.infosec.netsign.base.util.VerifySignatureException;
import cn.com.infosec.netsign.crypto.algorithm.DigestAlgorithm;
import cn.com.infosec.netsign.crypto.util.AlgorithmUtil;
import cn.com.infosec.netsign.crypto.util.Base64;
import cn.com.infosec.netsign.crypto.util.SoftCryptoImpl;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.isfwimpl.NetSignProcessor;
import cn.com.infosec.netsign.isfwimpl.NetSignRequest;
import cn.com.infosec.netsign.isfwimpl.NetSignResponse;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.oscca.sm2.SM2Certificate;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class CPICRAWVerifyProcessor
implements NetSignProcessor {
    private ServerChannel channel;
    private String provider = "INFOSEC";

    public CPICRAWVerifyProcessor() {
    }

    public CPICRAWVerifyProcessor(ServerChannel channel) {
        this.channel = channel;
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    private void setNoCertError(AbstractMessage res) {
        res.setResult(-100204);
        res.setErrMsg(ErrorInfoRes.getErrorInfo(-100204));
    }

    public void setChannel(ServerChannel channel) {
        if (this.channel != channel) {
            this.channel = channel;
        }
        this.provider = ExtendedConfig.getVerifyProvider();
    }

    public Response process(Request req) {
        ServerKeyStore sks;
        NetSignRequest nsreq = (NetSignRequest)req;
        NSMessage request = nsreq.getNSMessage();
        String failedMsg = String.valueOf(this.channel.getId()) + " " + request.getAddress() + " CPICRAWVerify failed:";
        NSMessageOpt res = ProcessUtil.createNSMessageOpt(request);
        byte[] cryptoText = request.getCryptoText();
        if (cryptoText == null || cryptoText.length == 0) {
            res.setResult(-100100);
            res.setErrMsg("Crypto text is null");
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        byte[] plainText = null;
        String snOrg = null;
        String sn = null;
        try {
            String cryptoTextStr = new String(cryptoText);
            String[] pieces = cryptoTextStr.split("#");
            cryptoText = Base64.decode((String)pieces[0]);
            byte[] bs = Base64.decode((String)pieces[1]);
            int index = 0;
            int i = 0;
            while (i < bs.length) {
                if (bs[i] == 35) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index < 1) {
                throw new RuntimeException("CPIC crypto text in wrong format");
            }
            snOrg = new String(bs, 0, index);
            sn = snOrg.startsWith("0") ? snOrg.substring(1) : snOrg;
            sn = sn.toUpperCase();
            plainText = new byte[bs.length - index - 1];
            System.arraycopy(bs, index + 1, plainText, 0, plainText.length);
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
            res.setResult(-100100);
            res.setErrMsg("Parse crypto text failed");
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        X509Certificate cert = request.getCert();
        PublicKey key = null;
        if (cert == null && (sks = this.channel.getSignKeyStoreBySN(sn)) != null) {
            cert = sks.getCert();
        }
        if (cert == null) {
            this.setNoCertError(res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        try {
            if (Utils.getCertType(cert) == 1) {
                SM2Certificate sm2cert = new SM2Certificate(cert, cert.getEncoded(), cert.getTBSCertificate());
                key = sm2cert.getPublicKey();
            } else {
                key = cert.getPublicKey();
            }
        }
        catch (Exception e) {
            ConsoleLogger.logException((Throwable)e);
        }
        String digestAlg = ProcessUtil.getDigestAlgoritim(request, this.channel, key);
        NetSignImpl impl = new NetSignImpl();
        try {
            boolean flag;
            DigestAlgorithm digestam = AlgorithmUtil.getDigestAlgByName((String)digestAlg);
            if (digestam == null) {
                throw new NoSuchAlgorithmException("The DigestAlgorithm " + digestAlg + " Can not been Supported");
            }
            if (cert != null && this.channel.getService().isVerifyCert()) {
                impl.verifySingleSignedCert(cert, null, this.channel.getTrustConfigs(), this.channel.isCheckValidity());
            }
            if (!(flag = SoftCryptoImpl.verify((PublicKey)key, (byte[])plainText, (byte[])cryptoText, (String)digestAlg, (String)this.provider))) {
                throw new VerifySignatureException(" signature was not verified");
            }
        }
        catch (Exception ex) {
            ProcessUtil.throwDetailException(ex, res);
            ProcessUtil.log(this.channel.getDebugLogger(), this.channel.getId(), request, res);
            ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(failedMsg) + res.getResult(), this.channel.getLogLevel(), nsreq, res);
            return NetSignResponse.createNetSignResponse(res, nsreq);
        }
        res.setDigestAlg(digestAlg);
        res.setPlainText(plainText);
        res.setSignEndTime(String.valueOf(cert.getNotAfter().getTime() / 1000L));
        res.setSignIssuerSubject(cert.getIssuerDN().toString());
        res.setSignSerNumber(snOrg);
        res.setSignStartTime(String.valueOf(cert.getNotBefore().getTime() / 1000L));
        String dn = cert.getSubjectDN().toString();
        res.setSignSubject(dn);
        res.setSignCertDN(dn);
        ProcessUtil.accessLog(this.channel.getAccessLogger(), String.valueOf(this.channel.getId()) + " " + request.getAddress() + " CPICRAWVerify success", this.channel.getLogLevel(), nsreq, res);
        return NetSignResponse.createNetSignResponse(res, nsreq);
    }
}

