/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.channels.ServerChannel;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.util.CertRevokedException;
import cn.com.infosec.netsign.base.util.CertTrustException;
import cn.com.infosec.netsign.base.util.CertValidateException;
import cn.com.infosec.netsign.base.util.NetSignImpl;
import cn.com.infosec.netsign.base.util.TrustConfig;
import cn.com.infosec.netsign.base.util.VerifyOCSPException;
import cn.com.infosec.netsign.crypto.util.CryptoUtil;
import cn.com.infosec.netsign.frame.config.ExtendedConfig;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.ChannelManager;
import cn.com.infosec.netsign.resources.ResourceListFilter;
import cn.com.infosec.netsign.resources.ResourceManager;
import cn.com.infosec.netsign.resources.ResourcePool;
import cn.com.infosec.netsign.resources.ResourceSetter;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCert;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertProxy;
import cn.com.infosec.netsign.resources.rawcert.PBCRAWCertResourceList;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManager;
import cn.com.infosec.netsign.synfwimpl.handle.PBCRAWCertSynManagerFactory;
import cn.com.infosec.netsign.synfwimpl.jmx.CertTask;
import cn.com.infosec.synfw.config.SynConfig;
import cn.com.infosec.synfw.jmx.Task;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;

public class AdminUploadCertProcessor
implements Processor {
    private PBCRAWCertResourceList certList = null;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res;
        block19: {
            res = ProcessUtil.createAdminMessage(request);
            AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
            HashMap content = (HashMap)req.getContent();
            ResourcePool rp = ResourceManager.getAllResourceList();
            String listName = (String)content.get("listname");
            PBCRAWCertProxy query = new PBCRAWCertProxy();
            query.setType(2001);
            query.addCondition("name", (Object)listName);
            this.certList = (PBCRAWCertResourceList)rp.getResourceList((ResourceListFilter)query);
            if (this.certList == null) {
                res.setResult(-100280);
                res.setErrMsg("Can not find resource list by name:" + listName);
                return res;
            }
            byte[] cert = (byte[])content.get("cert");
            String bankName = (String)content.get("bankName");
            if (bankName == null || bankName.equals("")) {
                res.setResult(-100042);
                res.setErrMsg("Bank name not received");
                return res;
            }
            String inBlack = (String)content.get("inBlack");
            if (inBlack == null || "".equals(inBlack)) {
                res.setResult(-100049);
                res.setErrMsg("inBlack parameter not received");
                return res;
            }
            String bankID = (String)content.get("bankID");
            if (cert == null) {
                res.setResult(-100035);
                res.setErrMsg("RAW cert not received");
                return res;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(cert);
            X509Certificate xcert = null;
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509FX", "INFOSEC");
                xcert = (X509Certificate)cf.generateCertificate(bais);
            }
            catch (Exception e) {
                ConsoleLogger.logException((Throwable)e);
                res.setResult(-100050);
                res.setErrMsg("Generate certificate failed:" + e.toString());
                return res;
            }
            if (xcert == null) {
                res.setResult(-100050);
                res.setErrMsg("Generate certificate failed");
                return res;
            }
            if (ExtendedConfig.isCheckBankID() && bankID != null && !bankID.equals("") && xcert.getSubjectDN().getName().indexOf(bankID) < 0) {
                res.setResult(-100227);
                res.setErrMsg("BankID:" + bankID + " not contaned in the subject:" + xcert.getSubjectDN().getName());
                return res;
            }
            PBCRAWCert rawCert = new PBCRAWCert();
            rawCert.setCert(xcert);
            rawCert.setPath(this.certList.getPath());
            rawCert.setBankName(bankName);
            rawCert.setBlackList(Boolean.parseBoolean(inBlack));
            if (bankID != null && !bankID.equals("")) {
                rawCert.setBankCode(bankID);
            }
            rawCert.addModifyTime();
            if (SynConfig.getHostslist().size() > 0) {
                PBCRAWCertSynManager synmanager = PBCRAWCertSynManagerFactory.getSynManager();
                CertTask task = null;
                task = CertTask.getInstance((String)bankID, (String)listName, (String)rawCert.getCertDN(), (String)"synuploadresource", (boolean)SynConfig.isCenter_host(), (PBCRAWCert)rawCert);
                synmanager.realTimeSyn((Task)task);
            }
            NetSignImpl impl = new NetSignImpl();
            Map channels = ChannelManager.getServerChannels();
            Map tcs = this.getTrustConfig(channels, rawCert.getIssuerDN());
            if (tcs != null) {
                try {
                    impl.verifyRAWCert(rawCert, tcs);
                    query.setType(3001);
                    query.addCondition("resource", (Object)rawCert);
                    if (this.certList.setResource((ResourceSetter)query)) {
                        this.certList.log("AdminUploadCertPorcessor certificate bankcode=[ " + bankID + " ] with certDN=[ " + rawCert.getCertDN() + " ] saved.");
                        break block19;
                    }
                    this.certList.log("AdminUploadCertPorcessor certificate bankcode=[ " + bankID + " ] with certDN=[ " + rawCert.getCertDN() + " ] not saved.");
                }
                catch (CertTrustException e) {
                    ConsoleLogger.logException((Throwable)e);
                    res.setResult(-100105);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (CertValidateException e) {
                    ConsoleLogger.logException((Throwable)e);
                    res.setResult(-100106);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (CertRevokedException e) {
                    ConsoleLogger.logException((Throwable)e);
                    res.setResult(-100108);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (VerifyOCSPException e) {
                    ConsoleLogger.logException((Throwable)e);
                    res.setResult(-100107);
                    res.setErrMsg("Verify RAWCert failed:" + e.toString());
                }
                catch (Exception e) {
                    ConsoleLogger.logException((Throwable)e);
                    res.setResult(-100004);
                    res.setErrMsg("upload RAWCert failed:" + e.toString());
                }
            } else {
                res.setResult(-100048);
                res.setErrMsg("Can not find trust cert by the dn of the cert.");
            }
        }
        return res;
    }

    private Map getTrustConfig(Map serverChannels, String issuerDN) {
        issuerDN = CryptoUtil.trimDN((String)issuerDN);
        String turnDN = CryptoUtil.turnDN((String)issuerDN);
        ServerChannel[] scs = serverChannels.values().toArray(new ServerChannel[0]);
        int i = 0;
        int length = scs.length;
        while (i < length) {
            Map tcs;
            ServerChannel sc = scs[i];
            if (sc.getResourcePool() != null && sc.getResourcePool().get(this.certList.getName()) != null && (tcs = sc.getTrustConfigs()) != null) {
                TrustConfig tc = null;
                tc = (TrustConfig)tcs.get(issuerDN);
                if (tc == null && tcs.size() > 0) {
                    tc = (TrustConfig)tcs.get(turnDN);
                }
                if (tc != null) {
                    return tcs;
                }
            }
            ++i;
        }
        return null;
    }
}

