/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.base.processors;

import cn.com.infosec.netsign.base.AbstractMessage;
import cn.com.infosec.netsign.base.AdminMessage;
import cn.com.infosec.netsign.base.ErrorInfoRes;
import cn.com.infosec.netsign.base.Processor;
import cn.com.infosec.netsign.base.processors.ProcessorException;
import cn.com.infosec.netsign.base.processors.util.MessageConvertor;
import cn.com.infosec.netsign.base.processors.util.ProcessUtil;
import cn.com.infosec.netsign.base.processors.util.ShellUtil;
import cn.com.infosec.netsign.frame.config.Service;
import cn.com.infosec.netsign.logger.ConsoleLogger;
import cn.com.infosec.netsign.manager.LogManager;
import cn.com.infosec.netsign.manager.NetSignServerGroup;

public class AddNewServerProcessor
implements Processor {
    private int id = 1;

    public AbstractMessage process(AbstractMessage request) throws ProcessorException {
        AdminMessage res = ProcessUtil.createAdminMessage(request);
        AdminMessage req = MessageConvertor.convertAdminMessage(request, res);
        if (res.getResult() < 0) {
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddServer failed");
            return res;
        }
        Service config = null;
        try {
            config = (Service)req.getContent();
        }
        catch (ClassCastException clsEx) {
            res.setResult(-100010);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100010)) + ": " + req.getContent().toString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddServer failed");
            return res;
        }
        String portCheck = ShellUtil.execShell("lsof -i:" + config.getPort());
        if (!portCheck.equals("")) {
            res.setResult(-100024);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100024)) + ":" + "service port already exist!");
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddServer failed");
            return res;
        }
        try {
            NetSignServerGroup.addServer(config);
        }
        catch (Throwable channelEx) {
            ConsoleLogger.logException((Throwable)channelEx);
            res.setResult(-100024);
            res.setErrMsg(String.valueOf(ErrorInfoRes.getErrorInfo(-100024)) + ": " + channelEx.getMessage());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + req.getString());
            LogManager.getDebugLogger().Log(String.valueOf(this.id) + " " + res.getProcessor() + ": " + res.getResult() + ", " + res.getErrMsg());
            LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddServer failed");
            return res;
        }
        LogManager.getAccessLogger().Log(String.valueOf(this.id) + " AddServer success");
        return res;
    }
}

